/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.util.collection;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;

public class FixedArrayQueue<E>
implements Queue<E> {
    private final int limit;
    private final int capacity;
    private final int mask;
    private final E[] buffer;
    private long head;
    private long tail;

    public FixedArrayQueue(int capacity) {
        this.limit = capacity;
        this.capacity = FixedArrayQueue.findNextPositivePowerOfTwo(capacity);
        this.mask = this.capacity - 1;
        this.buffer = new Object[this.capacity];
    }

    public static int findNextPositivePowerOfTwo(int size) {
        return 1 << 32 - Integer.numberOfLeadingZeros(size - 1);
    }

    @Override
    public boolean add(E e) {
        if (this.offer(e)) {
            return true;
        }
        throw new IllegalStateException("Queue is full");
    }

    @Override
    public boolean offer(E e) {
        if (null == e) {
            throw new NullPointerException("item cannot be null");
        }
        long currentTail = this.tail;
        if (currentTail - this.head == (long)this.limit) {
            return false;
        }
        this.buffer[(int)currentTail & this.mask] = e;
        this.tail = currentTail + 1L;
        return true;
    }

    @Override
    public E poll() {
        long currentHead = this.head;
        if (this.tail == currentHead) {
            return null;
        }
        int index = (int)currentHead & this.mask;
        E e = this.buffer[index];
        this.buffer[index] = null;
        this.head = currentHead + 1L;
        return e;
    }

    @Override
    public E remove() {
        E e = this.poll();
        if (null == e) {
            throw new IllegalStateException("Queue is empty");
        }
        return e;
    }

    @Override
    public E element() {
        E e = this.peek();
        if (null == e) {
            throw new NoSuchElementException("Queue is empty");
        }
        return e;
    }

    @Override
    public E peek() {
        return this.buffer[(int)this.head & this.mask];
    }

    @Override
    public int size() {
        long currentHead;
        long currentTail;
        int size;
        while ((size = (int)((currentTail = this.tail) - (currentHead = this.head))) > this.capacity) {
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        return this.tail == this.head;
    }

    @Override
    public boolean contains(Object o) {
        if (null == o) {
            return false;
        }
        long limit = this.tail;
        for (long i = this.head; i < limit; ++i) {
            E e = this.buffer[(int)i & this.mask];
            if (!o.equals(e)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        for (E o : c) {
            this.add(o);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

