/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.test.config;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.kaazing.gateway.server.test.config.Configuration;
import org.kaazing.gateway.server.test.config.ConfigurationVisitor;
import org.kaazing.gateway.server.test.config.Suppressible;
import org.kaazing.gateway.server.test.config.SuppressibleConfiguration;
import org.kaazing.gateway.server.test.config.SuppressibleNestedServicePropertiesConfiguration;
import org.kaazing.gateway.server.test.config.Suppressibles;

public class NestedServicePropertiesConfiguration
implements Configuration<SuppressibleNestedServicePropertiesConfiguration> {
    private String configElementName;
    private final SuppressibleNestedServicePropertiesConfiguration _configuration;
    private final Map<String, Suppressible<String>> suppressibleSimpleProperties = new HashMap<String, Suppressible<String>>();
    private final Map<String, String> simpleProperties = Suppressibles.unsuppressibleMap(this.suppressibleSimpleProperties);
    private final Stack<NestedServicePropertiesConfiguration> nestedServiceProperties = new Stack();

    public NestedServicePropertiesConfiguration(String configElementName) {
        this.configElementName = configElementName;
        this._configuration = new SuppressibleNestedServicePropertiesConfigurationImpl();
        this._configuration.setSuppression(Suppressibles.getDefaultSuppressions());
    }

    public Map<String, String> getSimpleProperties() {
        return this.simpleProperties;
    }

    public void addSimpleProperty(String key, String value) {
        this.simpleProperties.put(key, value);
    }

    public Collection<NestedServicePropertiesConfiguration> getNestedProperties() {
        return this.nestedServiceProperties;
    }

    public String getConfigElementName() {
        return this.configElementName;
    }

    public void setConfigElementName(String configElementName) {
        this.configElementName = configElementName;
    }

    @Override
    public void accept(ConfigurationVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public SuppressibleNestedServicePropertiesConfiguration getSuppressibleConfiguration() {
        return this._configuration;
    }

    private class SuppressibleNestedServicePropertiesConfigurationImpl
    extends SuppressibleNestedServicePropertiesConfiguration {
        private Set<SuppressibleConfiguration.Suppression> _suppressions;

        private SuppressibleNestedServicePropertiesConfigurationImpl() {
        }

        @Override
        public Set<SuppressibleConfiguration.Suppression> getSuppressions() {
            return this._suppressions;
        }

        @Override
        public void setSuppression(Set<SuppressibleConfiguration.Suppression> suppressions) {
            this._suppressions = suppressions;
        }

        @Override
        public Map<String, Suppressible<String>> getSimpleProperties() {
            return NestedServicePropertiesConfiguration.this.suppressibleSimpleProperties;
        }

        @Override
        public void addSimpleProperty(String key, Suppressible<String> value) {
            NestedServicePropertiesConfiguration.this.suppressibleSimpleProperties.put(key, value);
        }

        @Override
        public String getConfigElementType() {
            return NestedServicePropertiesConfiguration.this.configElementName;
        }
    }
}

