/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.test;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.kaazing.gateway.server.test.Gateway;
import org.kaazing.gateway.server.test.config.GatewayConfiguration;

public class GatewayRule
implements TestRule {
    private GatewayConfiguration configuration;
    private String log4jPropertiesResourceName;

    public Statement apply(Statement base, Description description) {
        return new GatewayStatement(base);
    }

    public void init(GatewayConfiguration configuration) {
        this.configuration = configuration;
    }

    public void init(GatewayConfiguration configuration, String log4jPropertiesResourceName) {
        this.init(configuration);
        this.log4jPropertiesResourceName = log4jPropertiesResourceName;
    }

    private final class GatewayStatement
    extends Statement {
        private final Statement base;

        public GatewayStatement(Statement base) {
            this.base = base;
        }

        public void evaluate() throws Throwable {
            if (GatewayRule.this.log4jPropertiesResourceName != null) {
                Properties log4j = new Properties();
                InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(GatewayRule.this.log4jPropertiesResourceName);
                if (in == null) {
                    throw new IOException(String.format("Could not load resource %s", GatewayRule.this.log4jPropertiesResourceName));
                }
                log4j.load(in);
                PropertyConfigurator.configure((Properties)log4j);
            }
            Gateway gateway = new Gateway();
            try {
                gateway.start(GatewayRule.this.configuration);
                this.base.evaluate();
            }
            finally {
                gateway.stop();
            }
        }
    }
}

