/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.service;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.kaazing.gateway.resource.address.uri.URIUtils;
import org.kaazing.gateway.service.ServiceContext;
import org.kaazing.gateway.service.ServiceRegistration;

public class ServiceAuthority {
    private final List<String> index = new ArrayList<String>();
    private final SortedMap<String, ServiceRegistration> entries = new TreeMap<String, ServiceRegistration>();

    ServiceAuthority() {
    }

    ServiceRegistration register(String serviceURI, ServiceContext serviceContext) {
        String servicePath = URIUtils.getPath((String)serviceURI);
        ServiceRegistration oldRegistration = this.entries.put(servicePath, new ServiceRegistration(serviceURI, serviceContext));
        if (oldRegistration != null) {
            String oldServiceURI = oldRegistration.getURI();
            String oldServicePath = URIUtils.getPath((String)oldServiceURI);
            this.index.remove(oldServicePath);
        }
        this.index.add(servicePath);
        Collections.sort(this.index);
        return oldRegistration;
    }

    ServiceRegistration unregister(URI serviceURI) {
        ServiceRegistration oldRegistration = (ServiceRegistration)this.entries.remove(serviceURI.getPath());
        if (oldRegistration != null) {
            String oldServiceURI = oldRegistration.getURI();
            String oldServicePath = URIUtils.getPath((String)oldServiceURI);
            this.index.remove(oldServicePath);
            Collections.sort(this.index);
        }
        return oldRegistration;
    }

    public ServiceRegistration lookup(URI serviceURI) {
        String servicePath = serviceURI.getPath();
        return this.lookup0(servicePath, false);
    }

    private ServiceRegistration lookup0(String servicePath, boolean requiresExact) {
        int position = Collections.binarySearch(this.index, servicePath);
        if (position >= 0) {
            return (ServiceRegistration)this.entries.get(this.index.get(position));
        }
        if (!requiresExact) {
            if (servicePath.length() == 0) {
                return this.lookup0("/", true);
            }
            int lastSlashAt = servicePath.lastIndexOf("/");
            if (lastSlashAt != -1) {
                return this.lookup0(servicePath.substring(0, lastSlashAt), false);
            }
        }
        return null;
    }

    public Collection<ServiceRegistration> values() {
        return this.entries.values();
    }
}

