/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.context.resolve;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.security.KeyStore;
import org.kaazing.gateway.server.config.nov2015.SecurityStoreType;
import org.kaazing.gateway.server.config.nov2015.SecurityType;
import org.kaazing.gateway.server.context.resolve.ContextResolver;
import org.kaazing.gateway.server.context.resolve.DefaultSecurityContext;
import org.slf4j.Logger;

public class SecurityContextResolver
implements ContextResolver<SecurityType, DefaultSecurityContext> {
    private final File configDir;
    private final Logger logger;

    public SecurityContextResolver(File configDir, Logger logger) {
        this.configDir = configDir;
        this.logger = logger;
    }

    @Override
    public DefaultSecurityContext resolve(SecurityType securityConfig) throws Exception {
        KeyStore keyStore = null;
        String keyStoreRelativePath = null;
        String keyStoreFile = null;
        char[] keyStorePassword = null;
        KeyStore trustStore = null;
        char[] trustStorePassword = null;
        String keyStorePasswordFile = null;
        String trustStoreFile = null;
        File trustStoreFilePath = null;
        if (securityConfig != null) {
            SecurityStoreType trustStoreConfig;
            SecurityStoreType keyStoreConfig = securityConfig.getKeystore();
            if (keyStoreConfig != null) {
                keyStoreRelativePath = keyStoreFile = keyStoreConfig.getFile();
                SecurityStoreType.Type.Enum keyStoreType = keyStoreConfig.getType();
                keyStorePasswordFile = keyStoreConfig.getPasswordFile();
                if (keyStorePasswordFile != null) {
                    File passwordFilePath = new File(keyStorePasswordFile);
                    if (!passwordFilePath.isAbsolute()) {
                        passwordFilePath = new File(this.configDir, keyStorePasswordFile);
                    }
                    keyStorePassword = SecurityContextResolver.loadKeyStorePassword(passwordFilePath);
                }
                if (keyStoreFile != null) {
                    File keyStoreFilePath = new File(keyStoreFile);
                    if (!keyStoreFilePath.isAbsolute()) {
                        keyStoreFilePath = new File(this.configDir, keyStoreFile);
                    }
                    keyStore = this.loadKeyStore(keyStoreType, keyStoreFilePath, keyStorePassword);
                    keyStoreFile = keyStoreFilePath.getAbsolutePath();
                }
            }
            if ((trustStoreConfig = securityConfig.getTruststore()) != null) {
                trustStoreFile = trustStoreConfig.getFile();
                SecurityStoreType.Type.Enum trustStoreType = trustStoreConfig.getType();
                String trustStorePasswordFile = trustStoreConfig.getPasswordFile();
                if (trustStorePasswordFile != null) {
                    File trustStorePasswordFilePath = new File(trustStorePasswordFile);
                    if (!trustStorePasswordFilePath.isAbsolute()) {
                        trustStorePasswordFilePath = new File(this.configDir, trustStorePasswordFile);
                    }
                    trustStorePassword = SecurityContextResolver.loadKeyStorePassword(trustStorePasswordFilePath);
                }
                if (trustStoreFile != null) {
                    trustStoreFilePath = new File(trustStoreFile);
                    if (!trustStoreFilePath.isAbsolute()) {
                        trustStoreFilePath = new File(this.configDir, trustStoreFile);
                    }
                    trustStore = this.loadKeyStore(trustStoreType, trustStoreFilePath, trustStorePassword);
                }
            }
        }
        return new DefaultSecurityContext(keyStore, keyStoreRelativePath, keyStoreFile, keyStorePassword, keyStorePasswordFile, trustStore, trustStoreFile, trustStoreFilePath == null ? null : trustStoreFilePath.getAbsolutePath(), trustStorePassword);
    }

    private KeyStore loadKeyStore(SecurityStoreType.Type.Enum keyStoreType, File location, char[] password) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(keyStoreType == null ? KeyStore.getDefaultType() : keyStoreType.toString());
        FileInputStream in = new FileInputStream(location);
        try {
            keyStore.load(in, password);
        }
        catch (IOException e) {
            this.logger.error(String.format("Exception \"%s\" caught loading file \"%s\", you may need to specify \"<type>JCEKS</type>\" in the gateway configuration file", e.getLocalizedMessage(), location));
            throw e;
        }
        in.close();
        return keyStore;
    }

    private static char[] loadKeyStorePassword(File location) throws Exception {
        BufferedReader in = new BufferedReader(new FileReader(location));
        String line = in.readLine();
        in.close();
        return line.toCharArray();
    }
}

