/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.context.resolve;

import java.util.HashMap;
import java.util.Map;
import org.kaazing.gateway.security.AuthenticationContext;
import org.kaazing.gateway.server.config.nov2015.AuthenticationType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultAuthenticationContext
implements AuthenticationContext {
    private static final String AUTHORIZATION_MODE_CHALLENGE = "challenge";
    private static final String HTTP_CHALLENGE_SCHEME = "http-challenge-scheme";
    private static final String HTTP_HEADERS = "http-header";
    private static final String HTTP_QUERY_PARAMETERS = "http-query-parameter";
    private static final String HTTP_COOKIE_NAMES = "http-cookie";
    private static final String HTTP_AUTHORIZATION_MODE = "authorization-mode";
    private static final String SESSION_TIMEOUT = "session-timeout";
    private Map<String, String> options = new HashMap<String, String>();

    public DefaultAuthenticationContext(AuthenticationType authenticationType) {
        this.parseAuthenticationType(authenticationType);
    }

    public String getHttpChallengeScheme() {
        return this.options.get(HTTP_CHALLENGE_SCHEME);
    }

    public String[] getHttpHeaders() {
        String headers = this.options.get(HTTP_HEADERS);
        if (headers != null) {
            return headers.split(",");
        }
        return null;
    }

    public String[] getHttpQueryParameters() {
        String queryParams = this.options.get(HTTP_QUERY_PARAMETERS);
        if (queryParams != null) {
            return queryParams.split(",");
        }
        return null;
    }

    public String[] getHttpCookieNames() {
        String cookieNames = this.options.get(HTTP_COOKIE_NAMES);
        if (cookieNames != null) {
            return cookieNames.split(",");
        }
        return null;
    }

    public String getAuthorizationMode() {
        return this.resolveAuthorizationMode(this.options.get(HTTP_AUTHORIZATION_MODE));
    }

    public String getSessionTimeout() {
        return this.options.get(SESSION_TIMEOUT);
    }

    public String getProperty(String name) {
        return this.options.get(name);
    }

    private void parseAuthenticationType(AuthenticationType authenticationType) {
        if (authenticationType != null) {
            this.parseOptions(authenticationType.getDomNode(), this.options);
        }
    }

    private void parseOptions(Node parent, Map<String, String> optionsMap) {
        NodeList childNodes = parent.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (1 != node.getNodeType()) continue;
            NodeList content = node.getChildNodes();
            String nodeValue = "";
            for (int j = 0; j < content.getLength(); ++j) {
                String fragment;
                Node child = content.item(j);
                if (child == null || child.getNodeType() != 3 || (fragment = child.getNodeValue()) == null) continue;
                nodeValue = nodeValue + fragment;
            }
            String currentValue = optionsMap.get(node.getLocalName());
            currentValue = currentValue != null ? String.format("%s,%s", currentValue, nodeValue) : nodeValue;
            optionsMap.put(node.getLocalName(), currentValue);
        }
    }

    private String resolveAuthorizationMode(String authorizationMode) {
        if (authorizationMode == null) {
            return AUTHORIZATION_MODE_CHALLENGE;
        }
        return authorizationMode;
    }
}

