/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.config.parse.translate.sep2014;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.kaazing.gateway.server.config.parse.translate.AbstractVisitor;

public class FindMatchingBalancerServiceVisitor
extends AbstractVisitor {
    private static final String SERVICE_ELEMENT = "service";
    private static final String ACCEPT_URI_ELEMENT = "accept";
    private static final String BALANCE_URI_ELEMENT = "balance";
    private static final String TYPE_ELEMENT = "type";
    private Set<String> balanceURIs = new HashSet<String>();
    private Set<String> balancerAcceptURIs = new HashSet<String>();

    @Override
    public void visit(Element element) throws Exception {
        Element typeElement;
        List balanceElements = element.getChildren(BALANCE_URI_ELEMENT, element.getNamespace());
        if (balanceElements != null) {
            for (Element balanceElement : balanceElements) {
                this.balanceURIs.add(balanceElement.getValue());
            }
        }
        if ((typeElement = element.getChild(TYPE_ELEMENT, element.getNamespace())) == null) {
            return;
        }
        String type = typeElement.getValue();
        if ("balancer".equals(type)) {
            List acceptElements = element.getChildren(ACCEPT_URI_ELEMENT, element.getNamespace());
            for (Element acceptElement : acceptElements) {
                this.balancerAcceptURIs.add(acceptElement.getValue());
            }
        }
    }

    @Override
    public void translate(Document dom) throws Exception {
        Element root = dom.getRootElement();
        ElementFilter nameFilter = new ElementFilter(SERVICE_ELEMENT);
        Iterator iter = root.getDescendants((Filter)nameFilter);
        while (iter.hasNext()) {
            Element clusterElement = (Element)iter.next();
            this.visit(clusterElement);
        }
        for (String balanceURI : this.balanceURIs) {
            if (this.balancerAcceptURIs.contains(balanceURI)) continue;
            throw new RuntimeException(String.format("balance URI: %s does not point to a balancer service's accept URI in the configuration file, unable to launch the Gateway", balanceURI));
        }
        for (String balancerAcceptURI : this.balancerAcceptURIs) {
            if (this.balanceURIs.contains(balancerAcceptURI)) continue;
            throw new RuntimeException(String.format("Detected orphaned balancer accept URI: %s, no balance URIs in the configuration file point to this balancer service.  Unable to launch the Gateway.", balancerAcceptURI));
        }
    }
}

