/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.context.resolve;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.kaazing.gateway.resource.address.uri.URIUtils;
import org.kaazing.gateway.server.config.nov2015.ServiceConnectOptionsType;
import org.kaazing.gateway.service.ConnectOptionsContext;
import org.kaazing.gateway.util.Utils;
import org.kaazing.gateway.util.ssl.SslCipherSuites;
import org.kaazing.gateway.util.ws.WebSocketWireProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultConnectOptionsContext
implements ConnectOptionsContext {
    private static final Logger logger = LoggerFactory.getLogger(DefaultConnectOptionsContext.class);
    private static final long DEFAULT_WS_INACTIVITY_TIMEOUT_MILLIS = 0L;
    private static final int DEFAULT_HTTP_KEEPALIVE_TIMEOUT = 30;
    private Map<String, String> options = new HashMap<String, String>();

    public DefaultConnectOptionsContext() {
    }

    public DefaultConnectOptionsContext(ServiceConnectOptionsType connectOptions, ServiceConnectOptionsType defaultOptions) {
        this();
        this.parseConnectOptionsType(connectOptions, defaultOptions);
    }

    public void setOptions(Map<String, String> options) {
        this.options = options;
    }

    public void setDefaultOptions(Map<String, String> defaultOptions) {
        if (this.options == null) {
            this.options = defaultOptions;
        } else if (defaultOptions != null) {
            for (Map.Entry<String, String> entry : defaultOptions.entrySet()) {
                if (this.options.containsKey(entry.getKey())) continue;
                this.options.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public Map<String, Object> asOptionsMap() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("ssl.ciphers", this.getSslCiphers());
        result.put("ssl.protocols", this.getSslProtocols());
        result.put("protocolVersion", this.getWebSocketWireProtocol());
        result.put("inactivityTimeout", this.getWsInactivityTimeout());
        result.put("pipe.transport", this.getTransportURI("pipe.transport"));
        result.put("tcp.transport", this.getTransportURI("tcp.transport"));
        result.put("ssl.transport", this.getTransportURI("ssl.transport"));
        result.put("http[http/1.1].transport", this.getTransportURI("http.transport"));
        result.put("ssl.encryptionEnabled", this.isSslEncryptionEnabled());
        result.put("udp.interface", this.getUdpInterface());
        result.put("keepAliveTimeout", this.getHttpKeepaliveTimeout());
        result.put("keepAlive", this.isHttpKeepaliveEnabled());
        Integer keepaliveConnections = this.getHttpKeepaliveConnections();
        if (keepaliveConnections != null) {
            result.put("http.keepalive.connections", keepaliveConnections);
        }
        for (Map.Entry<String, String> entry : this.options.entrySet()) {
            String key = entry.getKey();
            if (result.containsKey(key)) continue;
            if (key.endsWith(".transport")) {
                try {
                    URIUtils.getHost((String)entry.getValue());
                    result.put(key, entry.getValue());
                }
                catch (IllegalArgumentException ex) {
                    if (!logger.isInfoEnabled()) continue;
                    logger.info(String.format("Skipping option %s, expected valid URI but recieved: %s", key, entry.getValue()));
                }
                continue;
            }
            result.put(key, entry.getValue());
        }
        return result;
    }

    private String getUdpInterface() {
        return this.options.get("udp.interface");
    }

    private WebSocketWireProtocol getWebSocketWireProtocol() {
        WebSocketWireProtocol protocol = WebSocketWireProtocol.RFC_6455;
        String wsVersion = this.options.get("ws.version");
        if ("draft-75".equals(wsVersion)) {
            protocol = WebSocketWireProtocol.HIXIE_75;
        }
        return protocol;
    }

    private String[] getSslCiphers() {
        String sslCiphersStr = this.options.get("ssl.ciphers");
        if (sslCiphersStr != null) {
            return SslCipherSuites.resolveCSV((String)sslCiphersStr);
        }
        return null;
    }

    private String[] getSslProtocols() {
        String sslProtocolsStr = this.options.get("ssl.protocols");
        if (sslProtocolsStr != null) {
            return DefaultConnectOptionsContext.resolveProtocols(sslProtocolsStr);
        }
        return null;
    }

    private long getWsInactivityTimeout() {
        long val;
        long wsInactivityTimeout = 0L;
        String wsInactivityTimeoutValue = this.options.get("ws.inactivity.timeout");
        if (wsInactivityTimeoutValue != null && (val = Utils.parseTimeInterval((String)wsInactivityTimeoutValue, (TimeUnit)TimeUnit.MILLISECONDS)) > 0L) {
            wsInactivityTimeout = val;
        }
        return wsInactivityTimeout;
    }

    private String getTransportURI(String transportKey) {
        String transportURI = null;
        String transport = this.options.get(transportKey);
        if (transport != null && !URIUtils.isAbsolute((String)(transportURI = transport))) {
            throw new IllegalArgumentException(String.format("%s must contain an absolute URI, not \"%s\"", transportKey, transport));
        }
        return transportURI;
    }

    private boolean isSslEncryptionEnabled() {
        boolean sslEncryptionEnabled = true;
        String sslEncryptionEnabledValue = this.options.get("ssl.encryption");
        if (sslEncryptionEnabledValue != null) {
            sslEncryptionEnabled = !sslEncryptionEnabledValue.equalsIgnoreCase("disabled");
        }
        return sslEncryptionEnabled;
    }

    private Integer getHttpKeepaliveTimeout() {
        long val;
        int httpKeepaliveTimeout = 30;
        String timeoutValue = this.options.get("http.keepalive.timeout");
        if (timeoutValue != null && (val = Utils.parseTimeInterval((String)timeoutValue, (TimeUnit)TimeUnit.SECONDS)) > 0L) {
            httpKeepaliveTimeout = (int)val;
        }
        return httpKeepaliveTimeout;
    }

    private Integer getHttpKeepaliveConnections() {
        Integer maxConnections = null;
        String connectionsValue = this.options.get("http.keepalive.connections");
        if (connectionsValue != null) {
            int val = Integer.parseInt(connectionsValue);
            if (val > 0) {
                maxConnections = val;
            } else {
                String msg = String.format("http.keepalive.connections = %s must be > 0", connectionsValue);
                throw new IllegalArgumentException(msg);
            }
        }
        return maxConnections;
    }

    private boolean isHttpKeepaliveEnabled() {
        boolean httpKeepaliveEnabled = true;
        String httpKeepaliveEnabledValue = this.options.get("http.keepalive");
        if (httpKeepaliveEnabledValue != null) {
            httpKeepaliveEnabled = !httpKeepaliveEnabledValue.equalsIgnoreCase("disabled");
        }
        return httpKeepaliveEnabled;
    }

    public static String[] resolveProtocols(String csv) {
        if (csv != null && !csv.equals("")) {
            return csv.split(",");
        }
        return null;
    }

    private void parseConnectOptionsType(ServiceConnectOptionsType connectOptionsType, ServiceConnectOptionsType defaultOptionsType) {
        if (connectOptionsType != null) {
            HashMap<String, String> connectOptionsMap = new HashMap<String, String>();
            this.parseOptions(connectOptionsType.getDomNode(), connectOptionsMap);
            this.setOptions(connectOptionsMap);
        }
        if (defaultOptionsType != null) {
            HashMap<String, String> defaultConnectOptionsMap = new HashMap<String, String>();
            this.parseOptions(defaultOptionsType.getDomNode(), defaultConnectOptionsMap);
            this.setDefaultOptions(defaultConnectOptionsMap);
        }
    }

    private void parseOptions(Node parent, Map<String, String> optionsMap) {
        NodeList childNodes = parent.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (1 != node.getNodeType()) continue;
            NodeList content = node.getChildNodes();
            String nodeValue = "";
            for (int j = 0; j < content.getLength(); ++j) {
                String fragment;
                Node child = content.item(j);
                if (child == null || child.getNodeType() != 3 || (fragment = child.getNodeValue()) == null) continue;
                nodeValue = nodeValue + fragment;
            }
            optionsMap.put(node.getLocalName(), nodeValue);
        }
    }
}

