/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.test.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.kaazing.gateway.server.test.config.Configuration;
import org.kaazing.gateway.server.test.config.ConfigurationVisitor;
import org.kaazing.gateway.server.test.config.Suppressible;
import org.kaazing.gateway.server.test.config.SuppressibleConfiguration;
import org.kaazing.gateway.server.test.config.SuppressibleLoginModuleConfiguration;
import org.kaazing.gateway.server.test.config.Suppressibles;

public class LoginModuleConfiguration
implements Configuration<SuppressibleLoginModuleConfiguration> {
    private final SuppressibleLoginModuleConfiguration _configuration;
    private Suppressible<String> _type;
    private Suppressible<String> _success;
    private final Map<String, Suppressible<String>> options = new HashMap<String, Suppressible<String>>();
    private final Map<String, String> unsuppressibleOptions = Suppressibles.unsuppressibleMap(this.options);

    public LoginModuleConfiguration() {
        this._configuration = new SuppressibleLoginModuleConfigurationImpl();
        this._configuration.setSuppression(Suppressibles.getDefaultSuppressions());
    }

    @Override
    public void accept(ConfigurationVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public SuppressibleLoginModuleConfiguration getSuppressibleConfiguration() {
        return this._configuration;
    }

    public String getType() {
        if (this._type == null) {
            return null;
        }
        return this._type.value();
    }

    public void setType(String type) {
        this._type = new Suppressible<String>(type, new SuppressibleConfiguration.Suppression[0]);
    }

    public String getSuccess() {
        if (this._success == null) {
            return null;
        }
        return this._success.value();
    }

    public void setSuccess(String success) {
        this._success = new Suppressible<String>(success, new SuppressibleConfiguration.Suppression[0]);
    }

    public Map<String, String> getOptions() {
        return this.unsuppressibleOptions;
    }

    public void addOption(String optionKey, String optionValue) {
        this.unsuppressibleOptions.put(optionKey, optionValue);
    }

    private class SuppressibleLoginModuleConfigurationImpl
    extends SuppressibleLoginModuleConfiguration {
        private Set<SuppressibleConfiguration.Suppression> _suppressions;

        private SuppressibleLoginModuleConfigurationImpl() {
        }

        @Override
        public Set<SuppressibleConfiguration.Suppression> getSuppressions() {
            return this._suppressions;
        }

        @Override
        public void setSuppression(Set<SuppressibleConfiguration.Suppression> suppressions) {
            this._suppressions = suppressions;
        }

        @Override
        public Suppressible<String> getType() {
            return LoginModuleConfiguration.this._type;
        }

        @Override
        public void setType(Suppressible<String> type) {
            LoginModuleConfiguration.this._type = type;
        }

        @Override
        public Suppressible<String> getSuccess() {
            return LoginModuleConfiguration.this._success;
        }

        @Override
        public void setSuccess(Suppressible<String> success) {
            LoginModuleConfiguration.this._success = success;
        }

        @Override
        public Map<String, Suppressible<String>> getOptions() {
            return LoginModuleConfiguration.this.options;
        }

        @Override
        public void addOption(String key, Suppressible<String> value) {
            LoginModuleConfiguration.this.options.put(key, value);
        }
    }
}

