/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.context.resolve;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.kaazing.gateway.resource.address.uri.URIUtils;
import org.kaazing.gateway.server.config.sep2014.ServiceAcceptOptionsType;
import org.kaazing.gateway.service.AcceptOptionsContext;
import org.kaazing.gateway.util.Utils;
import org.kaazing.gateway.util.ssl.SslCipherSuites;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultAcceptOptionsContext
implements AcceptOptionsContext {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAcceptOptionsContext.class);
    private static int DEFAULT_WEBSOCKET_MAXIMUM_MESSAGE_SIZE = 131072;
    private static int DEFAULT_HTTP_KEEPALIVE_TIMEOUT = 30;
    private static final long UNLIMITED_MAX_OUTPUT_RATE = 0xFFFFFFFFL;
    private static long DEFAULT_TCP_MAXIMUM_OUTBOUND_RATE = 0xFFFFFFFFL;
    public static final String EXTENDED_HANDSHAKE_PROTOCOL_NAME = "x-kaazing-handshake";
    private static final String PING_PONG = "x-kaazing-ping-pong";
    private static final String IDLE_TIMEOUT = "x-kaazing-idle-timeout";
    private static final long DEFAULT_WS_INACTIVITY_TIMEOUT_MILLIS = 0L;
    private static List<String> DEFAULT_WEBSOCKET_PROTOCOLS = Arrays.asList("x-kaazing-handshake", null);
    private static List<String> DEFAULT_WEBSOCKET_EXTENSIONS = Arrays.asList("x-kaazing-ping-pong", null);
    private final Map<String, String> binds = new HashMap<String, String>();
    private Map<String, String> options = new HashMap<String, String>();

    public DefaultAcceptOptionsContext() {
    }

    public DefaultAcceptOptionsContext(ServiceAcceptOptionsType acceptOptions, ServiceAcceptOptionsType defaultOptions) {
        this();
        this.parseAcceptOptionsType(acceptOptions, defaultOptions);
    }

    public void setOptions(Map<String, String> options) {
        this.options = options;
        this.addBind("ws", options.get("ws.bind"));
        this.addBind("wss", options.get("wss.bind"));
        this.addBind("http", options.get("http.bind"));
        this.addBind("https", options.get("https.bind"));
        this.addBind("ssl", options.get("ssl.bind"));
        this.addBind("tcp", options.get("tcp.bind"));
    }

    public void setDefaultOptions(Map<String, String> defaultOptions) {
        if (this.options == null) {
            this.options = defaultOptions;
        } else if (defaultOptions != null) {
            for (Map.Entry<String, String> entry : defaultOptions.entrySet()) {
                if (this.options.containsKey(entry.getKey())) continue;
                this.options.put(entry.getKey(), entry.getValue());
            }
        }
        this.addBind("ws", defaultOptions.get("ws.bind"));
        this.addBind("wss", defaultOptions.get("wss.bind"));
        this.addBind("http", defaultOptions.get("http.bind"));
        this.addBind("https", defaultOptions.get("https.bind"));
        this.addBind("ssl", defaultOptions.get("ssl.bind"));
        this.addBind("tcp", defaultOptions.get("tcp.bind"));
    }

    public Map<String, String> getBinds() {
        return this.binds;
    }

    public String getInternalURI(String externalURI) {
        String authority = URIUtils.getAuthority((String)externalURI);
        String internalAuthority = this.binds.get(URIUtils.getScheme((String)externalURI));
        if (internalAuthority != null) {
            if (!internalAuthority.equals(authority)) {
                try {
                    return URIUtils.buildURIAsString((String)URIUtils.getScheme((String)externalURI), (String)internalAuthority, (String)URIUtils.getPath((String)externalURI), (String)URIUtils.getQuery((String)externalURI), (String)URIUtils.getFragment((String)externalURI));
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            return externalURI;
        }
        return null;
    }

    public void addBind(String scheme, String hostPort) {
        if (hostPort != null && !this.binds.containsKey(scheme)) {
            if (!hostPort.contains(":")) {
                try {
                    int port = Integer.parseInt(hostPort);
                    this.binds.put(scheme, "0.0.0.0:" + port);
                }
                catch (NumberFormatException ex) {
                    throw new RuntimeException("Failed to add bind for scheme " + scheme + " to port " + hostPort, ex);
                }
            } else {
                this.binds.put(scheme, hostPort);
            }
        }
    }

    public Map<String, Object> asOptionsMap() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("supportedProtocols", DEFAULT_WEBSOCKET_PROTOCOLS.toArray(new String[DEFAULT_WEBSOCKET_PROTOCOLS.size()]));
        long wsInactivityTimeout = this.getWsInactivityTimeout();
        result.put("ws.inactivityTimeout", wsInactivityTimeout);
        result.put("ws[ws/rfc6455].ws[ws/rfc6455].inactivityTimeout", wsInactivityTimeout);
        result.put("ws[ws/draft-7x].ws[ws/draft-7x].inactivityTimeout", wsInactivityTimeout);
        List<String> wsExtensions = this.getWsExtensions(wsInactivityTimeout);
        result.put("ws.extensions", wsExtensions);
        result.put("ws[ws/rfc6455].ws[ws/rfc6455].extensions", wsExtensions);
        result.put("ws[ws/draft-7x].ws[ws/draft-7x].extensions", wsExtensions);
        int wsMaxMessageSize = this.getWsMaximumMessageSize();
        result.put("ws.maxMessageSize", wsMaxMessageSize);
        result.put("ws[ws/rfc6455].ws[ws/rfc6455].maxMessageSize", wsMaxMessageSize);
        result.put("ws[ws/draft-7x].ws[ws/draft-7x].maxMessageSize", wsMaxMessageSize);
        result.put("http[http/1.1].keepAliveTimeout", this.getHttpKeepaliveTimeout());
        result.put("ssl.ciphers", this.getSslCiphers());
        result.put("ssl.protocols", this.getSslProtocols());
        result.put("ssl.encryptionEnabled", this.isSslEncryptionEnabled());
        result.put("http.serverHeaderEnabled", this.isHttpServerHeaderEnabled());
        boolean[] clientAuth = this.getVerifyClientProperties();
        result.put("ssl.wantClientAuth", clientAuth[0]);
        result.put("ssl.needClientAuth", clientAuth[1]);
        result.put("pipe.transport", this.getTransportURI("pipe.transport"));
        result.put("tcp.transport", this.getTransportURI("tcp.transport"));
        result.put("ssl.transport", this.getTransportURI("ssl.transport"));
        result.put("http[http/1.1].transport", this.getTransportURI("http.transport"));
        result.put("tcp.maximumOutboundRate", this.getTcpMaximumOutboundRate());
        result.put("udp.interface", this.options.get("udp.interface"));
        for (Map.Entry<String, String> entry : this.getBinds().entrySet()) {
            String internalBindOptionName = this.resolveInternalBindOptionName(entry.getKey());
            if (internalBindOptionName != null) {
                result.put(internalBindOptionName, entry.getValue());
                continue;
            }
            throw new RuntimeException("Cannot apply unknown bind option '" + entry.getKey() + "'.");
        }
        for (Map.Entry<String, String> entry : this.options.entrySet()) {
            String key = entry.getKey();
            if (result.containsKey(key)) continue;
            if (key.endsWith(".transport")) {
                try {
                    URIUtils.getHost((String)entry.getValue());
                    result.put(key, entry.getValue());
                }
                catch (IllegalArgumentException ex) {
                    if (!logger.isInfoEnabled()) continue;
                    logger.info(String.format("Skipping option %s, expected valid URI but recieved: %s", key, entry.getValue()));
                }
                continue;
            }
            result.put(key, entry.getValue());
        }
        return result;
    }

    private String resolveInternalBindOptionName(String externalBindOptionName) {
        if (externalBindOptionName.equals("tcp")) {
            return "tcp.bind";
        }
        if (externalBindOptionName.equals("ssl")) {
            return "ssl.tcp.bind";
        }
        if (externalBindOptionName.equals("http")) {
            return "http.tcp.bind";
        }
        if (externalBindOptionName.equals("https")) {
            return "http.ssl.tcp.bind";
        }
        if (externalBindOptionName.equals("ws")) {
            return "ws.http.tcp.bind";
        }
        if (externalBindOptionName.equals("wss")) {
            return "ws.http.ssl.tcp.bind";
        }
        if (externalBindOptionName.equals("wsn")) {
            return "wsn.http.tcp.bind";
        }
        if (externalBindOptionName.equals("wsn+ssl")) {
            return "wsn.http.ssl.tcp.bind";
        }
        if (externalBindOptionName.equals("wsx")) {
            return "wsn.http.wsn.http.tcp.bind";
        }
        if (externalBindOptionName.equals("wsx+ssl")) {
            return "wsn.http.wsn.http.ssl.tcp.bind";
        }
        if (externalBindOptionName.equals("httpxe")) {
            return "http.http.tcp.bind";
        }
        if (externalBindOptionName.equals("httpxe+ssl")) {
            return "http.http.ssl.tcp.bind";
        }
        return null;
    }

    public static String[] resolveProtocols(String csv) {
        if (csv != null && !csv.equals("")) {
            return csv.split(",");
        }
        return null;
    }

    private long getWsInactivityTimeout() {
        long val;
        long wsInactivityTimeout = 0L;
        String value = this.options.get("ws.inactivity.timeout");
        if (value != null && (val = Utils.parseTimeInterval((String)value, (TimeUnit)TimeUnit.MILLISECONDS)) > 0L) {
            wsInactivityTimeout = val;
        }
        return wsInactivityTimeout;
    }

    private String getTransportURI(String transportKey) {
        String transportURI = null;
        String transport = this.options.get(transportKey);
        if (transport != null && !URIUtils.isAbsolute((String)(transportURI = transport))) {
            throw new IllegalArgumentException(String.format("%s must contain an absolute URI, not \"%s\"", transportKey, transport));
        }
        return transportURI;
    }

    private List<String> getWsExtensions(long wsInactivityTimeout) {
        List<String> wsExtensions = null;
        if (wsInactivityTimeout > 0L) {
            ArrayList<String> extensions = new ArrayList<String>(DEFAULT_WEBSOCKET_EXTENSIONS);
            extensions.add(IDLE_TIMEOUT);
            wsExtensions = extensions;
        } else {
            wsExtensions = DEFAULT_WEBSOCKET_EXTENSIONS;
        }
        return wsExtensions;
    }

    private int getWsMaximumMessageSize() {
        int wsMaxMessageSize = DEFAULT_WEBSOCKET_MAXIMUM_MESSAGE_SIZE;
        String wsMaxMessageSizeValue = this.options.get("ws.maximum.message.size");
        if (wsMaxMessageSizeValue != null) {
            wsMaxMessageSize = Utils.parseDataSize((String)wsMaxMessageSizeValue);
        }
        return wsMaxMessageSize;
    }

    private long getTcpMaximumOutboundRate() {
        long tcpMaximumOutboundRate = DEFAULT_TCP_MAXIMUM_OUTBOUND_RATE;
        String tcpMaxOutboundRate = this.options.get("tcp.maximum.outbound.rate");
        if (tcpMaxOutboundRate != null && ((tcpMaximumOutboundRate = Utils.parseDataRate((String)tcpMaxOutboundRate)) == 0L || tcpMaximumOutboundRate > 0xFFFFFFFFL)) {
            tcpMaximumOutboundRate = 0xFFFFFFFFL;
        }
        return tcpMaximumOutboundRate;
    }

    private boolean[] getVerifyClientProperties() {
        boolean[] clientAuth = new boolean[]{false, false};
        String sslVerifyClientValue = this.options.get("ssl.verify-client");
        if (sslVerifyClientValue != null) {
            if (sslVerifyClientValue.equalsIgnoreCase("required")) {
                clientAuth[0] = false;
                clientAuth[1] = true;
            } else if (sslVerifyClientValue.equalsIgnoreCase("optional")) {
                clientAuth[0] = true;
                clientAuth[1] = false;
            }
        }
        return clientAuth;
    }

    private boolean isSslEncryptionEnabled() {
        boolean sslEncryptionEnabled = true;
        String sslEncryptionEnabledValue = this.options.get("ssl.encryption");
        if (sslEncryptionEnabledValue != null) {
            sslEncryptionEnabled = !sslEncryptionEnabledValue.equalsIgnoreCase("disabled");
        }
        return sslEncryptionEnabled;
    }

    private boolean isHttpServerHeaderEnabled() {
        String serverHeaderEnabled = this.options.get("http.server.header");
        return serverHeaderEnabled == null || !serverHeaderEnabled.equalsIgnoreCase("disabled");
    }

    private String[] getSslProtocols() {
        String[] sslProtocols = null;
        String sslProtocolsValue = this.options.get("ssl.protocols");
        if (sslProtocolsValue != null) {
            sslProtocols = DefaultAcceptOptionsContext.resolveProtocols(sslProtocolsValue);
        }
        return sslProtocols;
    }

    private String[] getSslCiphers() {
        String[] sslCiphers = null;
        String sslCiphersValue = this.options.get("ssl.ciphers");
        if (sslCiphersValue != null) {
            sslCiphers = SslCipherSuites.resolveCSV((String)sslCiphersValue);
        }
        return sslCiphers;
    }

    private int getHttpKeepaliveTimeout() {
        long val;
        int httpKeepaliveTimeout = DEFAULT_HTTP_KEEPALIVE_TIMEOUT;
        String httpKeepaliveTimeoutValue = this.options.get("http.keepalive.timeout");
        if (httpKeepaliveTimeoutValue != null && (val = Utils.parseTimeInterval((String)httpKeepaliveTimeoutValue, (TimeUnit)TimeUnit.SECONDS)) > 0L) {
            httpKeepaliveTimeout = (int)val;
        }
        return httpKeepaliveTimeout;
    }

    private void parseAcceptOptionsType(ServiceAcceptOptionsType acceptOptionsType, ServiceAcceptOptionsType defaultOptionsType) {
        if (acceptOptionsType != null) {
            HashMap<String, String> acceptOptionsMap = new HashMap<String, String>();
            this.parseOptions(acceptOptionsType.getDomNode(), acceptOptionsMap);
            this.setOptions(acceptOptionsMap);
        }
        if (defaultOptionsType != null) {
            HashMap<String, String> defaultAcceptOptionsMap = new HashMap<String, String>();
            this.parseOptions(defaultOptionsType.getDomNode(), defaultAcceptOptionsMap);
            this.setDefaultOptions(defaultAcceptOptionsMap);
        }
    }

    private void parseOptions(Node parent, Map<String, String> optionsMap) {
        NodeList childNodes = parent.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (1 != node.getNodeType()) continue;
            NodeList content = node.getChildNodes();
            String nodeValue = "";
            for (int j = 0; j < content.getLength(); ++j) {
                String fragment;
                Node child = content.item(j);
                if (child == null || child.getNodeType() != 3 || (fragment = child.getNodeValue()) == null) continue;
                nodeValue = nodeValue + fragment;
            }
            optionsMap.put(node.getLocalName(), nodeValue);
        }
    }
}

