/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.test.config.builder;

import java.net.URI;
import java.util.Set;
import org.kaazing.gateway.server.test.config.AuthorizationConstraintConfiguration;
import org.kaazing.gateway.server.test.config.CrossOriginConstraintConfiguration;
import org.kaazing.gateway.server.test.config.NestedServicePropertiesConfiguration;
import org.kaazing.gateway.server.test.config.ServiceConfiguration;
import org.kaazing.gateway.server.test.config.Suppressible;
import org.kaazing.gateway.server.test.config.SuppressibleConfiguration;
import org.kaazing.gateway.server.test.config.builder.AbstractAuthorizationConstraintConfigurationBuilder;
import org.kaazing.gateway.server.test.config.builder.AbstractConfigurationBuilder;
import org.kaazing.gateway.server.test.config.builder.AbstractCrossOriginConstraintConfigurationBuilder;
import org.kaazing.gateway.server.test.config.builder.AbstractNestedPropertyConfigurationBuilder;

public abstract class AbstractServiceConfigurationBuilder<R>
extends AbstractConfigurationBuilder<ServiceConfiguration, R> {
    public AbstractServiceConfigurationBuilder<R> balance(URI balance) {
        ((ServiceConfiguration)this.configuration).getSuppressibleConfiguration().addBalance(new Suppressible<URI>(balance, this.getCurrentSuppressions()));
        return this;
    }

    public AbstractServiceConfigurationBuilder<R> accept(URI accept) {
        ((ServiceConfiguration)this.configuration).getSuppressibleConfiguration().addAccept(new Suppressible<URI>(accept, this.getCurrentSuppressions()));
        return this;
    }

    public AbstractServiceConfigurationBuilder<R> acceptOption(String optionName, String optionValue) {
        ((ServiceConfiguration)this.configuration).getSuppressibleConfiguration().addAcceptOption(optionName, new Suppressible<String>(optionValue, this.getCurrentSuppressions()));
        return this;
    }

    public AbstractServiceConfigurationBuilder<R> connect(URI connect) {
        ((ServiceConfiguration)this.configuration).getSuppressibleConfiguration().addConnect(new Suppressible<URI>(connect, this.getCurrentSuppressions()));
        return this;
    }

    public AbstractServiceConfigurationBuilder<R> connectOption(String optionName, String optionValue) {
        ((ServiceConfiguration)this.configuration).getSuppressibleConfiguration().addConnectOption(optionName, new Suppressible<String>(optionValue, this.getCurrentSuppressions()));
        return this;
    }

    public AbstractServiceConfigurationBuilder<R> realmName(String realmName) {
        ((ServiceConfiguration)this.configuration).getSuppressibleConfiguration().setRealmName(new Suppressible<String>(realmName, this.getCurrentSuppressions()));
        return this;
    }

    public AbstractServiceConfigurationBuilder<R> type(String type) {
        ((ServiceConfiguration)this.configuration).getSuppressibleConfiguration().setType(new Suppressible<String>(type, this.getCurrentSuppressions()));
        return this;
    }

    public AbstractServiceConfigurationBuilder<R> property(String propertyName, String propertyValue) {
        ((ServiceConfiguration)this.configuration).getSuppressibleConfiguration().addProperty(propertyName, new Suppressible<String>(propertyValue, this.getCurrentSuppressions()));
        return this;
    }

    public AbstractServiceConfigurationBuilder<R> mimeMapping(String extension, String type) {
        ((ServiceConfiguration)this.configuration).getSuppressibleConfiguration().addMimeMapping(extension, new Suppressible<String>(type, this.getCurrentSuppressions()));
        return this;
    }

    public AbstractServiceConfigurationBuilder<R> description(String description) {
        ((ServiceConfiguration)this.configuration).getSuppressibleConfiguration().setDescription(new Suppressible<String>(description, this.getCurrentSuppressions()));
        return this;
    }

    public AbstractServiceConfigurationBuilder<R> name(String name) {
        ((ServiceConfiguration)this.configuration).getSuppressibleConfiguration().setName(new Suppressible<String>(name, this.getCurrentSuppressions()));
        return this;
    }

    public abstract AbstractNestedPropertyConfigurationBuilder<? extends AbstractServiceConfigurationBuilder<R>> nestedProperty(String var1);

    public abstract AbstractAuthorizationConstraintConfigurationBuilder<? extends AbstractServiceConfigurationBuilder<R>> authorization();

    public abstract AbstractCrossOriginConstraintConfigurationBuilder<? extends AbstractServiceConfigurationBuilder<R>> crossOrigin();

    protected AbstractServiceConfigurationBuilder(ServiceConfiguration configuration, R result, Set<SuppressibleConfiguration.Suppression> suppressions) {
        super(configuration, result, suppressions);
    }

    public AbstractServiceConfigurationBuilder<R> suppress(SuppressibleConfiguration.Suppression ... suppressions) {
        super.addCurrentSuppressions(suppressions);
        return this;
    }

    public static class AddNestedPropertyBuilder<R extends AbstractServiceConfigurationBuilder<?>>
    extends AbstractNestedPropertyConfigurationBuilder<R> {
        final String propertyName;

        protected AddNestedPropertyBuilder(String propertyName, R result, Set<SuppressibleConfiguration.Suppression> suppressions) {
            super(new NestedServicePropertiesConfiguration(propertyName), result, suppressions);
            this.propertyName = propertyName;
        }

        @Override
        public R done() {
            ((ServiceConfiguration)((AbstractServiceConfigurationBuilder)this.result).configuration).addNestedProperties((NestedServicePropertiesConfiguration)this.configuration);
            return (R)((AbstractServiceConfigurationBuilder)super.done());
        }
    }

    public static class AddAuthorizationConstraintBuilder<R extends AbstractServiceConfigurationBuilder<?>>
    extends AbstractAuthorizationConstraintConfigurationBuilder<R> {
        protected AddAuthorizationConstraintBuilder(R result, Set<SuppressibleConfiguration.Suppression> suppressions) {
            super(new AuthorizationConstraintConfiguration(), result, suppressions);
        }

        @Override
        public R done() {
            ((ServiceConfiguration)((AbstractServiceConfigurationBuilder)this.result).configuration).getAuthorizationConstraints().add((AuthorizationConstraintConfiguration)this.configuration);
            return (R)((AbstractServiceConfigurationBuilder)super.done());
        }
    }

    public static class AddCrossOriginConstraintBuilder<R extends AbstractServiceConfigurationBuilder<?>>
    extends AbstractCrossOriginConstraintConfigurationBuilder<R> {
        protected AddCrossOriginConstraintBuilder(R result, Set<SuppressibleConfiguration.Suppression> suppressions) {
            super(new CrossOriginConstraintConfiguration(), result, suppressions);
        }

        @Override
        public R done() {
            ((ServiceConfiguration)((AbstractServiceConfigurationBuilder)this.result).configuration).getCrossOriginConstraints().add((CrossOriginConstraintConfiguration)this.configuration);
            return (R)((AbstractServiceConfigurationBuilder)super.done());
        }
    }
}

