/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.config.parse;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlOptions;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.kaazing.gateway.server.Launcher;
import org.kaazing.gateway.server.config.parse.GatewayConfigNamespace;
import org.kaazing.gateway.server.config.parse.GatewayConfigParserException;
import org.kaazing.gateway.server.config.parse.translate.GatewayConfigTranslator;
import org.kaazing.gateway.server.config.parse.translate.GatewayConfigTranslatorFactory;
import org.kaazing.gateway.server.config.sep2014.ClusterType;
import org.kaazing.gateway.server.config.sep2014.GatewayConfigDocument;
import org.kaazing.gateway.server.config.sep2014.PropertiesType;
import org.kaazing.gateway.server.config.sep2014.PropertyType;
import org.kaazing.gateway.server.config.sep2014.SecurityType;
import org.kaazing.gateway.server.config.sep2014.ServiceDefaultsType;
import org.kaazing.gateway.server.config.sep2014.ServiceType;
import org.kaazing.gateway.util.parse.ConfigParameter;
import org.slf4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.ext.Locator2;
import org.xml.sax.helpers.DefaultHandler;

public class GatewayConfigParser {
    private static final String GATEWAY_CONFIG_ANNOTATE_TYPES_XSL = "META-INF/gateway-config-annotate-types.xsl";
    private static final String CHARSET_OUTPUT_XML = "UTF-16";
    private static final String CHARSET_OUTPUT = "UTF16";
    private static final String TRANSLATED_CONFIG_FILE_EXT = ".new";
    private static final Logger LOGGER = Launcher.getGatewayStartupLogger();
    private final Properties configuration;

    public GatewayConfigParser() {
        this(System.getProperties());
    }

    public GatewayConfigParser(Properties configuration) {
        this.configuration = configuration;
    }

    private void translate(GatewayConfigNamespace ns, Document dom, File translatedConfigFile, boolean writeTranslatedFile) throws Exception {
        GatewayConfigTranslator translator = GatewayConfigTranslatorFactory.newInstance().getTranslator(ns);
        translator.translate(dom);
        if (writeTranslatedFile) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufferedOutputStream bos = new BufferedOutputStream(baos);
            Format outputFormat = Format.getPrettyFormat();
            outputFormat.setLineSeparator(System.getProperty("line.separator"));
            XMLOutputter xmlWriter = new XMLOutputter(outputFormat);
            xmlWriter.output(dom, (OutputStream)bos);
            bos.close();
            String xml = baos.toString();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Translated gateway config XML:\n%s", xml));
            }
            FileWriter fw = new FileWriter(translatedConfigFile);
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(xml);
            bw.close();
        }
    }

    private File getTranslatedConfigFile(File configFile) throws Exception {
        SAXBuilder xmlReader = new SAXBuilder();
        Document dom = xmlReader.build(configFile);
        Element root = dom.getRootElement();
        GatewayConfigNamespace namespace = GatewayConfigNamespace.fromURI(root.getNamespace().getURI());
        boolean writeTranslatedFile = !namespace.equals((Object)GatewayConfigNamespace.CURRENT_NS);
        File translatedConfigFile = writeTranslatedFile ? new File(configFile.getParent(), configFile.getName() + TRANSLATED_CONFIG_FILE_EXT) : configFile;
        this.translate(namespace, dom, translatedConfigFile, writeTranslatedFile);
        return translatedConfigFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GatewayConfigDocument parse(File configFile) throws Exception {
        long time = 0L;
        if (LOGGER.isDebugEnabled()) {
            time = System.currentTimeMillis();
        }
        String configFileName = configFile.getName();
        GatewayConfigDocument config = null;
        XmlOptions parseOptions = new XmlOptions();
        parseOptions.setLoadLineNumbers();
        parseOptions.setLoadLineNumbers("LOAD_LINE_NUMBERS_END_ELEMENT");
        parseOptions.setLoadStripWhitespace();
        parseOptions.setLoadStripComments();
        File translatedConfigFile = null;
        try {
            translatedConfigFile = this.getTranslatedConfigFile(configFile);
        }
        catch (Exception e) {
            Throwable rootCause = GatewayConfigParser.getRootCause(e);
            if (rootCause == null) {
                rootCause = e;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error("Error upgrading XML: " + rootCause, rootCause);
            } else {
                LOGGER.error("Error upgrading XML: " + rootCause);
            }
            if (e instanceof IllegalArgumentException) {
                throw e;
            }
            throw new GatewayConfigParserException(e.getMessage());
        }
        ArrayList<String> xmlParseErrors = new ArrayList<String>();
        try {
            config = GatewayConfigDocument.Factory.parse(new FileInputStream(translatedConfigFile), parseOptions);
        }
        catch (Exception e) {
            xmlParseErrors.add("Invalid XML: " + GatewayConfigParser.getRootCause(e).getMessage());
        }
        if (xmlParseErrors.isEmpty()) {
            GatewayConfigDocument.GatewayConfig gatewayConfig = config.getGatewayConfig();
            PropertiesType properties = gatewayConfig.getProperties();
            HashMap<String, String> propertiesMap = new HashMap<String, String>();
            if (properties != null) {
                for (PropertyType propertyType : properties.getPropertyArray()) {
                    propertiesMap.put(propertyType.getName(), propertyType.getValue());
                }
            }
            InputStream xmlInjectedIn = new PipedInputStream();
            PipedOutputStream xmlInjectedOut = new PipedOutputStream((PipedInputStream)xmlInjectedIn);
            ExecutorService xmlInjectedExecutor = Executors.newSingleThreadExecutor();
            Future<Boolean> xmlInjectedFuture = xmlInjectedExecutor.submit(new XMLParameterInjector(new FileInputStream(translatedConfigFile), xmlInjectedOut, propertiesMap, this.configuration, xmlParseErrors));
            if (LOGGER.isTraceEnabled()) {
                xmlInjectedIn = GatewayConfigParser.bufferToTraceLog(xmlInjectedIn, "Gateway config file '" + configFileName + "' post parameter injection", LOGGER);
            }
            InputStream xmlTransformedIn = new PipedInputStream();
            PipedOutputStream xmlTransformedOut = new PipedOutputStream((PipedInputStream)xmlTransformedIn);
            ExecutorService xmlTransformedExecutor = Executors.newSingleThreadExecutor();
            Future<Boolean> xmlTransformedFuture = xmlTransformedExecutor.submit(new XSLTransformer(xmlInjectedIn, xmlTransformedOut, GATEWAY_CONFIG_ANNOTATE_TYPES_XSL));
            if (LOGGER.isTraceEnabled()) {
                xmlTransformedIn = GatewayConfigParser.bufferToTraceLog(xmlTransformedIn, "Gateway config file '" + configFileName + "' post XSL transformation", LOGGER);
            }
            try {
                config = GatewayConfigDocument.Factory.parse(xmlTransformedIn, parseOptions);
            }
            catch (Exception e) {
                try {
                    if (xmlInjectedFuture.get().booleanValue() && xmlTransformedFuture.get().booleanValue()) {
                        throw e;
                    }
                }
                catch (Exception n) {
                    xmlParseErrors.add("Invalid XML: " + GatewayConfigParser.getRootCause(n).getMessage());
                }
            }
            finally {
                xmlInjectedFuture.cancel(true);
                xmlInjectedExecutor.shutdownNow();
                xmlTransformedFuture.cancel(true);
                xmlTransformedExecutor.shutdownNow();
            }
        }
        this.validateGatewayConfig(config, xmlParseErrors);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("parsed  gateway config file '" + configFileName + "' in [" + (System.currentTimeMillis() - time) + " ms]");
        }
        return config;
    }

    private void validateGatewayConfig(GatewayConfigDocument configDoc, List<String> preProcessErrors) {
        ArrayList<XmlError> errorList = new ArrayList<XmlError>();
        for (String preProcessError : preProcessErrors) {
            errorList.add(XmlError.forMessage((String)preProcessError, (int)0));
        }
        if (errorList.isEmpty()) {
            XmlOptions validationOptions = new XmlOptions();
            validationOptions.setLoadLineNumbers();
            validationOptions.setLoadLineNumbers("LOAD_LINE_NUMBERS_END_ELEMENT");
            validationOptions.setErrorListener(errorList);
            boolean valid = configDoc.validate(validationOptions);
            if (valid) {
                ClusterType[] clusterConfigs;
                ServiceDefaultsType[] serviceDefaults;
                SecurityType[] security;
                GatewayConfigDocument.GatewayConfig config = configDoc.getGatewayConfig();
                ServiceType[] services = config.getServiceArray();
                if (services != null && services.length > 0) {
                    ArrayList<String> serviceNames = new ArrayList<String>();
                    for (ServiceType service : services) {
                        String name = service.getName();
                        if (name == null || name.length() == 0) {
                            errorList.add(XmlError.forMessage((String)"All services must have unique non-empty names", (int)0));
                            continue;
                        }
                        if (serviceNames.indexOf(name) >= 0) {
                            errorList.add(XmlError.forMessage((String)("Service name must be unique. More than one service named '" + name + "'"), (int)0));
                            continue;
                        }
                        serviceNames.add(name);
                    }
                }
                if ((security = config.getSecurityArray()) != null && security.length > 1) {
                    errorList.add(XmlError.forMessage((String)"Multiple <security> elements found; only one allowed", (int)0));
                }
                if ((serviceDefaults = config.getServiceDefaultsArray()) != null && serviceDefaults.length > 1) {
                    errorList.add(XmlError.forMessage((String)"Multiple <service-defaults> elements found; only one allowed", (int)0));
                }
                if ((clusterConfigs = config.getClusterArray()) != null && clusterConfigs.length > 1) {
                    errorList.add(XmlError.forMessage((String)"Multiple <cluster> elements found; only one allowed", (int)0));
                }
            }
        }
        if (errorList.size() > 0) {
            String validationError = "Validation errors in gateway configuration file";
            LOGGER.error(validationError);
            for (XmlError error : errorList) {
                int line = error.getLine();
                if (line != -1) {
                    int column = error.getColumn();
                    if (column == -1) {
                        LOGGER.error("  Line: " + line);
                    } else {
                        LOGGER.error("  Line: " + line + " Column: " + column);
                    }
                }
                LOGGER.error("  " + error.getMessage().replaceAll("@" + (Object)((Object)GatewayConfigNamespace.CURRENT_NS), ""));
                if (error.getMessage().contains("notify-options") || error.getMessage().contains("notify")) {
                    validationError = "Could not start because of references to APNs in the configuration. APNs is not supported in this version of the gateway, but will be added in a future release.";
                    LOGGER.error(validationError);
                }
                if (error.getMessage().contains("DataRateString")) {
                    LOGGER.error("  (permitted data rate units are B/s, kB/s, KiB/s, kB/s, MB/s, and MiB/s)");
                }
                if (error.getCursorLocation() == null) continue;
                LOGGER.error("  " + error.getCursorLocation().xmlText());
            }
            throw new GatewayConfigParserException(validationError);
        }
    }

    private static Throwable getRootCause(Throwable throwable) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        while (throwable != null && !list.contains(throwable)) {
            list.add(throwable);
            throwable = throwable.getCause();
        }
        return (Throwable)list.get(list.size() - 1);
    }

    private static InputStream bufferToTraceLog(InputStream input, String message, Logger log) {
        InputStream output = input;
        try {
            int read;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[16384];
            while ((read = input.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, read);
            }
            buffer.flush();
            log.trace(message + "\n\n\n" + new String(buffer.toByteArray(), CHARSET_OUTPUT) + "\n\n\n");
            output = new ByteArrayInputStream(buffer.toByteArray());
        }
        catch (Exception e) {
            throw new RuntimeException("could not buffer stream", e);
        }
        return output;
    }

    private static int countNewLines(char[] ch, int start, int length) {
        int newLineCount = 0;
        for (int i = start; i < length; ++i) {
            newLineCount += ch[i] == '\n' ? 1 : 0;
        }
        return newLineCount;
    }

    private static final class XSLTransformer
    implements Callable<Boolean> {
        private InputStream streamToTransform;
        private OutputStream transformerOutput;
        private String stylesheet;

        public XSLTransformer(InputStream streamToTransform, OutputStream transformerOutput, String stylesheet) {
            this.streamToTransform = streamToTransform;
            this.transformerOutput = transformerOutput;
            this.stylesheet = stylesheet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws Exception {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            URL resource = classLoader.getResource(this.stylesheet);
            InputStream xslIn = resource.openStream();
            try {
                StreamSource xmlSource = new StreamSource(this.streamToTransform);
                StreamSource xslSource = new StreamSource(xslIn);
                StreamResult xmlResult = new StreamResult(this.transformerOutput);
                Transformer transformer = TransformerFactory.newInstance().newTransformer(xslSource);
                transformer.setOutputProperty("encoding", GatewayConfigParser.CHARSET_OUTPUT_XML);
                transformer.setErrorListener(new ErrorListener(){

                    @Override
                    public void warning(TransformerException exception) throws TransformerException {
                        throw exception;
                    }

                    @Override
                    public void fatalError(TransformerException exception) throws TransformerException {
                        throw exception;
                    }

                    @Override
                    public void error(TransformerException exception) throws TransformerException {
                        throw exception;
                    }
                });
                transformer.transform(xmlSource, xmlResult);
            }
            finally {
                this.transformerOutput.flush();
                this.transformerOutput.close();
                xslIn.close();
            }
            return Boolean.TRUE;
        }
    }

    private static final class XMLParameterInjector
    implements Callable<Boolean> {
        private InputStream souceInput;
        private OutputStreamWriter injectedOutput;
        private Map<String, String> properties;
        private Properties configuration;
        private List<String> errors;
        private int currentFlushedLine = 1;

        public XMLParameterInjector(InputStream souceInput, OutputStream injectedOutput, Map<String, String> properties, Properties configuration, List<String> errors) throws UnsupportedEncodingException {
            this.souceInput = souceInput;
            this.injectedOutput = new OutputStreamWriter(injectedOutput, GatewayConfigParser.CHARSET_OUTPUT_XML);
            this.properties = properties;
            this.configuration = configuration;
            this.errors = errors;
        }

        private void write(char[] ch, int start, int length) {
            try {
                this.currentFlushedLine += GatewayConfigParser.countNewLines(ch, start, length);
                this.injectedOutput.write(ch, start, length);
                this.injectedOutput.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private void write(char[] ch) {
            this.write(ch, 0, ch.length);
        }

        private void write(String s) {
            this.write(s.toCharArray(), 0, s.length());
        }

        private void close() {
            try {
                this.souceInput.close();
                this.injectedOutput.flush();
                this.injectedOutput.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Boolean call() throws Exception {
            try {
                SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                DefaultHandler2 handler = new DefaultHandler2(){
                    private Locator2 locator;

                    private void realignElement() {
                        String realignment = "";
                        for (int i = 0; i < this.locator.getLineNumber() - currentFlushedLine; ++i) {
                            realignment = realignment + System.getProperty("line.separator");
                        }
                        this.write(realignment);
                    }

                    @Override
                    public void setDocumentLocator(Locator locator) {
                        this.locator = (Locator2)locator;
                    }

                    @Override
                    public void startDocument() throws SAXException {
                        this.write("<?xml version=\"1.0\" encoding=\"UTF-16\" ?>" + System.getProperty("line.separator"));
                    }

                    @Override
                    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                        this.realignElement();
                        String elementName = localName == null || localName.equals("") ? qName : localName;
                        this.write("<" + elementName);
                        if (attributes != null) {
                            for (int i = 0; i < attributes.getLength(); ++i) {
                                String attributeName = attributes.getLocalName(i) == null || attributes.getLocalName(i).equals("") ? attributes.getQName(i) : attributes.getLocalName(i);
                                this.write(" " + attributeName + "=\"");
                                char[] attributeValue = attributes.getValue(i).toCharArray();
                                this.write(ConfigParameter.resolveAndReplace((char[])attributeValue, (int)0, (int)attributeValue.length, (Map)properties, (Properties)configuration, (List)errors) + "\"");
                            }
                        }
                        this.write(new char[]{'>'});
                    }

                    @Override
                    public void comment(char[] ch, int start, int length) throws SAXException {
                        this.write("<!--");
                        this.write(ch, start, length);
                        this.write("-->");
                    }

                    @Override
                    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
                        this.write(ch, start, length);
                    }

                    @Override
                    public void characters(char[] ch, int start, int length) throws SAXException {
                        this.write(ConfigParameter.resolveAndReplace((char[])ch, (int)start, (int)length, (Map)properties, (Properties)configuration, (List)errors));
                    }

                    @Override
                    public void endElement(String uri, String localName, String qName) throws SAXException {
                        this.realignElement();
                        String elementName = localName == null || localName.equals("") ? qName : localName;
                        this.write("</" + elementName + ">");
                    }
                };
                parser.getXMLReader().setProperty("http://xml.org/sax/properties/lexical-handler", handler);
                parser.getXMLReader().setProperty("http://apache.org/xml/properties/input-buffer-size", new Integer(this.souceInput.available()));
                parser.parse(this.souceInput, (DefaultHandler)handler);
            }
            finally {
                this.close();
            }
            return this.errors.size() == 0;
        }
    }
}

