/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.context.resolve;

import com.hazelcast.core.IdGenerator;
import com.hazelcast.core.Instance;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.kaazing.gateway.server.messaging.buffer.MemoryMessageBufferFactory;
import org.kaazing.gateway.service.cluster.BalancerMapListener;
import org.kaazing.gateway.service.cluster.ClusterConnectOptionsContext;
import org.kaazing.gateway.service.cluster.ClusterContext;
import org.kaazing.gateway.service.cluster.InstanceKeyListener;
import org.kaazing.gateway.service.cluster.MemberId;
import org.kaazing.gateway.service.cluster.MembershipEventListener;
import org.kaazing.gateway.service.cluster.ReceiveListener;
import org.kaazing.gateway.service.cluster.SendListener;
import org.kaazing.gateway.service.messaging.buffer.MessageBufferFactory;
import org.kaazing.gateway.service.messaging.collections.CollectionsFactory;
import org.kaazing.gateway.service.messaging.collections.MemoryCollectionsFactory;
import org.kaazing.gateway.util.Utils;

public class StandaloneClusterContext
implements ClusterContext {
    private final MessageBufferFactory messageBufferFactory;
    private final CollectionsFactory collectionsFactory;
    private final ConcurrentMap<Object, Lock> locks;
    private final ConcurrentMap<String, IdGeneratorImpl> idGenerators;
    private final String localInstanceKey = Utils.randomHexString((int)16);

    public StandaloneClusterContext() {
        this.messageBufferFactory = new MemoryMessageBufferFactory();
        this.collectionsFactory = new MemoryCollectionsFactory();
        this.locks = new ConcurrentHashMap<Object, Lock>();
        this.idGenerators = new ConcurrentHashMap<String, IdGeneratorImpl>();
    }

    public void addMembershipEventListener(MembershipEventListener eventListener) {
    }

    public void removeMembershipEventListener(MembershipEventListener eventListener) {
    }

    public void addInstanceKeyListener(InstanceKeyListener instanceKeyListener) {
    }

    public void removeInstanceKeyListener(InstanceKeyListener instanceKeyListener) {
    }

    public void addBalancerMapListener(BalancerMapListener balancerMapListener) {
    }

    public void removeBalancerMapListener(BalancerMapListener balancerMapListener) {
    }

    public void addReceiveQueue(String name) {
        throw new UnsupportedOperationException("addReceiveQueue");
    }

    public void addReceiveTopic(String name) {
        throw new UnsupportedOperationException("addReceiveTopic");
    }

    public String getClusterName() {
        return this.getLocalMember().toString();
    }

    public List<MemberId> getMemberIds() {
        ArrayList<MemberId> list = new ArrayList<MemberId>();
        list.add(this.getLocalMember());
        return list;
    }

    public List<MemberId> getAccepts() {
        return null;
    }

    public List<MemberId> getConnects() {
        return null;
    }

    public ClusterConnectOptionsContext getConnectOptions() {
        return null;
    }

    public IdGenerator getIdGenerator(String name) {
        IdGeneratorImpl newImpl;
        IdGeneratorImpl impl = (IdGeneratorImpl)this.idGenerators.get(name);
        if (impl == null && (impl = this.idGenerators.putIfAbsent(name, newImpl = new IdGeneratorImpl(name))) == null) {
            impl = newImpl;
        }
        return impl;
    }

    public MessageBufferFactory getMessageBufferFactory() {
        return this.messageBufferFactory;
    }

    public MemberId getLocalMember() {
        return new MemberId("tcp", "standalone", 0);
    }

    public String getInstanceKey(MemberId memberId) {
        return this.localInstanceKey;
    }

    public Lock getLock(Object obj) {
        Lock oldLock;
        Lock lock = (Lock)this.locks.get(obj);
        if (lock == null && (oldLock = this.locks.putIfAbsent(obj, lock = new ReentrantLock())) != null) {
            lock = oldLock;
        }
        return lock;
    }

    public <T> void removeReceiver(Class<T> type) {
        throw new UnsupportedOperationException("removeReceiver");
    }

    public <T> T send(Object msg, MemberId member) throws Exception {
        throw new UnsupportedOperationException("send");
    }

    public <T> T send(Object msg, String name) throws Exception {
        throw new UnsupportedOperationException("send");
    }

    public void send(Object msg, SendListener listener, MemberId member) {
        throw new UnsupportedOperationException("send");
    }

    public void send(Object msg, SendListener listener, String name) {
        throw new UnsupportedOperationException("send");
    }

    public <T> void setReceiver(Class<T> type, ReceiveListener<T> receiveListener) {
        throw new UnsupportedOperationException("setReceiver");
    }

    public void start() {
    }

    public void dispose() {
    }

    public CollectionsFactory getCollectionsFactory() {
        return this.collectionsFactory;
    }

    public void logClusterState() {
    }

    private class IdGeneratorImpl
    implements IdGenerator {
        private final AtomicLong currentId;
        private final String name;

        public IdGeneratorImpl(String name) {
            this.name = name;
            this.currentId = new AtomicLong(Long.MIN_VALUE);
        }

        public String getName() {
            return this.name;
        }

        public long newId() {
            return this.currentId.incrementAndGet();
        }

        public void destroy() {
            this.currentId.set(Long.MIN_VALUE);
        }

        public Object getId() {
            return this.name;
        }

        public Instance.InstanceType getInstanceType() {
            return Instance.InstanceType.ID_GENERATOR;
        }
    }
}

