/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.context.resolve;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import javax.security.auth.login.Configuration;
import org.kaazing.gateway.security.AuthenticationContext;
import org.kaazing.gateway.security.LoginContextFactory;
import org.kaazing.gateway.security.RealmContext;
import org.kaazing.gateway.security.auth.context.LoginContextFactories;

public class DefaultRealmContext
implements RealmContext {
    private final String name;
    private final String description;
    private final String[] userPrincipalClasses;
    private final Configuration configuration;
    private final LoginContextFactory loginContextFactory;
    private final AuthenticationContext authenticationContext;
    private static CharsetEncoder asciiEncoder = Charset.forName("US-ASCII").newEncoder();

    public DefaultRealmContext(String name, String description, String[] userPrincipalClasses, Configuration configuration, AuthenticationContext authenticationContext) {
        this.name = name;
        if (description != null && !asciiEncoder.canEncode(description)) {
            throw new RuntimeException("Invalid non US-ASCII character in Realm description. Realm description can only contain US-ASCII values");
        }
        this.description = description;
        this.userPrincipalClasses = userPrincipalClasses;
        this.configuration = configuration;
        this.loginContextFactory = LoginContextFactories.create((String)name, (Configuration)configuration);
        this.authenticationContext = authenticationContext;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getUserPrincipalClasses() {
        return this.userPrincipalClasses;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public LoginContextFactory getLoginContextFactory() {
        return this.loginContextFactory;
    }

    public AuthenticationContext getAuthenticationContext() {
        return this.authenticationContext;
    }
}

