/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.test.config;

import java.util.HashSet;
import java.util.Set;
import org.kaazing.gateway.server.test.config.Configuration;
import org.kaazing.gateway.server.test.config.ConfigurationVisitor;
import org.kaazing.gateway.server.test.config.Suppressible;
import org.kaazing.gateway.server.test.config.SuppressibleAuthorizationConstraintConfiguration;
import org.kaazing.gateway.server.test.config.SuppressibleConfiguration;
import org.kaazing.gateway.server.test.config.Suppressibles;

public class AuthorizationConstraintConfiguration
implements Configuration<SuppressibleAuthorizationConstraintConfiguration> {
    private final SuppressibleAuthorizationConstraintConfiguration _configuration;
    private final Set<Suppressible<String>> requiredRoles = new HashSet<Suppressible<String>>();
    private final Set<String> unsuppressibleRequiredRoles = Suppressibles.unsuppressibleSet(this.requiredRoles);

    public AuthorizationConstraintConfiguration() {
        this._configuration = new SuppressibleAuthorizationConstraintConfigurationImpl();
        this._configuration.setSuppression(Suppressibles.getDefaultSuppressions());
    }

    @Override
    public SuppressibleAuthorizationConstraintConfiguration getSuppressibleConfiguration() {
        return this._configuration;
    }

    @Override
    public void accept(ConfigurationVisitor visitor) {
        visitor.visit(this);
    }

    public void addRequireRole(String requiredRole) {
        this.unsuppressibleRequiredRoles.add(requiredRole);
    }

    public Set<String> getRequiredRoles() {
        return this.unsuppressibleRequiredRoles;
    }

    private class SuppressibleAuthorizationConstraintConfigurationImpl
    extends SuppressibleAuthorizationConstraintConfiguration {
        private Set<SuppressibleConfiguration.Suppression> _suppressions;

        private SuppressibleAuthorizationConstraintConfigurationImpl() {
        }

        @Override
        public Set<SuppressibleConfiguration.Suppression> getSuppressions() {
            return this._suppressions;
        }

        @Override
        public void setSuppression(Set<SuppressibleConfiguration.Suppression> suppressions) {
            this._suppressions = suppressions;
        }

        @Override
        public void addRequiredRole(Suppressible<String> requiredRole) {
            AuthorizationConstraintConfiguration.this.requiredRoles.add(requiredRole);
        }

        @Override
        public Set<Suppressible<String>> getRequiredRoles() {
            return AuthorizationConstraintConfiguration.this.requiredRoles;
        }
    }
}

