/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.context.resolve;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.kaazing.gateway.service.ServiceProperties;

public class DefaultServiceProperties
implements ServiceProperties {
    private static final Map<String, String> EMPTY_SIMPLE = Collections.emptyMap();
    private static final Map<String, List<ServiceProperties>> EMPTY_NESTED = Collections.emptyMap();
    private static final List<ServiceProperties> EMPTY_LIST = Collections.emptyList();
    private Map<String, String> simpleProperties = EMPTY_SIMPLE;
    private Map<String, List<ServiceProperties>> nestedProperties = EMPTY_NESTED;

    public boolean containsSimpleProperty(String name) {
        return this.simpleProperties.containsKey(name);
    }

    public String get(String name) {
        return this.simpleProperties.get(name);
    }

    public List<ServiceProperties> getNested(String name) {
        List<ServiceProperties> result = this.nestedProperties.get(name);
        return result == null ? EMPTY_LIST : result;
    }

    public List<ServiceProperties> getNested(String name, boolean create) {
        List<ServiceProperties> result;
        if (!create) {
            return this.getNested(name);
        }
        if (this.nestedProperties == EMPTY_NESTED) {
            this.nestedProperties = new HashMap<String, List<ServiceProperties>>();
        }
        if ((result = this.nestedProperties.get(name)) == null) {
            result = new LinkedList<ServiceProperties>();
            this.nestedProperties.put(name, result);
        }
        return result;
    }

    public Iterable<String> nestedPropertyNames() {
        return this.nestedProperties.keySet();
    }

    public boolean isEmpty() {
        return this.simpleProperties.isEmpty() && this.nestedProperties.isEmpty();
    }

    public Iterable<String> simplePropertyNames() {
        return this.simpleProperties.keySet();
    }

    public void put(String name, String value) {
        if (this.simpleProperties == EMPTY_SIMPLE) {
            this.simpleProperties = new HashMap<String, String>();
        }
        this.simpleProperties.put(name, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultServiceProperties that = (DefaultServiceProperties)o;
        if (this.nestedProperties != null ? !this.nestedProperties.equals(that.nestedProperties) : that.nestedProperties != null) {
            return false;
        }
        return !(this.simpleProperties != null ? !this.simpleProperties.equals(that.simpleProperties) : that.simpleProperties != null);
    }

    public int hashCode() {
        int result = this.simpleProperties != null ? this.simpleProperties.hashCode() : 0;
        result = 31 * result + (this.nestedProperties != null ? this.nestedProperties.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.simpleProperties.toString() + this.nestedProperties.toString();
    }

    String remove(String name) {
        return this.simpleProperties == null ? null : this.simpleProperties.get(name);
    }
}

