/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.context.resolve;

import com.hazelcast.core.IMap;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.Key;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.IoFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.session.IoSessionInitializer;
import org.kaazing.gateway.resource.address.Protocol;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.resource.address.ResourceAddressFactory;
import org.kaazing.gateway.resource.address.URLUtils;
import org.kaazing.gateway.security.AuthenticationContext;
import org.kaazing.gateway.security.CrossSiteConstraintContext;
import org.kaazing.gateway.security.RealmContext;
import org.kaazing.gateway.server.context.resolve.DefaultAcceptOptionsContext;
import org.kaazing.gateway.server.context.resolve.DefaultConnectOptionsContext;
import org.kaazing.gateway.server.context.resolve.DefaultServiceProperties;
import org.kaazing.gateway.server.service.AbstractSessionInitializer;
import org.kaazing.gateway.service.AcceptOptionsContext;
import org.kaazing.gateway.service.ConnectOptionsContext;
import org.kaazing.gateway.service.MonitoringEntityFactory;
import org.kaazing.gateway.service.Service;
import org.kaazing.gateway.service.ServiceContext;
import org.kaazing.gateway.service.ServiceProperties;
import org.kaazing.gateway.service.cluster.ClusterContext;
import org.kaazing.gateway.service.cluster.MemberId;
import org.kaazing.gateway.service.messaging.collections.CollectionsFactory;
import org.kaazing.gateway.transport.BridgeAcceptor;
import org.kaazing.gateway.transport.BridgeConnector;
import org.kaazing.gateway.transport.BridgeSessionInitializer;
import org.kaazing.gateway.transport.IoFilterAdapter;
import org.kaazing.gateway.transport.Transport;
import org.kaazing.gateway.transport.TransportFactory;
import org.kaazing.gateway.util.Encoding;
import org.kaazing.gateway.util.GL;
import org.kaazing.gateway.util.scheduler.SchedulerProvider;
import org.kaazing.mina.core.session.IoSessionEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServiceContext
implements ServiceContext {
    public static final String BALANCER_MAP_NAME = "balancerMap";
    public static final String MEMBERID_BALANCER_MAP_NAME = "memberIdBalancerMap";
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final String[] EMPTY_REQUIRE_ROLES = new String[0];
    private static final String AUTHENTICATION_CONNECT = "authenticationConnect";
    private static final String AUTHENTICATION_IDENTIFIER = "authenticationIdentifier";
    private static final String BALANCE_ORIGINS = "balanceOrigins";
    private static final String ENCRYPTION_KEY_ALIAS = "encryptionKeyAlias";
    private static final String GATEWAY_ORIGIN_SECURITY = "gatewayHttpOriginSecurity";
    private static final String LOGIN_CONTEXT_FACTORY = "loginContextFactory";
    private static final String ORIGIN_SECURITY = "originSecurity";
    private static final String REALM_AUTHENTICATION_COOKIE_NAMES = "realmAuthenticationCookieNames";
    private static final String REALM_AUTHENTICATION_HEADER_NAMES = "realmAuthenticationHeaderNames";
    private static final String REALM_AUTHENTICATION_PARAMETER_NAMES = "realmAuthenticationParameterNames";
    private static final String REALM_AUTHORIZATION_MODE = "realmAuthorizationMode";
    private static final String REALM_CHALLENGE_SCHEME = "realmChallengeScheme";
    private static final String REALM_DESCRIPTION = "realmDescription";
    private static final String REALM_NAME = "realmName";
    private static final String REQUIRED_ROLES = "requiredRoles";
    private static final String SERVICE_DOMAIN = "serviceDomain";
    private static final String TEMP_DIRECTORY = "tempDirectory";
    public static final String AUTH_SCHEME_APPLICATION_PREFIX = "Application ";
    private final String serviceType;
    private final String serviceName;
    private final String serviceDescription;
    private final Service service;
    private final File tempDir;
    private final File webDir;
    private final Collection<URI> balances;
    private final Collection<URI> accepts;
    private final Collection<URI> connects;
    private final ServiceProperties properties;
    private final Map<String, String> mimeMappings;
    private final Map<URI, ? extends Map<String, ? extends CrossSiteConstraintContext>> acceptConstraintsByURI;
    private final TransportFactory transportFactory;
    private List<Map<URI, Map<String, CrossSiteConstraintContext>>> authorityToSetOfAcceptConstraintsByURI;
    private final String[] requireRoles;
    private final Map<URI, ResourceAddress> bindings;
    private final ConcurrentMap<Long, IoSessionEx> activeSessions;
    private final Map<URI, IoHandler> bindHandlers;
    private final ClusterContext clusterContext;
    private final AcceptOptionsContext acceptOptionsContext;
    private final ConnectOptionsContext connectOptionsContext;
    private final RealmContext serviceRealmContext;
    private final ResourceAddressFactory resourceAddressFactory;
    private final Key encryptionKey;
    private final Logger logger;
    private final SchedulerProvider schedulerProvider;
    private final boolean supportsAccepts;
    private final boolean supportsConnects;
    private final boolean supportsMimeMappings;
    private final int processorCount;
    private int hashCode = -1;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final Map<String, Object> serviceSpecificObjects;
    private IoSessionInitializer<ConnectFuture> sessionInitializer = new IoSessionInitializer<ConnectFuture>(){

        public void initializeSession(IoSession session, ConnectFuture future) {
            session.getFilterChain().addLast("sessiontracker", (IoFilter)new IoFilterAdapter<IoSessionEx>(){

                protected void doSessionOpened(IoFilter.NextFilter nextFilter, IoSessionEx session) throws Exception {
                    DefaultServiceContext.this.addActiveSession(session);
                    super.doSessionOpened(nextFilter, (IoSession)session);
                }

                protected void doSessionClosed(IoFilter.NextFilter nextFilter, IoSessionEx session) throws Exception {
                    DefaultServiceContext.this.removeActiveSession(session);
                    super.doSessionClosed(nextFilter, (IoSession)session);
                }
            });
        }
    };
    private MonitoringEntityFactory monitoringFactory;

    public DefaultServiceContext(String serviceType, Service service) {
        this(serviceType, null, null, service, null, null, Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), new DefaultServiceProperties(), EMPTY_REQUIRE_ROLES, Collections.emptyMap(), Collections.emptyMap(), null, new DefaultAcceptOptionsContext(), new DefaultConnectOptionsContext(), null, null, null, true, true, false, 1, TransportFactory.newTransportFactory((Map)Collections.EMPTY_MAP), ResourceAddressFactory.newResourceAddressFactory());
    }

    public DefaultServiceContext(String serviceType, String serviceName, String serviceDescription, Service service, File webDir, File tempDir, Collection<URI> balances, Collection<URI> accepts, Collection<URI> connects, ServiceProperties properties, String[] requireRoles, Map<String, String> mimeMappings, Map<URI, Map<String, CrossSiteConstraintContext>> crossSiteConstraints, ClusterContext clusterContext, AcceptOptionsContext acceptOptionsContext, ConnectOptionsContext connectOptionsContext, RealmContext serviceRealmContext, Key encryptionKey, SchedulerProvider schedulerProvider, boolean supportsAccepts, boolean supportsConnects, boolean supportsMimeMappings, int processorCount, TransportFactory transportFactory, ResourceAddressFactory resourceAddressFactory) {
        this.serviceType = serviceType;
        this.serviceName = serviceName;
        this.serviceDescription = serviceDescription;
        this.service = service;
        this.webDir = webDir;
        this.tempDir = tempDir;
        this.balances = balances;
        this.accepts = accepts;
        this.connects = connects;
        this.properties = properties;
        this.requireRoles = requireRoles;
        this.mimeMappings = mimeMappings;
        this.acceptConstraintsByURI = crossSiteConstraints;
        this.bindings = new HashMap<URI, ResourceAddress>();
        this.activeSessions = new ConcurrentHashMap<Long, IoSessionEx>();
        this.bindHandlers = new HashMap<URI, IoHandler>(4);
        this.clusterContext = clusterContext;
        this.acceptOptionsContext = acceptOptionsContext;
        this.serviceRealmContext = serviceRealmContext;
        this.connectOptionsContext = connectOptionsContext;
        this.encryptionKey = encryptionKey;
        this.logger = LoggerFactory.getLogger((String)("service." + serviceType.replace("$", "_")));
        this.schedulerProvider = schedulerProvider;
        this.supportsAccepts = supportsAccepts;
        this.supportsConnects = supportsConnects;
        this.supportsMimeMappings = supportsMimeMappings;
        this.processorCount = processorCount;
        this.transportFactory = transportFactory;
        this.resourceAddressFactory = resourceAddressFactory;
        this.serviceSpecificObjects = new HashMap<String, Object>();
    }

    public boolean equals(Object otherObject) {
        ServiceContext otherServiceContext;
        if (otherObject instanceof ServiceContext && this.serviceType.equals((otherServiceContext = (ServiceContext)otherObject).getServiceType())) {
            Collection otherAccepts = otherServiceContext.getAccepts();
            for (URI uri : this.accepts) {
                if (otherAccepts.contains(uri)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = Objects.hash(this.serviceType, this.accepts, this.getServiceName());
        }
        return this.hashCode;
    }

    public int getProcessorCount() {
        return this.processorCount;
    }

    public RealmContext getServiceRealm() {
        return this.serviceRealmContext;
    }

    public String getAuthorizationMode() {
        if (this.serviceRealmContext != null && this.serviceRealmContext.getAuthenticationContext() != null) {
            return this.serviceRealmContext.getAuthenticationContext().getAuthorizationMode();
        }
        return null;
    }

    public String getSessionTimeout() {
        if (this.serviceRealmContext != null && this.serviceRealmContext.getAuthenticationContext() != null) {
            return this.serviceRealmContext.getAuthenticationContext().getSessionTimeout();
        }
        return null;
    }

    public String decrypt(String encrypted) throws Exception {
        ByteBuffer decoded = Encoding.BASE64.decode(ByteBuffer.wrap(encrypted.getBytes(UTF_8)));
        InputStream bin = IoBuffer.wrap((ByteBuffer)decoded).asInputStream();
        Cipher cipher = Cipher.getInstance(this.encryptionKey.getAlgorithm());
        cipher.init(2, this.encryptionKey);
        DataInputStream in = new DataInputStream(new CipherInputStream(bin, cipher));
        try {
            return in.readUTF();
        }
        catch (Exception e) {
            return "";
        }
    }

    public String encrypt(String plaintext) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Cipher cipher = Cipher.getInstance(this.encryptionKey.getAlgorithm());
        cipher.init(1, this.encryptionKey);
        DataOutputStream out = new DataOutputStream(new CipherOutputStream(bos, cipher));
        out.writeUTF(plaintext);
        out.close();
        ByteBuffer encoded = Encoding.BASE64.encode(ByteBuffer.wrap(bos.toByteArray(), 0, bos.size()));
        return IoBuffer.wrap((ByteBuffer)encoded).getString(UTF_8.newDecoder());
    }

    public AcceptOptionsContext getAcceptOptionsContext() {
        return this.acceptOptionsContext;
    }

    public ConnectOptionsContext getConnectOptionsContext() {
        return this.connectOptionsContext;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceDescription() {
        return this.serviceDescription;
    }

    public Collection<URI> getAccepts() {
        return this.accepts;
    }

    public Collection<URI> getBalances() {
        return this.balances;
    }

    public Collection<URI> getConnects() {
        return this.connects;
    }

    public Service getService() {
        return this.service;
    }

    public ServiceProperties getProperties() {
        return this.properties;
    }

    public String[] getRequireRoles() {
        return this.requireRoles;
    }

    public Map<String, String> getMimeMappings() {
        return this.mimeMappings;
    }

    public String getContentType(String fileExtension) {
        String contentType = fileExtension == null ? null : this.mimeMappings.get(fileExtension.toLowerCase());
        return contentType;
    }

    public Map<URI, ? extends Map<String, ? extends CrossSiteConstraintContext>> getCrossSiteConstraints() {
        return this.acceptConstraintsByURI;
    }

    public File getTempDirectory() {
        return this.tempDir;
    }

    public File getWebDirectory() {
        return this.webDir;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public SchedulerProvider getSchedulerProvider() {
        return this.schedulerProvider;
    }

    public void bind(Collection<URI> bindURIs, IoHandler handler) {
        this.bind(bindURIs, handler, this.acceptOptionsContext);
    }

    public void bind(Collection<URI> bindURIs, IoHandler handler, AcceptOptionsContext acceptOptionsContext) {
        this.bind(bindURIs, handler, acceptOptionsContext, null);
    }

    public void bind(Collection<URI> bindURIs, IoHandler handler, BridgeSessionInitializer<ConnectFuture> bridgeSessionInitializer) {
        this.bind(bindURIs, handler, this.acceptOptionsContext, bridgeSessionInitializer);
    }

    public void bindConnectsIfNecessary(Collection<URI> connectURIs) {
        for (URI connectURI : connectURIs) {
            Map<String, Object> connectOptions = this.buildResourceAddressOptions(connectURI, this.connectOptionsContext);
            ResourceAddress connectAddress = this.resourceAddressFactory.newResourceAddress(connectURI, connectOptions);
            this.bindConnectIfNecessary(connectAddress);
        }
    }

    public void unbindConnectsIfNecessary(Collection<URI> connectURIs) {
        for (URI connectURI : connectURIs) {
            Map<String, Object> connectOptions = this.buildResourceAddressOptions(connectURI, this.connectOptionsContext);
            ResourceAddress connectAddress = this.resourceAddressFactory.newResourceAddress(connectURI, connectOptions);
            this.unbindConnectIfNecessary(connectAddress);
        }
    }

    private void bindConnectIfNecessary(ResourceAddress connectAddress) {
        if (((Boolean)connectAddress.getOption(ResourceAddress.CONNECT_REQUIRES_INIT)).booleanValue()) {
            URI transportURI = connectAddress.getResource();
            String transportSchemeName = transportURI.getScheme();
            Transport transport = this.transportFactory.getTransportForScheme(transportSchemeName);
            assert (transport != null);
            transport.getConnector(connectAddress).connectInit(connectAddress);
        } else {
            ResourceAddress connectTransport = (ResourceAddress)connectAddress.getOption(ResourceAddress.TRANSPORT);
            if (connectTransport != null) {
                this.bindConnectIfNecessary(connectTransport);
            }
        }
    }

    private void unbindConnectIfNecessary(ResourceAddress connectAddress) {
        if (((Boolean)connectAddress.getOption(ResourceAddress.CONNECT_REQUIRES_INIT)).booleanValue()) {
            URI transportURI = connectAddress.getResource();
            String transportSchemeName = transportURI.getScheme();
            Transport transport = this.transportFactory.getTransportForScheme(transportSchemeName);
            assert (transport != null);
            transport.getConnector(connectAddress).connectDestroy(connectAddress);
        } else {
            ResourceAddress connectTransport = (ResourceAddress)connectAddress.getOption(ResourceAddress.TRANSPORT);
            if (connectTransport != null) {
                this.unbindConnectIfNecessary(connectTransport);
            }
        }
    }

    public void bind(Collection<URI> bindURIs, IoHandler handler, AcceptOptionsContext acceptOptionsContext, BridgeSessionInitializer<ConnectFuture> bridgeSessionInitializer) {
        if (handler == null) {
            throw new IllegalArgumentException("Cannot bind without handler");
        }
        for (URI uRI : bindURIs) {
            this.bindHandlers.put(uRI, handler);
        }
        Map<Transport, List<URI>> bindsByTransport = this.getURIsByTransport(bindURIs);
        for (Map.Entry<Transport, List<URI>> entry : bindsByTransport.entrySet()) {
            Transport transport = entry.getKey();
            List<URI> transportAccepts = entry.getValue();
            for (URI transportAccept : transportAccepts) {
                Map<String, Object> options = this.buildResourceAddressOptions(transportAccept, acceptOptionsContext);
                ResourceAddress address = this.resourceAddressFactory.newResourceAddress(transportAccept, options);
                this.bindInternal(address, handler, transport, this.sessionInitializer, bridgeSessionInitializer);
                this.bindings.put(transportAccept, address);
            }
        }
        if (this.balances != null && this.balances.size() > 0) {
            if (!this.accepts.containsAll(bindURIs)) {
                return;
            }
            CollectionsFactory collectionsFactory = this.clusterContext.getCollectionsFactory();
            if (collectionsFactory != null) {
                IMap iMap = collectionsFactory.getMap(MEMBERID_BALANCER_MAP_NAME);
                if (iMap == null) {
                    throw new IllegalStateException("MemberId to BalancerMap is null");
                }
                MemberId localMember = this.clusterContext.getLocalMember();
                HashMap memberBalanceUriMap = (HashMap)iMap.get(localMember);
                if (memberBalanceUriMap == null) {
                    memberBalanceUriMap = new HashMap();
                }
                ArrayList<URI> acceptUris = new ArrayList<URI>();
                if (this.accepts != null) {
                    acceptUris.addAll(this.accepts);
                }
                IMap sharedBalanceUriMap = collectionsFactory.getMap(BALANCER_MAP_NAME);
                for (URI balanceURI : this.balances) {
                    if (this.accepts == null) continue;
                    memberBalanceUriMap.put(balanceURI, acceptUris);
                    Set balanceUris = null;
                    HashSet<URI> newBalanceUris = null;
                    do {
                        if ((balanceUris = (Set)sharedBalanceUriMap.get((Object)balanceURI)) == null) {
                            newBalanceUris = new HashSet<URI>();
                            newBalanceUris.addAll(this.accepts);
                            balanceUris = (Set)sharedBalanceUriMap.putIfAbsent((Object)balanceURI, newBalanceUris);
                            if (balanceUris == null) break;
                        }
                        newBalanceUris = new HashSet(balanceUris);
                        newBalanceUris.addAll(this.accepts);
                    } while (!newBalanceUris.equals(balanceUris) && !sharedBalanceUriMap.replace((Object)balanceURI, (Object)balanceUris, newBalanceUris));
                    GL.info((String)"ha", (String)"Cluster member {}: service {} bound", (Object[])new Object[]{localMember, this.serviceType});
                    GL.debug((String)"ha", (String)"Added balance URIs {}, new global list is {}", (Object[])new Object[]{acceptUris, newBalanceUris});
                }
                iMap.put(localMember, memberBalanceUriMap);
            }
        }
    }

    private Map<String, Object> buildResourceAddressOptions(URI transportURI, AcceptOptionsContext acceptOptionsContext) {
        Map options = acceptOptionsContext.asOptionsMap();
        this.injectServiceOptions(transportURI, options);
        options.put("nextProtocol", null);
        return options;
    }

    private Map<String, Object> buildResourceAddressOptions(URI transportURI, ConnectOptionsContext connectOptionsContext) {
        Map options = connectOptionsContext.asOptionsMap();
        this.injectServiceOptions(transportURI, options);
        options.put("nextProtocol", null);
        return options;
    }

    private void injectServiceOptions(URI transportURI, Map<String, Object> options) {
        AuthenticationContext authenticationContext;
        Map<String, ? extends CrossSiteConstraintContext> acceptConstraints = this.acceptConstraintsByURI.get(transportURI);
        if (acceptConstraints == null && "balancer".equals(this.serviceType)) {
            if (transportURI.getPath() != null && transportURI.getPath().endsWith("/;e")) {
                transportURI = transportURI.resolve(transportURI.getPath().substring(0, transportURI.getPath().length() - "/;e".length()));
            }
            if ((acceptConstraints = this.acceptConstraintsByURI.get(URLUtils.modifyURIScheme((URI)transportURI, (String)"ws"))) == null && this.transportFactory.getProtocol(transportURI).isSecure()) {
                acceptConstraints = this.acceptConstraintsByURI.get(URLUtils.modifyURIScheme((URI)transportURI, (String)"wss"));
            }
        }
        if (acceptConstraints != null) {
            options.put(String.format("http[http/1.1].%s", ORIGIN_SECURITY), acceptConstraints);
            options.put(String.format("http[x-kaazing-handshake].%s", ORIGIN_SECURITY), acceptConstraints);
            options.put(String.format("http[httpxe/1.1].%s", ORIGIN_SECURITY), acceptConstraints);
            options.put(String.format("http[httpxe/1.1].http[http/1.1].%s", ORIGIN_SECURITY), acceptConstraints);
        }
        options.put(String.format("http[http/1.1].%s", GATEWAY_ORIGIN_SECURITY), this.authorityToSetOfAcceptConstraintsByURI);
        options.put(String.format("http[x-kaazing-handshake].%s", GATEWAY_ORIGIN_SECURITY), this.authorityToSetOfAcceptConstraintsByURI);
        options.put(String.format("http[httpxe/1.1].%s", GATEWAY_ORIGIN_SECURITY), this.authorityToSetOfAcceptConstraintsByURI);
        options.put(String.format("http[httpxe/1.1].http[http/1.1].%s", GATEWAY_ORIGIN_SECURITY), this.authorityToSetOfAcceptConstraintsByURI);
        Collection<URI> balanceOriginUris = this.toHttpBalanceOriginURIs(this.getBalances());
        if (balanceOriginUris != null) {
            options.put(String.format("http[http/1.1].%s", BALANCE_ORIGINS), balanceOriginUris);
            options.put(String.format("http[x-kaazing-handshake].%s", BALANCE_ORIGINS), balanceOriginUris);
            options.put(String.format("http[httpxe/1.1].%s", BALANCE_ORIGINS), balanceOriginUris);
            options.put(String.format("http[httpxe/1.1].http[http/1.1].%s", BALANCE_ORIGINS), balanceOriginUris);
        }
        options.put(String.format("http[http/1.1].%s", TEMP_DIRECTORY), this.tempDir);
        boolean forceNativeChallengeScheme = "directory".equals(this.getServiceType());
        if (this.serviceRealmContext != null && (authenticationContext = this.serviceRealmContext.getAuthenticationContext()) != null) {
            String challengeScheme = authenticationContext.getHttpChallengeScheme();
            boolean isApplicationChallengeScheme = challengeScheme.startsWith(AUTH_SCHEME_APPLICATION_PREFIX);
            if (isApplicationChallengeScheme && !forceNativeChallengeScheme) {
                options.put(String.format("http[http/1.1].%s", REALM_CHALLENGE_SCHEME), authenticationContext.getHttpChallengeScheme());
                for (String optionPattern : Arrays.asList("http[httpxe/1.1].%s", "http[x-kaazing-handshake].%s")) {
                    options.put(String.format(optionPattern, REALM_NAME), this.serviceRealmContext.getName());
                    options.put(String.format(optionPattern, REQUIRED_ROLES), this.getRequireRoles());
                    options.put(String.format(optionPattern, REALM_AUTHORIZATION_MODE), authenticationContext.getAuthorizationMode());
                    options.put(String.format(optionPattern, REALM_CHALLENGE_SCHEME), authenticationContext.getHttpChallengeScheme());
                    options.put(String.format(optionPattern, REALM_DESCRIPTION), this.serviceRealmContext.getDescription());
                    options.put(String.format(optionPattern, REALM_AUTHENTICATION_HEADER_NAMES), authenticationContext.getHttpHeaders());
                    options.put(String.format(optionPattern, REALM_AUTHENTICATION_PARAMETER_NAMES), authenticationContext.getHttpQueryParameters());
                    options.put(String.format(optionPattern, REALM_AUTHENTICATION_COOKIE_NAMES), authenticationContext.getHttpCookieNames());
                    options.put(String.format(optionPattern, LOGIN_CONTEXT_FACTORY), this.serviceRealmContext.getLoginContextFactory());
                    options.put(String.format(optionPattern, AUTHENTICATION_CONNECT), this.getProperties().get("authentication.connect"));
                    options.put(String.format(optionPattern, AUTHENTICATION_IDENTIFIER), this.getProperties().get("authentication.identifier"));
                    options.put(String.format(optionPattern, ENCRYPTION_KEY_ALIAS), this.getProperties().get("encryption.key.alias"));
                    options.put(String.format(optionPattern, SERVICE_DOMAIN), this.getProperties().get("service.domain"));
                }
            }
            if (!isApplicationChallengeScheme || forceNativeChallengeScheme) {
                String optionPattern = "http[http/1.1].%s";
                options.put(String.format(optionPattern, REALM_NAME), this.serviceRealmContext.getName());
                options.put(String.format(optionPattern, REQUIRED_ROLES), this.getRequireRoles());
                options.put(String.format(optionPattern, REALM_AUTHORIZATION_MODE), authenticationContext.getAuthorizationMode());
                options.put(String.format(optionPattern, REALM_CHALLENGE_SCHEME), authenticationContext.getHttpChallengeScheme());
                options.put(String.format(optionPattern, REALM_DESCRIPTION), this.serviceRealmContext.getDescription());
                options.put(String.format(optionPattern, REALM_AUTHENTICATION_HEADER_NAMES), authenticationContext.getHttpHeaders());
                options.put(String.format(optionPattern, REALM_AUTHENTICATION_PARAMETER_NAMES), authenticationContext.getHttpQueryParameters());
                options.put(String.format(optionPattern, REALM_AUTHENTICATION_COOKIE_NAMES), authenticationContext.getHttpCookieNames());
                options.put(String.format(optionPattern, LOGIN_CONTEXT_FACTORY), this.serviceRealmContext.getLoginContextFactory());
                options.put(String.format(optionPattern, AUTHENTICATION_CONNECT), this.getProperties().get("authentication.connect"));
                options.put(String.format(optionPattern, AUTHENTICATION_IDENTIFIER), this.getProperties().get("authentication.identifier"));
                options.put(String.format(optionPattern, ENCRYPTION_KEY_ALIAS), this.getProperties().get("encryption.key.alias"));
                options.put(String.format(optionPattern, SERVICE_DOMAIN), this.getProperties().get("service.domain"));
            }
        }
    }

    private Collection<URI> toHttpBalanceOriginURIs(Collection<URI> balances) {
        if (balances == null || balances.isEmpty()) {
            return balances;
        }
        ArrayList<URI> result = new ArrayList<URI>(balances.size());
        for (URI uri : balances) {
            if (uri == null) continue;
            try {
                String scheme = uri.getScheme();
                if ("ws".equals(scheme)) {
                    result.add(new URI("http", uri.getAuthority(), uri.getPath(), uri.getQuery(), uri.getFragment()));
                    continue;
                }
                if ("wss".equals(scheme)) {
                    result.add(new URI("https", uri.getAuthority(), uri.getPath(), uri.getQuery(), uri.getFragment()));
                    continue;
                }
                result.add(uri);
            }
            catch (URISyntaxException e) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.warn(String.format("Cannot translate balanc uri '%s' into a http balance origin.", uri));
            }
        }
        return result;
    }

    private void bindInternal(ResourceAddress address, IoHandler handler, Transport transport, final IoSessionInitializer<ConnectFuture> sessionInitializer, final BridgeSessionInitializer<ConnectFuture> bridgeSessionInitializer) {
        BridgeAcceptor acceptor = transport.getAcceptor(address);
        try {
            acceptor.bind(address, handler, (BridgeSessionInitializer)new BridgeSessionInitializer<ConnectFuture>(){

                public BridgeSessionInitializer<ConnectFuture> getParentInitializer(Protocol protocol) {
                    return bridgeSessionInitializer != null ? bridgeSessionInitializer.getParentInitializer(protocol) : null;
                }

                public void initializeSession(IoSession session, ConnectFuture future) {
                    sessionInitializer.initializeSession(session, (IoFuture)future);
                    if (bridgeSessionInitializer != null) {
                        bridgeSessionInitializer.initializeSession(session, (IoFuture)future);
                    }
                }
            });
        }
        catch (RuntimeException re) {
            throw new RuntimeException(String.format("Error binding to %s: %s", address.getResource(), re.getMessage()), re);
        }
    }

    private Map<Transport, List<URI>> getURIsByTransport(Collection<URI> uris) {
        HashMap<Transport, List<URI>> urisByTransport = new HashMap<Transport, List<URI>>();
        for (URI uri : uris) {
            String uriScheme = uri.getScheme();
            Transport transport = this.transportFactory.getTransportForScheme(uriScheme);
            ArrayList<URI> list = (ArrayList<URI>)urisByTransport.get(transport);
            if (list == null) {
                list = new ArrayList<URI>();
                urisByTransport.put(transport, list);
            }
            list.add(uri);
        }
        return urisByTransport;
    }

    public void unbind(Collection<URI> bindURIs, IoHandler handler) {
        CollectionsFactory factory;
        if (handler == null) {
            throw new IllegalArgumentException("Cannot unbind without handler");
        }
        for (URI uri : bindURIs) {
            IoHandler bindHandler = this.bindHandlers.get(uri);
            if (bindHandler == null) continue;
            if (!handler.equals(bindHandler)) {
                throw new IllegalArgumentException("Cannot unbind with a handler " + handler + " different from the one used for binding " + bindHandler + " to URI " + uri);
            }
            this.bindHandlers.remove(uri);
        }
        if (this.balances != null && this.balances.size() > 0 && (factory = this.clusterContext.getCollectionsFactory()) != null) {
            IMap memberIdBalancerUriMap = factory.getMap(MEMBERID_BALANCER_MAP_NAME);
            if (memberIdBalancerUriMap == null) {
                throw new IllegalStateException("MemberId to BalancerMap is null");
            }
            MemberId localMember = this.clusterContext.getLocalMember();
            Map memberBalanceUriMap = (Map)memberIdBalancerUriMap.get(localMember);
            if (memberBalanceUriMap == null) {
                throw new IllegalStateException("Member balancerMap is null for member " + localMember);
            }
            IMap sharedBalanceUriMap = factory.getMap(BALANCER_MAP_NAME);
            for (URI balanceURI : this.balances) {
                boolean didRemove;
                if (this.accepts == null) continue;
                memberBalanceUriMap.remove(balanceURI);
                Set balanceUris = null;
                HashSet newBalanceUris = null;
                do {
                    didRemove = false;
                    balanceUris = (Set)sharedBalanceUriMap.get((Object)balanceURI);
                    if (balanceUris == null) continue;
                    newBalanceUris = new HashSet(balanceUris);
                    for (URI acceptUri : this.accepts) {
                        didRemove = didRemove || newBalanceUris.remove(acceptUri);
                    }
                } while (didRemove && (!newBalanceUris.isEmpty() || !sharedBalanceUriMap.remove((Object)balanceURI, (Object)balanceUris)) && !sharedBalanceUriMap.replace((Object)balanceURI, (Object)balanceUris, newBalanceUris));
                GL.info((String)"ha", (String)"Cluster member {}: service {} unbound", (Object[])new Object[]{localMember, this.serviceType});
                GL.debug((String)"ha", (String)"Removed balance URIs {}, new global list is {}", (Object[])new Object[]{this.accepts, newBalanceUris});
            }
            memberIdBalancerUriMap.put(localMember, memberBalanceUriMap);
        }
        for (URI uri : bindURIs) {
            String uriScheme = uri.getScheme();
            Transport transport = this.transportFactory.getTransportForScheme(uriScheme);
            ResourceAddress address = this.bindings.remove(uri);
            if (address == null) continue;
            transport.getAcceptor(address).unbind(address);
        }
    }

    public ConnectFuture connect(URI connectURI, IoHandler connectHandler, IoSessionInitializer<ConnectFuture> connectSessionInitializer) {
        ResourceAddress address = this.resourceAddressFactory.newResourceAddress(connectURI, this.connectOptionsContext.asOptionsMap());
        return this.connect(address, connectHandler, connectSessionInitializer);
    }

    public ConnectFuture connect(ResourceAddress address, IoHandler connectHandler, final IoSessionInitializer<ConnectFuture> connectSessionInitializer) {
        String uriScheme = address.getExternalURI().getScheme();
        Transport transport = this.transportFactory.getTransportForScheme(uriScheme);
        BridgeConnector connector = transport.getConnector(address);
        return connector.connect(address, connectHandler, (IoSessionInitializer)new IoSessionInitializer<ConnectFuture>(){

            public void initializeSession(IoSession session, ConnectFuture future) {
                DefaultServiceContext.this.sessionInitializer.initializeSession(session, (IoFuture)future);
                if (connectSessionInitializer != null) {
                    connectSessionInitializer.initializeSession(session, (IoFuture)future);
                }
            }
        });
    }

    public Collection<IoSessionEx> getActiveSessions() {
        return this.activeSessions.values();
    }

    public IoSessionEx getActiveSession(Long sessionId) {
        if (sessionId == null) {
            return null;
        }
        return (IoSessionEx)this.activeSessions.get(sessionId);
    }

    public void addActiveSession(IoSessionEx session) {
        this.activeSessions.put(session.getId(), session);
    }

    public void removeActiveSession(IoSessionEx session) {
        this.activeSessions.remove(session.getId());
    }

    public void init() throws Exception {
        this.getService().init((ServiceContext)this);
    }

    public void start() throws Exception {
        if (this.started.compareAndSet(false, true)) {
            this.getService().start();
        }
    }

    public void stop() throws Exception {
        if (this.started.compareAndSet(true, false)) {
            this.service.quiesce();
            this.service.stop();
        }
    }

    public void destroy() throws Exception {
        this.getService().destroy();
    }

    public boolean supportsAccepts() {
        return this.supportsAccepts;
    }

    public boolean supportsConnects() {
        return this.supportsConnects;
    }

    public boolean supportsMimeMappings() {
        return this.supportsMimeMappings;
    }

    public void setListsOfAcceptConstraintsByURI(List<Map<URI, Map<String, CrossSiteConstraintContext>>> authorityToSetOfAcceptConstraintsByURI) {
        this.authorityToSetOfAcceptConstraintsByURI = authorityToSetOfAcceptConstraintsByURI;
    }

    public Map<String, Object> getServiceSpecificObjects() {
        return this.serviceSpecificObjects;
    }

    public IoSessionInitializer<ConnectFuture> getSessionInitializor() {
        return this.sessionInitializer;
    }

    public void setSessionInitializor(IoSessionInitializer<ConnectFuture> ioSessionInitializer) {
        this.sessionInitializer = ioSessionInitializer;
    }

    public MonitoringEntityFactory getMonitoringFactory() {
        return this.monitoringFactory;
    }

    public void setMonitoringFactory(MonitoringEntityFactory monitoringFactory) {
        this.monitoringFactory = monitoringFactory;
    }

    public class ServiceSessionFilter
    extends IoFilterAdapter<IoSessionEx> {
        protected void doSessionOpened(IoFilter.NextFilter nextFilter, IoSessionEx session) throws Exception {
            DefaultServiceContext.this.activeSessions.put(session.getId(), session);
            super.doSessionOpened(nextFilter, (IoSession)session);
        }

        protected void doSessionClosed(IoFilter.NextFilter nextFilter, IoSessionEx session) throws Exception {
            DefaultServiceContext.this.activeSessions.remove(session.getId());
            super.doSessionClosed(nextFilter, (IoSession)session);
        }
    }

    public final class StandardSessionInitializer
    extends AbstractSessionInitializer {
        @Override
        public void initializeSession(IoSession session, ConnectFuture future) {
            super.initializeSession(session, future);
            session.getFilterChain().addLast("sessiontracker", (IoFilter)new ServiceSessionFilter());
        }
    }
}

