/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServer;
import org.apache.log4j.LogManager;
import org.apache.log4j.config.PropertySetter;
import org.apache.log4j.helpers.FileWatchdog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.xml.DOMConfigurator;
import org.kaazing.gateway.server.Gateway;
import org.kaazing.gateway.server.Launcher;
import org.kaazing.gateway.server.api.GatewayAlreadyRunningException;
import org.kaazing.gateway.server.config.parse.GatewayConfigParser;
import org.kaazing.gateway.server.config.sep2014.GatewayConfigDocument;
import org.kaazing.gateway.server.context.GatewayContext;
import org.kaazing.gateway.server.context.resolve.GatewayContextResolver;
import org.kaazing.gateway.server.impl.VersionUtils;
import org.slf4j.Logger;
import org.w3c.dom.Element;

final class GatewayImpl
implements Gateway {
    private static final String DEFAULT_CONFIG_DIRECTORY = "conf/";
    private static final String DEFAULT_TEMP_DIRECTORY = "temp/";
    private static final String DEFAULT_WEB_DIRECTORY = "web/";
    private static final String DEFAULT_GATEWAY_CONFIG_XML = "gateway-config.xml";
    private static final String DEFAULT_GATEWAY_CONFIG_MINIMAL_XML = "gateway-config-minimal.xml";
    private static final String DEFAULT_LOG4J_CONFIG_XML = "log4j-config.xml";
    private static final String DEFAULT_LOG_DIRECTORY = "log/";
    private static final long DEFAULT_LOG_REFRESH_INTERVAL_MILLIS = 60000L;
    private static final Logger LOGGER = Launcher.getGatewayStartupLogger();
    private Properties env;
    private MBeanServer jmxMBeanServer;
    private Launcher gateway;
    private Gateway baseGateway;
    private KaazingFileWatchdog watchDog;

    public GatewayImpl(Gateway baseGateway) {
        this.baseGateway = baseGateway;
    }

    public void setProperties(Properties properties) {
        if (this.env == null) {
            this.env = properties;
        } else {
            this.env.putAll((Map<?, ?>)properties);
        }
        if (this.baseGateway != null) {
            this.baseGateway.setProperties(properties);
        }
    }

    public Properties getProperties() {
        Properties configuration = new Properties();
        configuration.putAll((Map<?, ?>)this.env);
        if (this.baseGateway != null) {
            configuration.putAll((Map<?, ?>)this.baseGateway.getProperties());
        }
        return configuration;
    }

    public void destroy() throws Exception {
        if (this.baseGateway != null) {
            this.baseGateway.destroy();
        }
        if (this.watchDog != null) {
            this.watchDog.stop();
            this.watchDog = null;
        }
        if (this.gateway != null) {
            this.gateway.destroy();
            this.gateway = null;
        }
    }

    public void launch() throws Exception {
        String gatewayWebDirectoryProperty;
        File webRootDir;
        File logDir;
        File tempDir;
        File configDir;
        boolean bypassPlatformCheck;
        if (this.baseGateway != null) {
            this.baseGateway.launch();
        }
        if (this.gateway != null) {
            throw new GatewayAlreadyRunningException("An instance of the Gateway is already running");
        }
        Properties configuration = this.getProperties();
        if (configuration == null) {
            throw new Exception("No environment has been specified");
        }
        String bypassPlatformCheckStr = configuration.getProperty("bypassPlatformCheck");
        boolean bl = bypassPlatformCheck = bypassPlatformCheckStr != null && !bypassPlatformCheckStr.equalsIgnoreCase("false") && !bypassPlatformCheckStr.equalsIgnoreCase("no") && !bypassPlatformCheckStr.equalsIgnoreCase("n");
        if (!bypassPlatformCheck && !GatewayImpl.supportedJavaVersion(1, 7, "0_21")) {
            throw new RuntimeException("Unsupported JDK version, Please install Java SE 7.0 patch 21 or later and relaunch Kaazing WebSocket Gateway");
        }
        String gatewayHomeProperty = configuration.getProperty("GATEWAY_HOME");
        if (gatewayHomeProperty == null) {
            throw new IllegalArgumentException("GATEWAY_HOME directory was not specified");
        }
        File homeDir = new File(gatewayHomeProperty);
        if (!homeDir.isDirectory()) {
            throw new IllegalArgumentException("GATEWAY_HOME is not a valid directory: " + homeDir.getAbsolutePath());
        }
        String gatewayConfigDirectoryProperty = configuration.getProperty("GATEWAY_CONFIG_DIRECTORY");
        File file = configDir = gatewayConfigDirectoryProperty != null ? new File(gatewayConfigDirectoryProperty) : new File(homeDir, DEFAULT_CONFIG_DIRECTORY);
        if (!configDir.isDirectory()) {
            throw new IllegalArgumentException("GATEWAY_CONFIG_DIRECTORY is not a valid directory: " + configDir.getAbsolutePath());
        }
        configuration.setProperty("GATEWAY_CONFIG_DIRECTORY", configDir.toString());
        String gatewayTempDirectoryProperty = configuration.getProperty("GATEWAY_TEMP_DIRECTORY");
        File file2 = tempDir = gatewayTempDirectoryProperty != null ? new File(gatewayTempDirectoryProperty) : new File(homeDir, DEFAULT_TEMP_DIRECTORY);
        if (!tempDir.isDirectory()) {
            throw new IllegalArgumentException("GATEWAY_TEMP_DIRECTORY is not a valid directory: " + tempDir.getAbsolutePath());
        }
        String gatewayLogDirectoryProperty = configuration.getProperty("GATEWAY_LOG_DIRECTORY");
        File file3 = logDir = gatewayLogDirectoryProperty != null ? new File(gatewayLogDirectoryProperty) : new File(homeDir, DEFAULT_LOG_DIRECTORY);
        if (!logDir.exists()) {
            logDir.mkdir();
        }
        if (!logDir.isDirectory()) {
            throw new IllegalArgumentException("GATEWAY_LOG_DIRECTORY is not a valid directory or could not be created: " + logDir.getAbsolutePath());
        }
        configuration.setProperty("GATEWAY_LOG_DIRECTORY", logDir.toString());
        File gatewayConfigFile = null;
        String gatewayConfigProperty = configuration.getProperty("GATEWAY_CONFIG");
        try {
            URL configURL = new URL(gatewayConfigProperty);
            String path = configURL.getPath();
            ReadableByteChannel rbc = Channels.newChannel(configURL.openStream());
            File configFile = new File(configDir, path.substring(path.lastIndexOf(47) + 1));
            try (FileOutputStream fos = new FileOutputStream(configFile);){
                fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
            }
            configuration.setProperty("GATEWAY_CONFIG", configFile.getPath());
            gatewayConfigProperty = configuration.getProperty("GATEWAY_CONFIG");
        }
        catch (MalformedURLException configURL) {
        }
        catch (IOException e) {
            throw new RuntimeException("Could not fetch config from url: " + gatewayConfigProperty, e);
        }
        if (gatewayConfigProperty != null) {
            gatewayConfigFile = new File(gatewayConfigProperty);
            if (!gatewayConfigFile.isFile() || !gatewayConfigFile.canRead()) {
                throw new IllegalArgumentException("GATEWAY_CONFIG was specified but is not a valid, readable file: " + gatewayConfigFile.getAbsolutePath());
            }
        } else {
            gatewayConfigFile = new File(configDir, DEFAULT_GATEWAY_CONFIG_XML);
            if (!gatewayConfigFile.exists()) {
                gatewayConfigFile = new File(configDir, DEFAULT_GATEWAY_CONFIG_MINIMAL_XML);
            }
            if (!gatewayConfigFile.isFile() || !gatewayConfigFile.canRead()) {
                throw new IllegalArgumentException("GATEWAY_CONFIG was not specified, and no default readable config file could be found in the conf/ directory");
            }
        }
        File file4 = webRootDir = (gatewayWebDirectoryProperty = configuration.getProperty("GATEWAY_WEB_DIRECTORY")) != null ? new File(gatewayWebDirectoryProperty) : new File(homeDir, DEFAULT_WEB_DIRECTORY);
        if (!webRootDir.exists()) {
            webRootDir.mkdir();
        }
        if (!webRootDir.isDirectory()) {
            throw new IllegalArgumentException("GATEWAY_WEB_DIRECTORY is not a valid directory or could not be created: " + webRootDir.getAbsolutePath());
        }
        String overrideLogging = configuration.getProperty("OVERRIDE_LOGGING");
        if (overrideLogging == null || !Boolean.parseBoolean(overrideLogging)) {
            this.configureLogging(configDir, configuration);
        }
        this.displayVersionInfo();
        LOGGER.info("Configuration file: " + gatewayConfigFile.getCanonicalPath());
        GatewayConfigParser parser = new GatewayConfigParser(configuration);
        GatewayConfigDocument config = parser.parse(gatewayConfigFile);
        GatewayContextResolver resolver = new GatewayContextResolver(configDir, webRootDir, tempDir, this.jmxMBeanServer);
        GatewayContext context = resolver.resolve(config, configuration);
        this.gateway = new Launcher();
        try {
            this.gateway.init(context);
        }
        catch (Exception e) {
            LOGGER.error(String.format("Error starting Gateway: caught exception %s", e));
            throw e;
        }
    }

    public void setMBeanServer(MBeanServer server) {
        this.jmxMBeanServer = server;
        if (this.baseGateway != null) {
            this.baseGateway.setMBeanServer(server);
        }
    }

    private void configureLogging(File configDir, Properties configuration) throws Exception {
        File log4jConfigFile;
        String log4jConfigProperty = configuration.getProperty("LOG4J_CONFIG");
        File file = log4jConfigFile = log4jConfigProperty != null ? new File(log4jConfigProperty) : new File(configDir, DEFAULT_LOG4J_CONFIG_XML);
        if (!log4jConfigFile.isFile() || !log4jConfigFile.canRead()) {
            throw new IllegalArgumentException("LOG4J_CONFIG is not a valid, readable file: " + log4jConfigFile.getAbsolutePath());
        }
        String log4jConfigRefreshInterval = configuration.getProperty("LOG4J_CONFIG_REFRESH_INTERVAL");
        long log4jConfigRefreshIntervalMillis = 60000L;
        if (log4jConfigRefreshInterval != null) {
            try {
                long newInterval = Long.parseLong(log4jConfigRefreshInterval);
                log4jConfigRefreshIntervalMillis = newInterval * 1000L;
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException(String.format("The %s value of %s is not a valid integer value.", "LOG4J_CONFIG_REFRESH_INTERVAL", log4jConfigRefreshInterval));
            }
        }
        if (log4jConfigRefreshIntervalMillis <= 0L) {
            KaazingDOMConfigurator configurator = new KaazingDOMConfigurator(configuration);
            configurator.doConfigure(log4jConfigFile.toURI().toURL(), LogManager.getLoggerRepository());
        } else {
            this.watchDog = new KaazingFileWatchdog(log4jConfigFile, configuration);
            this.watchDog.setDelay(log4jConfigRefreshIntervalMillis);
            this.watchDog.start();
        }
    }

    private void displayVersionInfo() {
        String gatewayProductTitle = VersionUtils.getGatewayProductTitle();
        String gatewayProductVersion = VersionUtils.getGatewayProductVersion();
        if (gatewayProductVersion == null) {
            LOGGER.info(gatewayProductTitle);
        } else {
            LOGGER.info(gatewayProductTitle + " (" + gatewayProductVersion + ")");
        }
    }

    private static boolean supportedJavaVersion(int major, int minor, String point) {
        return GatewayImpl.supportedJavaVersion(System.getProperty("java.version"), System.getProperty("java.vendor"), major, minor, point);
    }

    static boolean supportedJavaVersion(String javaVersion, String javaVendor, int major, int minor, String point) {
        String[] versionParts = javaVersion.split("\\.");
        int currentMajor = Integer.parseInt(versionParts[0]);
        int currentMinor = Integer.parseInt(versionParts[1]);
        String currentPoint = versionParts[2];
        if (currentMajor > major) {
            return true;
        }
        if (currentMajor == major) {
            if (currentMinor > minor) {
                return true;
            }
            if (currentMinor == minor) {
                return javaVendor.startsWith("Azul") || currentPoint.compareTo(point) >= 0;
            }
        }
        return false;
    }

    private class KaazingFileWatchdog
    extends FileWatchdog {
        private File log4jConfigFile;
        private Properties properties;

        KaazingFileWatchdog(File log4jConfigFile, Properties properties) {
            super(log4jConfigFile.getAbsolutePath());
            this.log4jConfigFile = log4jConfigFile;
            this.properties = properties;
            this.doOnChange();
        }

        public void doOnChange() {
            if (this.log4jConfigFile != null) {
                KaazingDOMConfigurator configurator = new KaazingDOMConfigurator(this.properties);
                try {
                    configurator.doConfigure(this.log4jConfigFile.toURI().toURL(), LogManager.getLoggerRepository());
                }
                catch (MalformedURLException ex) {
                    System.err.println("Error configuring LOG4J, unable to load file: " + this.log4jConfigFile.getAbsolutePath());
                }
            }
        }
    }

    private class KaazingDOMConfigurator
    extends DOMConfigurator {
        private Properties properties;

        KaazingDOMConfigurator(Properties properties) {
            this.properties = properties;
        }

        protected void setParameter(Element elem, PropertySetter propSetter) {
            String paramName = OptionConverter.substVars((String)elem.getAttribute("name"), (Properties)this.properties);
            String value = elem.getAttribute("value");
            value = OptionConverter.substVars((String)OptionConverter.convertSpecialChars((String)value), (Properties)this.properties);
            propSetter.setProperty(paramName, value);
        }
    }
}

