/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.test.config.builder;

import java.util.Set;
import org.kaazing.gateway.server.test.config.LoginModuleConfiguration;
import org.kaazing.gateway.server.test.config.RealmConfiguration;
import org.kaazing.gateway.server.test.config.Suppressible;
import org.kaazing.gateway.server.test.config.SuppressibleConfiguration;
import org.kaazing.gateway.server.test.config.builder.AbstractConfigurationBuilder;
import org.kaazing.gateway.server.test.config.builder.AbstractLoginModuleConfigurationBuilder;

public abstract class AbstractRealmConfigurationBuilder<R>
extends AbstractConfigurationBuilder<RealmConfiguration, R> {
    public AbstractRealmConfigurationBuilder<R> name(String name) {
        ((RealmConfiguration)this.configuration).getSuppressibleConfiguration().setName(new Suppressible<String>(name, this.getCurrentSuppressions()));
        return this;
    }

    public AbstractRealmConfigurationBuilder<R> description(String description) {
        ((RealmConfiguration)this.configuration).getSuppressibleConfiguration().setDescription(new Suppressible<String>(description, this.getCurrentSuppressions()));
        return this;
    }

    public abstract AbstractLoginModuleConfigurationBuilder<? extends AbstractRealmConfigurationBuilder<R>> loginModule();

    protected AbstractRealmConfigurationBuilder(RealmConfiguration configuration, R result, Set<SuppressibleConfiguration.Suppression> suppressions) {
        super(configuration, result, suppressions);
    }

    public AbstractRealmConfigurationBuilder<R> httpChallengeScheme(String httpChallengeScheme) {
        ((RealmConfiguration)this.configuration).getSuppressibleConfiguration().setHttpChallengeScheme(new Suppressible<String>(httpChallengeScheme, this.getCurrentSuppressions()));
        return this;
    }

    public AbstractRealmConfigurationBuilder<R> httpHeader(String header) {
        ((RealmConfiguration)this.configuration).getSuppressibleConfiguration().addHttpHeader(new Suppressible<String>(header, this.getCurrentSuppressions()));
        return this;
    }

    public AbstractRealmConfigurationBuilder<R> httpQueryParameter(String queryParameter) {
        ((RealmConfiguration)this.configuration).getSuppressibleConfiguration().addHttpQueryParameter(new Suppressible<String>(queryParameter, this.getCurrentSuppressions()));
        return this;
    }

    public AbstractRealmConfigurationBuilder<R> httpCookie(String cookie) {
        ((RealmConfiguration)this.configuration).getSuppressibleConfiguration().addHttpCookie(new Suppressible<String>(cookie, this.getCurrentSuppressions()));
        return this;
    }

    public AbstractRealmConfigurationBuilder<R> authorizationMode(String chars) {
        ((RealmConfiguration)this.configuration).getSuppressibleConfiguration().setAuthorizationMode(new Suppressible<String>(chars, this.getCurrentSuppressions()));
        return this;
    }

    public AbstractRealmConfigurationBuilder<R> sessionTimeout(String chars) {
        ((RealmConfiguration)this.configuration).getSuppressibleConfiguration().setSessionTimeout(new Suppressible<String>(chars, this.getCurrentSuppressions()));
        return this;
    }

    public AbstractRealmConfigurationBuilder<R> suppress(SuppressibleConfiguration.Suppression ... suppressions) {
        super.addCurrentSuppressions(suppressions);
        return this;
    }

    public static class AddLoginModuleBuilder<R extends AbstractRealmConfigurationBuilder<?>>
    extends AbstractLoginModuleConfigurationBuilder<R> {
        protected AddLoginModuleBuilder(R result, Set<SuppressibleConfiguration.Suppression> suppressions) {
            super(new LoginModuleConfiguration(), result, suppressions);
        }

        @Override
        public R done() {
            ((RealmConfiguration)((AbstractRealmConfigurationBuilder)this.result).configuration).getLoginModules().add((LoginModuleConfiguration)this.configuration);
            return (R)((AbstractRealmConfigurationBuilder)super.done());
        }
    }
}

