/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.test;

import java.io.File;
import java.net.URI;
import java.security.KeyStore;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanServer;
import org.kaazing.gateway.server.Launcher;
import org.kaazing.gateway.server.config.sep2014.AuthenticationType;
import org.kaazing.gateway.server.config.sep2014.AuthorizationConstraintType;
import org.kaazing.gateway.server.config.sep2014.ClusterConnectOptionsType;
import org.kaazing.gateway.server.config.sep2014.ClusterType;
import org.kaazing.gateway.server.config.sep2014.CrossSiteConstraintType;
import org.kaazing.gateway.server.config.sep2014.GatewayConfigDocument;
import org.kaazing.gateway.server.config.sep2014.LoginModuleOptionsType;
import org.kaazing.gateway.server.config.sep2014.LoginModuleType;
import org.kaazing.gateway.server.config.sep2014.LoginModulesType;
import org.kaazing.gateway.server.config.sep2014.MimeMappingType;
import org.kaazing.gateway.server.config.sep2014.RealmType;
import org.kaazing.gateway.server.config.sep2014.SecurityStoreType;
import org.kaazing.gateway.server.config.sep2014.SecurityType;
import org.kaazing.gateway.server.config.sep2014.ServiceAcceptOptionsType;
import org.kaazing.gateway.server.config.sep2014.ServiceConnectOptionsType;
import org.kaazing.gateway.server.config.sep2014.ServiceDefaultsType;
import org.kaazing.gateway.server.config.sep2014.ServicePropertiesType;
import org.kaazing.gateway.server.config.sep2014.ServiceType;
import org.kaazing.gateway.server.config.sep2014.SuccessType;
import org.kaazing.gateway.server.context.GatewayContext;
import org.kaazing.gateway.server.context.resolve.ContextResolver;
import org.kaazing.gateway.server.context.resolve.DefaultSecurityContext;
import org.kaazing.gateway.server.context.resolve.GatewayContextResolver;
import org.kaazing.gateway.server.test.config.AuthorizationConstraintConfiguration;
import org.kaazing.gateway.server.test.config.ClusterConfiguration;
import org.kaazing.gateway.server.test.config.CrossOriginConstraintConfiguration;
import org.kaazing.gateway.server.test.config.GatewayConfiguration;
import org.kaazing.gateway.server.test.config.LoginModuleConfiguration;
import org.kaazing.gateway.server.test.config.NestedServicePropertiesConfiguration;
import org.kaazing.gateway.server.test.config.RealmConfiguration;
import org.kaazing.gateway.server.test.config.SecurityConfiguration;
import org.kaazing.gateway.server.test.config.ServiceConfiguration;
import org.kaazing.gateway.server.test.config.ServiceDefaultsConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class Gateway {
    private final Launcher launcher = new Launcher();
    private volatile State state = State.STOPPED;

    public void start(GatewayConfiguration configuration) throws Exception {
        switch (this.state) {
            case STOPPED: {
                this.state = State.STARTING;
            }
        }
        switch (this.state) {
            case STARTING: {
                GatewayContext context = this.createGatewayContext(configuration);
                this.launcher.init(context);
                this.state = State.STARTED;
            }
        }
    }

    public GatewayContext createGatewayContext(GatewayConfiguration configuration) throws Exception {
        GatewayConfigDocument gatewayConfigDocument = GatewayConfigDocument.Factory.newInstance();
        GatewayConfigDocument.GatewayConfig gatewayConfig = gatewayConfigDocument.addNewGatewayConfig();
        this.setCluster(gatewayConfig, configuration.getCluster());
        this.setServiceDefaults(gatewayConfig, configuration.getServiceDefaults());
        this.appendServices(gatewayConfig, configuration.getServices());
        if (configuration.getSecurity() != null) {
            this.appendRealms(gatewayConfig, configuration.getSecurity().getRealms());
            this.appendKeyStoreTrustStore(gatewayConfig, configuration.getSecurity());
        }
        SecurityContextResolver securityResolver = new SecurityContextResolver(configuration.getSecurity());
        File webRootDir = configuration.getWebRootDirectory();
        File tempDir = configuration.getTempDirectory();
        MBeanServer jmxMBeanServer = configuration.getJmxMBeanServer();
        GatewayContextResolver resolver = new GatewayContextResolver(securityResolver, webRootDir, tempDir, jmxMBeanServer);
        GatewayContext context = resolver.resolve(gatewayConfigDocument, Gateway.asProperties(configuration.getProperties()));
        return context;
    }

    private void appendKeyStoreTrustStore(GatewayConfigDocument.GatewayConfig gatewayConfig, SecurityConfiguration securityConfiguration) {
        SecurityType security = gatewayConfig.getSecurityArray(0);
        if (securityConfiguration.getTrustStore() != null) {
            SecurityStoreType trustStore = security.addNewTruststore();
            trustStore.setFile(securityConfiguration.getTrustStoreFile());
            if (securityConfiguration.getTrustStore().getType().equalsIgnoreCase("JCECKS")) {
                trustStore.setType(SecurityStoreType.Type.JCEKS);
            } else if (securityConfiguration.getTrustStore().getType().equalsIgnoreCase("JKS")) {
                trustStore.setType(SecurityStoreType.Type.JKS);
            }
            trustStore.setPasswordFile(securityConfiguration.getTrustStorePasswordFile());
        }
        if (securityConfiguration.getKeyStore() != null) {
            SecurityStoreType keyStore = security.addNewKeystore();
            keyStore.setFile(securityConfiguration.getKeyStoreFile());
            if (securityConfiguration.getKeyStore().getType().equalsIgnoreCase("JKS")) {
                keyStore.setType(SecurityStoreType.Type.JKS);
            } else {
                keyStore.setType(SecurityStoreType.Type.JCEKS);
            }
            keyStore.setPasswordFile(securityConfiguration.getKeyStorePasswordFile());
        }
    }

    private void appendRealms(GatewayConfigDocument.GatewayConfig gatewayConfig, List<RealmConfiguration> realms) {
        SecurityType security = gatewayConfig.addNewSecurity();
        for (RealmConfiguration realm : realms) {
            String sessionTimeout;
            RealmType newRealm = security.addNewRealm();
            newRealm.setName(realm.getName());
            if (realm.getDescription() != null) {
                newRealm.setDescription(realm.getDescription());
            }
            AuthenticationType authenticationType = newRealm.addNewAuthentication();
            if (realm.getHttpChallengeScheme() != null) {
                authenticationType.setHttpChallengeScheme(AuthenticationType.HttpChallengeScheme.Enum.forString(realm.getHttpChallengeScheme()));
            }
            for (String httpHeader : realm.getHttpHeaders()) {
                authenticationType.addHttpHeader(httpHeader);
            }
            for (String httpQueryParameter : realm.getHttpQueryParameters()) {
                authenticationType.addHttpQueryParameter(httpQueryParameter);
            }
            for (String httpCookie : realm.getHttpCookies()) {
                authenticationType.addHttpCookie(httpCookie);
            }
            String authenticationMode = realm.getAuthorizationMode();
            if (authenticationMode != null) {
                authenticationType.setAuthorizationMode(AuthenticationType.AuthorizationMode.Enum.forString(authenticationMode));
            }
            if ((sessionTimeout = realm.getSessionTimeout()) != null) {
                authenticationType.setSessionTimeout(sessionTimeout);
            }
            LoginModulesType newLoginModules = null;
            if (!realm.getLoginModules().isEmpty()) {
                newLoginModules = authenticationType.addNewLoginModules();
            }
            for (LoginModuleConfiguration loginModuleConfig : realm.getLoginModules()) {
                LoginModuleType loginModule = newLoginModules.addNewLoginModule();
                loginModule.setType(loginModuleConfig.getType());
                if (loginModuleConfig.getSuccess() != null) {
                    loginModule.setSuccess(SuccessType.Enum.forString(loginModuleConfig.getSuccess()));
                }
                Node domNode = null;
                Document ownerDocument = null;
                LoginModuleOptionsType newOptions = null;
                Map<String, String> options = loginModuleConfig.getOptions();
                if (options.isEmpty()) continue;
                newOptions = loginModule.addNewOptions();
                domNode = loginModule.getDomNode();
                ownerDocument = domNode.getOwnerDocument();
                for (Map.Entry<String, String> option : options.entrySet()) {
                    Element newElement = ownerDocument.createElementNS(domNode.getNamespaceURI(), option.getKey());
                    Text newTextNode = ownerDocument.createTextNode(option.getValue());
                    newElement.appendChild(newTextNode);
                    newOptions.getDomNode().appendChild(newElement);
                }
            }
        }
    }

    private void setServiceDefaults(GatewayConfigDocument.GatewayConfig gatewayConfig, ServiceDefaultsConfiguration serviceDefaultsConfiguration) {
        if (serviceDefaultsConfiguration == null) {
            return;
        }
        try {
            Map<String, String> mimeMappings;
            Map<String, String> configuredConnectOptions;
            ServiceDefaultsType serviceDefaults = gatewayConfig.addNewServiceDefaults();
            Map<String, String> configuredAcceptOptions = serviceDefaultsConfiguration.getAcceptOptions();
            if (!configuredAcceptOptions.isEmpty()) {
                ServiceAcceptOptionsType newAcceptOption = serviceDefaults.addNewAcceptOptions();
                this.appendAcceptOptions(newAcceptOption, configuredAcceptOptions);
            }
            if (!(configuredConnectOptions = serviceDefaultsConfiguration.getConnectOptions()).isEmpty()) {
                ServiceConnectOptionsType newConnectOptions = serviceDefaults.addNewConnectOptions();
                this.appendConnectOptions(newConnectOptions, configuredConnectOptions);
            }
            if (!(mimeMappings = serviceDefaultsConfiguration.getMimeMappings()).isEmpty()) {
                for (Map.Entry<String, String> mimeMappingEntry : mimeMappings.entrySet()) {
                    MimeMappingType mimeMapping = serviceDefaults.addNewMimeMapping();
                    mimeMapping.setExtension(mimeMappingEntry.getKey());
                    mimeMapping.setMimeType(mimeMappingEntry.getValue());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void appendAcceptOptions(ServiceAcceptOptionsType newAcceptOptions, Map<String, String> configuredAcceptOptions) throws Exception {
        Node domNode = newAcceptOptions.getDomNode();
        Document ownerDocument = domNode.getOwnerDocument();
        for (Map.Entry<String, String> acceptOption : configuredAcceptOptions.entrySet()) {
            Element newElement = ownerDocument.createElementNS(domNode.getNamespaceURI(), acceptOption.getKey());
            Text newTextNode = ownerDocument.createTextNode(acceptOption.getValue());
            newElement.appendChild(newTextNode);
            domNode.appendChild(newElement);
        }
    }

    private static Properties asProperties(Map<String, String> propertiesMap) {
        Properties properties = new Properties();
        for (Map.Entry<String, String> entry : propertiesMap.entrySet()) {
            String propertyName = entry.getKey();
            String propertyValue = entry.getValue();
            properties.setProperty(propertyName, propertyValue);
        }
        return properties;
    }

    public void stop() throws Exception {
        switch (this.state) {
            case STARTED: {
                this.state = State.STOPPING;
            }
        }
        switch (this.state) {
            case STOPPING: {
                this.launcher.destroy();
                this.state = State.STOPPED;
            }
        }
    }

    private void appendServices(GatewayConfigDocument.GatewayConfig newGatewayConfig, Collection<ServiceConfiguration> services) throws Exception {
        for (ServiceConfiguration service : services) {
            ServiceType newService = newGatewayConfig.addNewService();
            this.setType(service, newService);
            this.setRealmName(service, newService);
            this.appendBalances(newService, service);
            this.appendAccepts(newService, service);
            this.appendAcceptOptions(newService, service);
            this.appendConnects(newService, service);
            this.appendConnectOptions(newService, service);
            this.appendProperties(newService, service);
            this.appendAuthorizationConstraints(newService, service);
            this.appendCrossOriginConstraints(newService, service);
            this.appendMimeMappings(newService, service);
        }
    }

    private void setRealmName(ServiceConfiguration service, ServiceType newService) {
        String realmName = service.getRealmName();
        if (realmName != null) {
            newService.setRealmName(realmName);
        }
    }

    private void setType(ServiceConfiguration service, ServiceType newService) {
        String type = service.getType();
        if (type != null) {
            newService.setType(type);
        }
    }

    private void appendBalances(ServiceType newService, ServiceConfiguration service) {
        Set<URI> balances = service.getBalances();
        String[] newBalances = new String[balances.size()];
        int i = 0;
        for (URI balance : balances) {
            newBalances[i++] = balance.toASCIIString();
        }
        newService.setBalanceArray(newBalances);
    }

    private void appendAccepts(ServiceType newService, ServiceConfiguration service) {
        Set<URI> accepts = service.getAccepts();
        if (!accepts.isEmpty()) {
            String[] newAccepts = new String[accepts.size()];
            int i = 0;
            for (URI accept : accepts) {
                newAccepts[i++] = accept.toASCIIString();
            }
            newService.setAcceptArray(newAccepts);
        }
    }

    private void appendAcceptOptions(ServiceType newService, ServiceConfiguration service) throws Exception {
        try {
            Map<String, String> acceptOptions = service.getAcceptOptions();
            if (!acceptOptions.isEmpty()) {
                ServiceAcceptOptionsType newAcceptOptions = newService.addNewAcceptOptions();
                Node domNode = newAcceptOptions.getDomNode();
                Document ownerDocument = domNode.getOwnerDocument();
                for (Map.Entry<String, String> acceptOption : acceptOptions.entrySet()) {
                    Element newElement = ownerDocument.createElementNS(domNode.getNamespaceURI(), acceptOption.getKey());
                    Text newTextNode = ownerDocument.createTextNode(acceptOption.getValue());
                    newElement.appendChild(newTextNode);
                    domNode.appendChild(newElement);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void appendConnects(ServiceType newService, ServiceConfiguration service) {
        Set<URI> connects = service.getConnects();
        if (!connects.isEmpty()) {
            String[] newConnects = new String[connects.size()];
            int i = 0;
            for (URI connect : connects) {
                newConnects[i++] = connect.toASCIIString();
            }
            newService.setConnectArray(newConnects);
        }
    }

    public void appendConnectOptions(ServiceType newService, ServiceConfiguration service) throws Exception {
        try {
            Map<String, String> connectOptions = service.getConnectOptions();
            if (!connectOptions.isEmpty()) {
                ServiceConnectOptionsType newConnectOptions = newService.addNewConnectOptions();
                Node domNode = newConnectOptions.getDomNode();
                Document ownerDocument = domNode.getOwnerDocument();
                for (Map.Entry<String, String> connectOption : connectOptions.entrySet()) {
                    Element newElement = ownerDocument.createElementNS(domNode.getNamespaceURI(), connectOption.getKey());
                    Text newTextNode = ownerDocument.createTextNode(connectOption.getValue());
                    newElement.appendChild(newTextNode);
                    domNode.appendChild(newElement);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void appendConnectOptions(ServiceConnectOptionsType newConnectOptions, Map<String, String> connectOptions) throws Exception {
        Node domNode = newConnectOptions.getDomNode();
        Document ownerDocument = domNode.getOwnerDocument();
        for (Map.Entry<String, String> connectOption : connectOptions.entrySet()) {
            Element newElement = ownerDocument.createElementNS(domNode.getNamespaceURI(), connectOption.getKey());
            Text newTextNode = ownerDocument.createTextNode(connectOption.getValue());
            newElement.appendChild(newTextNode);
            domNode.appendChild(newElement);
        }
    }

    private void appendProperties(ServiceType newService, ServiceConfiguration service) {
        ServicePropertiesType newProperties = newService.addNewProperties();
        Node domNode = newProperties.getDomNode();
        Document ownerDocument = domNode.getOwnerDocument();
        this.appendSimpleProperties(service.getProperties(), domNode, ownerDocument);
        for (NestedServicePropertiesConfiguration nestedProperty : service.getNestedProperties()) {
            Element newElement = ownerDocument.createElementNS(domNode.getNamespaceURI(), nestedProperty.getConfigElementName());
            this.appendNestedProperties(nestedProperty, newElement, ownerDocument);
            domNode.appendChild(newElement);
        }
    }

    private void appendSimpleProperties(Map<String, String> properties, Node domNode, Document ownerDocument) {
        for (Map.Entry<String, String> property : properties.entrySet()) {
            Element newElement = ownerDocument.createElementNS(domNode.getNamespaceURI(), property.getKey());
            Text newTextNode = ownerDocument.createTextNode(property.getValue());
            newElement.appendChild(newTextNode);
            domNode.appendChild(newElement);
        }
    }

    private void appendNestedProperties(NestedServicePropertiesConfiguration nestedPropertyConfig, Node domNode, Document ownerDocument) {
        this.appendSimpleProperties(nestedPropertyConfig.getSimpleProperties(), domNode, ownerDocument);
        for (NestedServicePropertiesConfiguration nestedProperty : nestedPropertyConfig.getNestedProperties()) {
            Element newElement = ownerDocument.createElementNS(domNode.getNamespaceURI(), nestedProperty.getConfigElementName());
            this.appendNestedProperties(nestedProperty, newElement, ownerDocument);
        }
    }

    private void appendAuthorizationConstraints(ServiceType newService, ServiceConfiguration service) {
        List<AuthorizationConstraintConfiguration> constraints = service.getAuthorizationConstraints();
        if (!constraints.isEmpty()) {
            for (AuthorizationConstraintConfiguration constraint : constraints) {
                AuthorizationConstraintType newConstraint = newService.addNewAuthorizationConstraint();
                Set<String> requiredRoles = constraint.getRequiredRoles();
                String[] array = new String[requiredRoles.size()];
                int i = 0;
                for (String requiredRole : requiredRoles) {
                    array[i++] = requiredRole;
                }
                newConstraint.setRequireRoleArray(array);
            }
        }
    }

    private void appendCrossOriginConstraints(ServiceType newService, ServiceConfiguration service) {
        List<CrossOriginConstraintConfiguration> constraints = service.getCrossOriginConstraints();
        if (!constraints.isEmpty()) {
            for (CrossOriginConstraintConfiguration constraint : constraints) {
                String allowMethods;
                String allowHeaders;
                CrossSiteConstraintType newConstraint = newService.addNewCrossSiteConstraint();
                String allowOrigin = constraint.getAllowOrigin();
                if (allowOrigin != null) {
                    newConstraint.setAllowOrigin(allowOrigin);
                }
                if ((allowHeaders = constraint.getAllowHeaders()) != null) {
                    newConstraint.setAllowHeaders(allowHeaders);
                }
                if ((allowMethods = constraint.getAllowMethods()) == null) continue;
                newConstraint.setAllowMethods(allowMethods);
            }
        }
    }

    private void appendMimeMappings(ServiceType newService, ServiceConfiguration service) {
        Map<String, String> mimeMappings = service.getMimeMappings();
        if (!mimeMappings.isEmpty()) {
            for (Map.Entry<String, String> entry : mimeMappings.entrySet()) {
                MimeMappingType newMimeMapping = newService.addNewMimeMapping();
                String extension = entry.getKey();
                String mimeType = entry.getValue();
                newMimeMapping.setExtension(extension);
                newMimeMapping.setMimeType(mimeType);
            }
        }
    }

    private void setCluster(GatewayConfigDocument.GatewayConfig gatewayConfig, ClusterConfiguration cluster) {
        String awsSecretKey;
        if (cluster == null) {
            return;
        }
        ClusterType newCluster = gatewayConfig.addNewCluster();
        Set<URI> accepts = cluster.getAccepts();
        Set<URI> connects = cluster.getConnects();
        for (URI accept : accepts) {
            newCluster.addAccept(accept.toASCIIString());
        }
        for (URI connect : connects) {
            newCluster.addConnect(connect.toASCIIString());
        }
        String name = cluster.getName();
        newCluster.setName(name);
        ClusterConnectOptionsType connectOptions = newCluster.getConnectOptions();
        String awsAccessKeyId = cluster.getAwsAccessKeyId();
        if (awsAccessKeyId != null) {
            connectOptions.setAwsAccessKeyId(awsAccessKeyId);
        }
        if ((awsSecretKey = cluster.getAwsSecretKeyId()) != null) {
            connectOptions.setAwsSecretKey(awsSecretKey);
        }
    }

    private static final class SecurityContextResolver
    implements ContextResolver<SecurityType, DefaultSecurityContext> {
        private KeyStore keyStore;
        private char[] keyStorePassword;
        private KeyStore trustStore;
        private String keyStoreFile;
        private char[] trustStorePassword;

        SecurityContextResolver(SecurityConfiguration configuration) {
            if (configuration == null) {
                this.keyStore = null;
                this.keyStorePassword = null;
                this.trustStore = null;
                this.keyStoreFile = null;
            } else {
                if (configuration.getKeyStore() != null) {
                    this.keyStore = configuration.getKeyStore();
                    this.keyStoreFile = configuration.getKeyStoreFile();
                }
                if (configuration.getKeyStorePassword() != null) {
                    this.keyStorePassword = configuration.getKeyStorePassword();
                }
                if (configuration.getTrustStore() != null) {
                    this.trustStore = configuration.getTrustStore();
                }
                if (configuration.getTrustStorePassword() != null) {
                    this.trustStorePassword = configuration.getTrustStorePassword();
                }
            }
        }

        @Override
        public DefaultSecurityContext resolve(SecurityType config) throws Exception {
            String keyStoreFilePath = null;
            String keyStorePasswordFile = null;
            String trustStoreFile = null;
            String trustStoreFilePath = null;
            return new DefaultSecurityContext(this.keyStore, this.keyStoreFile, keyStoreFilePath, this.keyStorePassword, keyStorePasswordFile, this.trustStore, trustStoreFile, trustStoreFilePath, this.trustStorePassword);
        }
    }

    private static enum State {
        STARTING,
        STARTED,
        STOPPING,
        STOPPED;

    }
}

