/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.test.config;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.kaazing.gateway.server.test.config.Configuration;
import org.kaazing.gateway.server.test.config.ConfigurationVisitor;
import org.kaazing.gateway.server.test.config.LoginModuleConfiguration;
import org.kaazing.gateway.server.test.config.Suppressible;
import org.kaazing.gateway.server.test.config.SuppressibleConfiguration;
import org.kaazing.gateway.server.test.config.SuppressibleRealmConfiguration;
import org.kaazing.gateway.server.test.config.Suppressibles;

public class RealmConfiguration
implements Configuration<SuppressibleRealmConfiguration> {
    private SuppressibleRealmConfiguration _configuration;
    private Suppressible<String> _name;
    private Suppressible<String> _description;
    private Suppressible<String> _httpChallengeScheme;
    private Suppressible<String> _authorizationMode;
    private Suppressible<String> _sessionTimeout;
    private final List<Suppressible<String>> httpHeaders = new ArrayList<Suppressible<String>>();
    private final List<Suppressible<String>> httpQueryParameters = new ArrayList<Suppressible<String>>();
    private final List<Suppressible<String>> httpCookies = new ArrayList<Suppressible<String>>();
    private final List<LoginModuleConfiguration> loginModules = new LinkedList<LoginModuleConfiguration>();
    private final List<String> unsuppressibleHttpHeaders = Suppressibles.unsuppressibleList(this.httpHeaders);
    private final List<String> unsuppressibleHttpQueryParameters = Suppressibles.unsuppressibleList(this.httpQueryParameters);
    private final List<String> unsuppressibleHttpCookies = Suppressibles.unsuppressibleList(this.httpCookies);
    private static CharsetEncoder asciiEncoder = Charset.forName("US-ASCII").newEncoder();

    public RealmConfiguration() {
        this._configuration = new SuppressibleRealmConfigurationImpl();
        this._configuration.setSuppression(Suppressibles.getDefaultSuppressions());
    }

    @Override
    public void accept(ConfigurationVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public SuppressibleRealmConfiguration getSuppressibleConfiguration() {
        return this._configuration;
    }

    public Collection<LoginModuleConfiguration> getLoginModules() {
        return this.loginModules;
    }

    public void setLoginModules(List<LoginModuleConfiguration> newLoginModules) {
        this.loginModules.clear();
        this.loginModules.addAll(newLoginModules);
    }

    public String getName() {
        if (this._name == null) {
            return null;
        }
        return this._name.value();
    }

    public void setName(String name) {
        this._name = new Suppressible<String>(name, new SuppressibleConfiguration.Suppression[0]);
    }

    public String getDescription() {
        if (this._description == null) {
            return null;
        }
        return this._description.value();
    }

    public void setDescription(String description) {
        if (description != null && !asciiEncoder.canEncode(description)) {
            throw new RuntimeException("Invalid non US-ASCII character in Realm description. Realm description can only contain US-ASCII values");
        }
        this._description = new Suppressible<String>(description, new SuppressibleConfiguration.Suppression[0]);
    }

    public String getHttpChallengeScheme() {
        if (this._httpChallengeScheme == null) {
            return null;
        }
        return this._httpChallengeScheme.value();
    }

    public void setHttpChallengeScheme(String httpChallengeScheme) {
        this._httpChallengeScheme = new Suppressible<String>(httpChallengeScheme, new SuppressibleConfiguration.Suppression[0]);
    }

    public String getAuthorizationMode() {
        if (this._authorizationMode == null) {
            return null;
        }
        return this._authorizationMode.value();
    }

    public void setAuthorizationMode(String authorizationMode) {
        this._authorizationMode = new Suppressible<String>(authorizationMode, new SuppressibleConfiguration.Suppression[0]);
    }

    public String getSessionTimeout() {
        if (this._sessionTimeout == null) {
            return null;
        }
        return this._sessionTimeout.value();
    }

    public void setSessionTimeout(String sessionTimeout) {
        this._sessionTimeout = new Suppressible<String>(sessionTimeout, new SuppressibleConfiguration.Suppression[0]);
    }

    public List<String> getHttpHeaders() {
        return this.unsuppressibleHttpHeaders;
    }

    public void addHttpHeader(String httpHeader) {
        this.getHttpHeaders().add(httpHeader);
    }

    public List<String> getHttpQueryParameters() {
        return this.unsuppressibleHttpQueryParameters;
    }

    public void addHttpQueryParameter(String httpQueryParameter) {
        this.getHttpQueryParameters().add(httpQueryParameter);
    }

    public List<String> getHttpCookies() {
        return this.unsuppressibleHttpCookies;
    }

    public void addHttpCookie(String httpCookie) {
        this.getHttpCookies().add(httpCookie);
    }

    private class SuppressibleRealmConfigurationImpl
    extends SuppressibleRealmConfiguration {
        private Set<SuppressibleConfiguration.Suppression> _suppressions;

        private SuppressibleRealmConfigurationImpl() {
        }

        @Override
        public Set<SuppressibleConfiguration.Suppression> getSuppressions() {
            return this._suppressions;
        }

        @Override
        public void setSuppression(Set<SuppressibleConfiguration.Suppression> suppressions) {
            this._suppressions = suppressions;
        }

        @Override
        public Suppressible<String> getName() {
            return RealmConfiguration.this._name;
        }

        @Override
        public void setName(Suppressible<String> name) {
            RealmConfiguration.this._name = name;
        }

        @Override
        public Suppressible<String> getDescription() {
            return RealmConfiguration.this._description;
        }

        @Override
        public void setDescription(Suppressible<String> description) {
            RealmConfiguration.this._description = description;
        }

        @Override
        public Suppressible<String> getHttpChallengeScheme() {
            return RealmConfiguration.this._httpChallengeScheme;
        }

        @Override
        public void setHttpChallengeScheme(Suppressible<String> httpChallengeScheme) {
            RealmConfiguration.this._httpChallengeScheme = httpChallengeScheme;
        }

        @Override
        public Suppressible<String> getAuthorizationMode() {
            return RealmConfiguration.this._authorizationMode;
        }

        @Override
        public void setAuthorizationMode(Suppressible<String> authorizationMode) {
            RealmConfiguration.this._authorizationMode = authorizationMode;
        }

        @Override
        public Suppressible<String> getSessionTimeout() {
            return RealmConfiguration.this._sessionTimeout;
        }

        @Override
        public void setSessionTimeout(Suppressible<String> sessionTimeout) {
            RealmConfiguration.this._sessionTimeout = sessionTimeout;
        }

        @Override
        public List<Suppressible<String>> getHttpHeaders() {
            return RealmConfiguration.this.httpHeaders;
        }

        @Override
        public void addHttpHeader(Suppressible<String> httpHeader) {
            RealmConfiguration.this.httpHeaders.add(httpHeader);
        }

        @Override
        public List<Suppressible<String>> getHttpQueryParameters() {
            return RealmConfiguration.this.httpQueryParameters;
        }

        @Override
        public void addHttpQueryParameter(Suppressible<String> httpQueryParameter) {
            RealmConfiguration.this.httpQueryParameters.add(httpQueryParameter);
        }

        @Override
        public List<Suppressible<String>> getHttpCookies() {
            return RealmConfiguration.this.httpCookies;
        }

        @Override
        public void addHttpCookie(Suppressible<String> httpCookie) {
            RealmConfiguration.this.httpCookies.add(httpCookie);
        }
    }
}

