/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.messaging.buffer;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.kaazing.gateway.server.messaging.buffer.MessageBufferListenerSupport;
import org.kaazing.gateway.service.messaging.MessagingMessage;
import org.kaazing.gateway.service.messaging.buffer.MessageBuffer;
import org.kaazing.gateway.service.messaging.buffer.MessageBufferEntry;
import org.kaazing.gateway.service.messaging.buffer.MessageBufferListener;

public class MemoryMessageBuffer
implements MessageBuffer {
    private final MessageBufferListenerSupport listenerSupport = new MessageBufferListenerSupport();
    private final Lock readLock;
    private final Lock writeLock;
    private final MessageBufferEntry[] messages;
    private final int capacity;
    private int nextId;

    public MemoryMessageBuffer(int capacity) {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.capacity = capacity;
        this.messages = new MessageBufferEntry[capacity];
        this.nextId = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageBufferEntry add(MessagingMessage message) {
        this.writeLock.lock();
        try {
            MessageBufferEntry m;
            int id = this.nextId++;
            this.messages[id % this.capacity] = m = new MessageBufferEntry(id, message);
            this.listenerSupport.messageAdded(m);
            MessageBufferEntry messageBufferEntry = m;
            return messageBufferEntry;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageBufferEntry set(int index, MessagingMessage message) {
        this.writeLock.lock();
        try {
            MessageBufferEntry m;
            if (this.nextId <= index) {
                this.nextId = index + 1;
            }
            this.messages[index % this.capacity] = m = new MessageBufferEntry(index, message);
            this.listenerSupport.messageAdded(m);
            MessageBufferEntry messageBufferEntry = m;
            return messageBufferEntry;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageBufferEntry get(int id) {
        if (id < 1) {
            return null;
        }
        this.readLock.lock();
        try {
            MessageBufferEntry message;
            if (id >= this.nextId || id < this.nextId - this.capacity) {
                MessageBufferEntry messageBufferEntry = null;
                return messageBufferEntry;
            }
            MessageBufferEntry messageBufferEntry = message = this.messages[id % this.capacity];
            return messageBufferEntry;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getYoungestId() {
        this.readLock.lock();
        try {
            int n = this.nextId - 1;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOldestId() {
        this.readLock.lock();
        try {
            int id = this.nextId - this.capacity;
            int n = id < 1 ? 1 : id;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void addMessageBufferListener(MessageBufferListener listener) {
        this.listenerSupport.addMessageBufferListener(listener);
    }

    public void removeMessageBufferListener(MessageBufferListener listener) {
        this.listenerSupport.removeMessageBufferListener(listener);
    }
}

