/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.context.resolve;

import com.hazelcast.config.AwsConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.Join;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MulticastConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IdGenerator;
import com.hazelcast.core.Member;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.logging.LogEvent;
import com.hazelcast.logging.LogListener;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.nio.Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.kaazing.gateway.server.messaging.buffer.ClusterMemoryMessageBufferFactory;
import org.kaazing.gateway.server.messaging.collections.ClusterCollectionsFactory;
import org.kaazing.gateway.service.cluster.BalancerMapListener;
import org.kaazing.gateway.service.cluster.ClusterConnectOptionsContext;
import org.kaazing.gateway.service.cluster.ClusterContext;
import org.kaazing.gateway.service.cluster.ClusterMessaging;
import org.kaazing.gateway.service.cluster.InstanceKeyListener;
import org.kaazing.gateway.service.cluster.MemberId;
import org.kaazing.gateway.service.cluster.MembershipEventListener;
import org.kaazing.gateway.service.cluster.ReceiveListener;
import org.kaazing.gateway.service.cluster.SendListener;
import org.kaazing.gateway.service.messaging.buffer.MessageBufferFactory;
import org.kaazing.gateway.service.messaging.collections.CollectionsFactory;
import org.kaazing.gateway.util.GL;
import org.kaazing.gateway.util.Utils;
import org.kaazing.gateway.util.aws.AwsUtils;
import org.kaazing.gateway.util.scheduler.SchedulerProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClusterContext
implements ClusterContext,
LogListener {
    private static final String CLUSTER_LOG_FORMAT = "HAZELCAST: [%s] - %s";
    private static final String INSTANCE_KEY_MAP = "instanceKeyMap";
    static final String CLUSTER_LOGGER_NAME = "ha";
    private final Logger logger = LoggerFactory.getLogger((String)"ha");
    private final String localInstanceKey = Utils.randomHexString((int)16);
    private MessageBufferFactory messageBufferFactory;
    private CollectionsFactory collectionsFactory;
    private List<MemberId> localInterfaces = new ArrayList<MemberId>();
    private final List<MemberId> clusterMembers = new ArrayList<MemberId>();
    private final List<MembershipEventListener> membershipEventListeners = new ArrayList<MembershipEventListener>();
    private final List<InstanceKeyListener> instanceKeyListeners = new ArrayList<InstanceKeyListener>();
    private final List<BalancerMapListener> balancerMapListeners = new ArrayList<BalancerMapListener>();
    private ClusterMessaging clusterMessaging;
    private MemberId localNodeId;
    private final String clusterName;
    private HazelcastInstance clusterInstance;
    private final SchedulerProvider schedulerProvider;
    private final ClusterConnectOptionsContext connectOptions;
    private final AtomicBoolean clusterInitialized = new AtomicBoolean(false);
    private MembershipListener membershipListener = new MembershipListener(){

        public void memberAdded(MembershipEvent membershipEvent) {
            MemberId newMemberId = DefaultClusterContext.this.getMemberId(membershipEvent.getMember());
            GL.info((String)DefaultClusterContext.CLUSTER_LOGGER_NAME, (String)"Cluster member {} is now online", (Object[])new Object[]{newMemberId.getId()});
            DefaultClusterContext.this.fireMemberAdded(newMemberId);
            DefaultClusterContext.this.logClusterMembers();
        }

        public void memberRemoved(MembershipEvent membershipEvent) {
            MemberId removedMember = DefaultClusterContext.this.getMemberId(membershipEvent.getMember());
            GL.info((String)DefaultClusterContext.CLUSTER_LOGGER_NAME, (String)"Cluster member {} has gone down", (Object[])new Object[]{removedMember});
            IMap instanceKeyMap = DefaultClusterContext.this.getCollectionsFactory().getMap(DefaultClusterContext.INSTANCE_KEY_MAP);
            instanceKeyMap.remove(removedMember);
            IMap memberIdBalancerUriMap = DefaultClusterContext.this.getCollectionsFactory().getMap("memberIdBalancerMap");
            if (memberIdBalancerUriMap == null) {
                throw new IllegalStateException("MemberId to BalancerMap is null");
            }
            IMap sharedBalanceUriMap = DefaultClusterContext.this.getCollectionsFactory().getMap("balancerMap");
            if (sharedBalanceUriMap == null) {
                throw new IllegalStateException("Shared balanced URIs map is null");
            }
            Map memberBalancedUrisMap = (Map)memberIdBalancerUriMap.remove(removedMember);
            if (memberBalancedUrisMap != null) {
                GL.debug((String)DefaultClusterContext.CLUSTER_LOGGER_NAME, (String)"Cleaning up balancer cluster state for member {}", (Object[])new Object[]{removedMember});
                try {
                    for (URI key : memberBalancedUrisMap.keySet()) {
                        GL.debug((String)DefaultClusterContext.CLUSTER_LOGGER_NAME, (String)"URI Key: {}", (Object[])new Object[]{key});
                        List memberBalancedUris = (List)memberBalancedUrisMap.get(key);
                        Set globalBalancedUris = null;
                        HashSet newGlobalBalancedUris = null;
                        do {
                            globalBalancedUris = (Set)sharedBalanceUriMap.get((Object)key);
                            newGlobalBalancedUris = new HashSet(globalBalancedUris);
                            for (URI memberBalancedUri : memberBalancedUris) {
                                GL.debug((String)DefaultClusterContext.CLUSTER_LOGGER_NAME, (String)"Attempting to removing Balanced URI : {}", (Object[])new Object[]{memberBalancedUri});
                                newGlobalBalancedUris.remove(memberBalancedUri);
                            }
                        } while (!sharedBalanceUriMap.replace((Object)key, (Object)globalBalancedUris, newGlobalBalancedUris));
                        GL.debug((String)DefaultClusterContext.CLUSTER_LOGGER_NAME, (String)"Removed balanced URIs for cluster member {}, new global list: {}", (Object[])new Object[]{removedMember, newGlobalBalancedUris});
                    }
                }
                catch (Exception e) {
                    throw new IllegalStateException("Unable to remove the balanced URIs served by the member going down from global map");
                }
            }
            DefaultClusterContext.this.fireMemberRemoved(removedMember);
            DefaultClusterContext.this.logClusterMembers();
        }
    };
    private EntryListener<MemberId, String> instanceKeyEntryListener = new EntryListener<MemberId, String>(){

        public void entryAdded(EntryEvent<MemberId, String> newEntryEvent) {
            DefaultClusterContext.this.fireInstanceKeyAdded((String)newEntryEvent.getValue());
        }

        public void entryEvicted(EntryEvent<MemberId, String> evictedEntryEvent) {
            throw new RuntimeException("Instance keys should not be evicted, only added or removed.");
        }

        public void entryRemoved(EntryEvent<MemberId, String> removedEntryEvent) {
            DefaultClusterContext.this.fireInstanceKeyRemoved((String)removedEntryEvent.getValue());
        }

        public void entryUpdated(EntryEvent<MemberId, String> updatedEntryEvent) {
            throw new RuntimeException("Instance keys can not be updated, only added or removed.");
        }
    };
    private EntryListener<URI, Collection<URI>> balancerMapEntryListener = new EntryListener<URI, Collection<URI>>(){

        public void entryAdded(EntryEvent<URI, Collection<URI>> newEntryEvent) {
            GL.trace((String)DefaultClusterContext.CLUSTER_LOGGER_NAME, (String)"New entry for balance URI: {}   value: {}", (Object[])new Object[]{newEntryEvent.getKey(), newEntryEvent.getValue()});
            DefaultClusterContext.this.fireBalancerEntryAdded((EntryEvent<URI, Collection<URI>>)newEntryEvent);
        }

        public void entryEvicted(EntryEvent<URI, Collection<URI>> evictedEntryEvent) {
            throw new RuntimeException("Balancer map entries should not be evicted, only added or removed.");
        }

        public void entryRemoved(EntryEvent<URI, Collection<URI>> removedEntryEvent) {
            GL.trace((String)DefaultClusterContext.CLUSTER_LOGGER_NAME, (String)"Entry removed for balance URI: {}   value: {}", (Object[])new Object[]{removedEntryEvent.getKey(), removedEntryEvent.getValue()});
            DefaultClusterContext.this.fireBalancerEntryRemoved((EntryEvent<URI, Collection<URI>>)removedEntryEvent);
        }

        public void entryUpdated(EntryEvent<URI, Collection<URI>> updatedEntryEvent) {
            GL.trace((String)DefaultClusterContext.CLUSTER_LOGGER_NAME, (String)"Entry updated for balance URI: {}   value: {}", (Object[])new Object[]{updatedEntryEvent.getKey(), updatedEntryEvent.getValue()});
            DefaultClusterContext.this.fireBalancerEntryUpdated((EntryEvent<URI, Collection<URI>>)updatedEntryEvent);
        }
    };

    public DefaultClusterContext(String name, List<MemberId> interfaces, List<MemberId> members, SchedulerProvider schedulerProvider) {
        this(name, interfaces, members, schedulerProvider, null);
    }

    public DefaultClusterContext(String name, List<MemberId> interfaces, List<MemberId> members, SchedulerProvider schedulerProvider, ClusterConnectOptionsContext connectOptions) {
        this.clusterName = name;
        this.localInterfaces.addAll(interfaces);
        this.clusterMembers.addAll(members);
        this.schedulerProvider = schedulerProvider;
        this.connectOptions = connectOptions;
    }

    public void start() {
        if (this.localInterfaces.size() + this.clusterMembers.size() == 0) {
            if (this.localInterfaces.size() == 0) {
                GL.info((String)CLUSTER_LOGGER_NAME, (String)"No network interfaces specified in the gateway configuration", (Object[])new Object[0]);
                throw new IllegalArgumentException("No network interfaces specified in the gateway configuration");
            }
            if (this.clusterMembers.size() == 0) {
                GL.info((String)CLUSTER_LOGGER_NAME, (String)"No cluster members specified in the gateway configuration", (Object[])new Object[0]);
                throw new IllegalArgumentException("No cluster members specified in the gateway configuration");
            }
        }
        try {
            Config config = this.initializeHazelcastConfig();
            this.initializeCluster(config);
            GL.info((String)CLUSTER_LOGGER_NAME, (String)"Cluster Member started: IP Address: {}; Port: {}; id: {}", (Object[])new Object[]{this.localNodeId.getHost(), this.localNodeId.getPort(), this.localNodeId.getId()});
        }
        catch (Exception e) {
            GL.error((String)CLUSTER_LOGGER_NAME, (String)"Unable to initialize cluster due to an exception: {}", (Object[])new Object[]{e});
            throw new RuntimeException(String.format("Unable to initialize cluster due to an exception: %s", e), e);
        }
    }

    public void dispose() {
        if (this.clusterMessaging != null) {
            this.clusterMessaging.destroy();
        }
        if (this.clusterInstance != null) {
            this.clusterInstance.getLifecycleService().shutdown();
        }
    }

    private Config initializeHazelcastConfig() throws Exception {
        Config hazelCastConfig = new Config();
        hazelCastConfig.getGroupConfig().setName(this.getClusterName());
        hazelCastConfig.getGroupConfig().setPassword("5942");
        MapConfig mapConfig = hazelCastConfig.getMapConfig("serverSessions");
        mapConfig.setBackupCount(3);
        MapConfig sharedBalancerMapConfig = hazelCastConfig.getMapConfig("balancerMap");
        sharedBalancerMapConfig.setBackupCount(Integer.MAX_VALUE);
        MapConfig memberBalancerMapConfig = hazelCastConfig.getMapConfig("memberIdBalancerMap");
        memberBalancerMapConfig.setBackupCount(Integer.MAX_VALUE);
        hazelCastConfig.setPortAutoIncrement(false);
        int clusterPort = this.localInterfaces.size() > 0 ? this.localInterfaces.get(0).getPort() : -1;
        java.util.logging.Logger logger = java.util.logging.Logger.getLogger("com.hazelcast");
        logger.setLevel(Level.OFF);
        if (clusterPort != -1) {
            hazelCastConfig.setPort(clusterPort);
        }
        NetworkConfig networkConfig = new NetworkConfig();
        for (MemberId localInterface : this.localInterfaces) {
            String protocol = localInterface.getProtocol();
            if ("udp".equalsIgnoreCase(protocol) || "aws".equalsIgnoreCase(protocol)) {
                throw new IllegalArgumentException("Cannot accept on a multicast or aws address, use unicast address starting with tcp://");
            }
            String hostAddress = localInterface.getHost();
            InetAddress address = InetAddress.getByName(hostAddress);
            if (address instanceof Inet6Address) {
                throw new IllegalArgumentException("ERROR: Cluster member accept url - '" + localInterface.toString() + "' consists of IPv6 address which is not supported. Use Ipv4 address instead.");
            }
            networkConfig.getInterfaces().addInterface(localInterface.getHost());
            if (localInterface.getPort() == clusterPort) continue;
            throw new IllegalArgumentException("Port numbers on the network interfaces in <accept> do not match");
        }
        boolean usingMulticast = false;
        Join joinConfig = networkConfig.getJoin();
        MulticastConfig multicastConfig = joinConfig.getMulticastConfig();
        multicastConfig.setEnabled(false);
        TcpIpConfig tcpIpConfig = joinConfig.getTcpIpConfig();
        ArrayList<InetSocketAddress> multicastAddresses = new ArrayList<InetSocketAddress>();
        ArrayList<InetSocketAddress> unicastAddresses = new ArrayList<InetSocketAddress>();
        MemberId awsMember = null;
        for (MemberId member : this.clusterMembers) {
            if (member.getProtocol().equals("udp")) {
                multicastAddresses.add(new InetSocketAddress(member.getHost(), member.getPort()));
                continue;
            }
            if (member.getProtocol().equals("tcp")) {
                unicastAddresses.add(new InetSocketAddress(member.getHost(), member.getPort()));
                continue;
            }
            if (!member.getProtocol().equals("aws")) continue;
            awsMember = member;
        }
        if (awsMember == null) {
            int multicastAddressesCount = multicastAddresses.size();
            if (multicastAddressesCount > 1) {
                throw new IllegalArgumentException("Conflicting multicast discovery addresses in cluster configuration");
            }
            if (multicastAddressesCount > 0) {
                if (AwsUtils.isDeployedToAWS()) {
                    throw new IllegalArgumentException("Multicast cluster configuration not supported on AWS, use aws://security-group/<security-group-name> in connect tag");
                }
                multicastConfig.setEnabled(true);
                InetSocketAddress multicastAddress = (InetSocketAddress)multicastAddresses.get(0);
                multicastConfig.setMulticastGroup(multicastAddress.getHostName());
                multicastConfig.setMulticastPort(multicastAddress.getPort());
            }
            if (unicastAddresses.size() > 0) {
                tcpIpConfig.setEnabled(!usingMulticast);
                for (InetSocketAddress unicastAddress : unicastAddresses) {
                    tcpIpConfig.addAddress(new Address(unicastAddress));
                }
            }
            boolean useAnyAddress = false;
            for (String networkInterface : networkConfig.getInterfaces().getInterfaces()) {
                InetAddress address = InetAddress.getByName(networkInterface);
                if (!address.isAnyLocalAddress()) continue;
                useAnyAddress = true;
                break;
            }
            if (!useAnyAddress) {
                networkConfig.getInterfaces().setEnabled(true);
                hazelCastConfig.setProperty("hazelcast.socket.bind.any", "false");
            }
        } else {
            String path = awsMember.getPath();
            String groupName = null;
            if (path != null && path.indexOf("/") == 0 && path.length() > 1) {
                groupName = path.substring(1, path.length());
            }
            if (groupName == null || groupName.length() == 0) {
                groupName = AwsUtils.getSecurityGroupName();
            }
            multicastConfig.setEnabled(false);
            tcpIpConfig.setEnabled(false);
            AwsConfig awsConfig = joinConfig.getAwsConfig();
            awsConfig.setEnabled(true);
            awsConfig.setAccessKey(this.connectOptions.getAwsAccessKeyId());
            awsConfig.setSecretKey(this.connectOptions.getAwsSecretKey());
            awsConfig.setRegion(AwsUtils.getRegion());
            awsConfig.setSecurityGroupName(groupName);
            String localIPv4 = AwsUtils.getLocalIPv4();
            networkConfig.getInterfaces().setEnabled(true);
            networkConfig.getInterfaces().clear();
            networkConfig.getInterfaces().addInterface(localIPv4);
            hazelCastConfig.setProperty("hazelcast.socket.bind.any", "false");
        }
        hazelCastConfig.setNetworkConfig(networkConfig);
        hazelCastConfig.setProperty("hazelcast.shutdownhook.enabled", "false");
        return hazelCastConfig;
    }

    private List<String> processInterfaceOrMemberEntry(String entry) {
        if (entry == null) {
            return null;
        }
        ArrayList<String> addresses = new ArrayList<String>();
        int starIndex = entry.indexOf(42);
        int dashIndex = entry.indexOf(45);
        if (starIndex == -1 && dashIndex == -1) {
            addresses.add(entry);
            return addresses;
        }
        String[] parts = entry.split("\\.");
        if (parts.length != 4) {
            throw new IllegalArgumentException("Invalid wildcard in the entry for cluster configuration: " + entry);
        }
        if (parts[0].indexOf("*") != -1 && parts[0].indexOf("-") != -1) {
            throw new IllegalArgumentException("Invalid wildcard in the entry for cluster configuration, first part of the address cannot contain a wildcard: " + entry);
        }
        String part1 = parts[0];
        String[] part2s = this.processEntryPart(entry, parts[1]);
        String[] part3s = this.processEntryPart(entry, parts[2]);
        String[] part4s = this.processEntryPart(entry, parts[3]);
        for (int i = 0; i < part2s.length; ++i) {
            for (int j = 0; j < part3s.length; ++j) {
                for (int k = 0; k < part4s.length; ++k) {
                    addresses.add(part1 + "." + part2s[i] + "." + part3s[j] + "." + part4s[k]);
                }
            }
        }
        return addresses;
    }

    private String[] processEntryPart(String entry, String ipPart) {
        if (ipPart.indexOf("*") == -1 && ipPart.indexOf("-") == -1) {
            String[] resolvedParts = new String[]{ipPart};
            return resolvedParts;
        }
        if (ipPart.equals("*")) {
            String[] resolvedParts = new String[256];
            for (int i = 0; i < 256; ++i) {
                resolvedParts[i] = String.valueOf(i);
            }
            return resolvedParts;
        }
        if (ipPart.indexOf("-") != -1) {
            String[] rangeParts = ipPart.split("-");
            if (rangeParts.length != 2) {
                throw new IllegalArgumentException("Invalid wildcard in the entry for cluster configuration: " + entry);
            }
            int start = Integer.parseInt(rangeParts[0]);
            int end = Integer.parseInt(rangeParts[1]);
            String[] resolvedParts = new String[end - start + 1];
            for (int i = start; i <= end; ++i) {
                resolvedParts[i] = String.valueOf(i);
            }
            return resolvedParts;
        }
        throw new IllegalArgumentException("Invalid wildcard in the entry for cluster configuration: " + entry);
    }

    public MemberId getLocalMember() {
        return this.localNodeId;
    }

    public Collection<MemberId> getMemberIds() {
        IMap instanceKeyMap = this.getCollectionsFactory().getMap(INSTANCE_KEY_MAP);
        return instanceKeyMap.keySet();
    }

    private MemberId getMemberId(Member member) {
        InetSocketAddress inetSocketAddress = member.getInetSocketAddress();
        String hostname = inetSocketAddress.getHostName();
        if (!inetSocketAddress.isUnresolved()) {
            String ipAddr;
            hostname = ipAddr = inetSocketAddress.getAddress().getHostAddress();
            GL.debug((String)CLUSTER_LOGGER_NAME, (String)"getMemberId: Hostname: {}; IP Address: {}", (Object[])new Object[]{hostname, ipAddr});
        }
        return new MemberId("tcp", hostname, inetSocketAddress.getPort());
    }

    public String getInstanceKey(MemberId memberId) {
        if (memberId == this.localNodeId) {
            return this.localInstanceKey;
        }
        IMap instanceKeyMap = this.getCollectionsFactory().getMap(INSTANCE_KEY_MAP);
        return (String)instanceKeyMap.get(memberId);
    }

    public Lock getLock(Object obj) {
        return this.clusterInstance.getLock(obj);
    }

    public IdGenerator getIdGenerator(String name) {
        return this.clusterInstance.getIdGenerator(name);
    }

    public void addReceiveQueue(String name) {
        if (this.clusterMessaging != null) {
            this.clusterMessaging.addReceiveQueue(name);
        }
    }

    public void addReceiveTopic(String name) {
        if (this.clusterMessaging != null) {
            this.clusterMessaging.addReceiveTopic(name);
        }
    }

    public void send(Object msg, SendListener listener, MemberId member) {
        if (this.clusterMessaging != null) {
            this.clusterMessaging.send(msg, listener, member);
        }
    }

    public void send(Object msg, SendListener listener, String name) {
        if (this.clusterMessaging != null) {
            this.clusterMessaging.send(msg, listener, name);
        }
    }

    public Object send(Object msg, MemberId member) throws Exception {
        if (this.clusterMessaging != null) {
            return this.clusterMessaging.send(msg, member);
        }
        return null;
    }

    public Object send(Object msg, String name) throws Exception {
        if (this.clusterMessaging != null) {
            return this.clusterMessaging.send(msg, name);
        }
        return null;
    }

    public <T> void setReceiver(Class<T> type, ReceiveListener<T> receiveListener) {
        if (this.clusterMessaging != null) {
            this.clusterMessaging.setReceiver(type, receiveListener);
        }
    }

    public <T> void removeReceiver(Class<T> type) {
        if (this.clusterMessaging != null) {
            this.clusterMessaging.removeReceiver(type);
        }
    }

    public void addMembershipEventListener(MembershipEventListener eventListener) {
        if (eventListener != null) {
            this.membershipEventListeners.add(eventListener);
        }
    }

    public void removeMembershipEventListener(MembershipEventListener eventListener) {
        if (eventListener != null) {
            this.membershipEventListeners.remove(eventListener);
        }
    }

    public void addInstanceKeyListener(InstanceKeyListener instanceKeyListener) {
        if (instanceKeyListener != null) {
            this.instanceKeyListeners.add(instanceKeyListener);
        }
    }

    public void removeInstanceKeyListener(InstanceKeyListener instanceKeyListener) {
        if (instanceKeyListener != null) {
            this.instanceKeyListeners.remove(instanceKeyListener);
        }
    }

    public void addBalancerMapListener(BalancerMapListener balancerMapListener) {
        if (balancerMapListener != null) {
            this.balancerMapListeners.add(balancerMapListener);
        }
    }

    public void removeBalancerMapListener(BalancerMapListener balancerMapListener) {
        if (balancerMapListener != null) {
            this.balancerMapListeners.remove(balancerMapListener);
        }
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public List<MemberId> getAccepts() {
        return this.localInterfaces;
    }

    public List<MemberId> getConnects() {
        return this.clusterMembers;
    }

    public ClusterConnectOptionsContext getConnectOptions() {
        return this.connectOptions;
    }

    public MessageBufferFactory getMessageBufferFactory() {
        return this.messageBufferFactory;
    }

    public void logClusterState() {
        this.logClusterMembers();
        this.logBalancerMap();
    }

    private void logClusterMembers() {
        Cluster cluster;
        if (this.clusterInstance != null && (cluster = this.clusterInstance.getCluster()) != null) {
            GL.trace((String)CLUSTER_LOGGER_NAME, (String)"Current cluster members:", (Object[])new Object[0]);
            Set currentMembers = this.clusterInstance.getCluster().getMembers();
            for (Member currentMember : currentMembers) {
                MemberId memberId = this.getMemberId(currentMember);
                GL.trace((String)CLUSTER_LOGGER_NAME, (String)"      member: {}", (Object[])new Object[]{memberId});
            }
        }
    }

    private void logBalancerMap() {
        GL.trace((String)CLUSTER_LOGGER_NAME, (String)"Current balancer map:", (Object[])new Object[0]);
        IMap balancerMap = this.getCollectionsFactory().getMap("balancerMap");
        for (URI balanceURI : balancerMap.keySet()) {
            Set balanceTargets = (Set)balancerMap.get(balanceURI);
            GL.trace((String)CLUSTER_LOGGER_NAME, (String)"     balance URI: {}    target list: {}", (Object[])new Object[]{balanceURI, balanceTargets});
        }
    }

    private void fireMemberAdded(MemberId newMember) {
        GL.debug((String)CLUSTER_LOGGER_NAME, (String)"Firing member added for : {}", (Object[])new Object[]{newMember});
        for (MembershipEventListener listener : this.membershipEventListeners) {
            try {
                listener.memberAdded(newMember);
            }
            catch (Throwable e) {
                GL.error((String)CLUSTER_LOGGER_NAME, (String)"Error in member added event {}", (Object[])new Object[]{e});
            }
        }
    }

    private void fireMemberRemoved(MemberId exMember) {
        GL.debug((String)CLUSTER_LOGGER_NAME, (String)"Firing member removed for: {}", (Object[])new Object[]{exMember});
        for (MembershipEventListener listener : this.membershipEventListeners) {
            try {
                listener.memberRemoved(exMember);
            }
            catch (Throwable e) {
                GL.error((String)CLUSTER_LOGGER_NAME, (String)"Error in member removed event {}", (Object[])new Object[]{e});
            }
        }
    }

    private void fireInstanceKeyAdded(String instanceKey) {
        GL.debug((String)CLUSTER_LOGGER_NAME, (String)"Firing instanceKeyAdded for: {}", (Object[])new Object[]{instanceKey});
        for (InstanceKeyListener listener : this.instanceKeyListeners) {
            try {
                listener.instanceKeyAdded(instanceKey);
            }
            catch (Throwable e) {
                GL.error((String)CLUSTER_LOGGER_NAME, (String)"Error in instanceKeyAdded event {}", (Object[])new Object[]{e});
            }
        }
    }

    private void fireInstanceKeyRemoved(String instanceKey) {
        GL.debug((String)CLUSTER_LOGGER_NAME, (String)"Firing instanceKeyRemoved for: {}", (Object[])new Object[]{instanceKey});
        for (InstanceKeyListener listener : this.instanceKeyListeners) {
            try {
                listener.instanceKeyRemoved(instanceKey);
            }
            catch (Throwable e) {
                GL.error((String)CLUSTER_LOGGER_NAME, (String)"Error in instanceKeyRemoved event {}", (Object[])new Object[]{e});
            }
        }
    }

    private void fireBalancerEntryAdded(EntryEvent<URI, Collection<URI>> entryEvent) {
        URI balancerURI = (URI)entryEvent.getKey();
        GL.debug((String)CLUSTER_LOGGER_NAME, (String)"Firing balancerEntryAdded for: {}", (Object[])new Object[]{balancerURI});
        for (BalancerMapListener listener : this.balancerMapListeners) {
            try {
                listener.balancerEntryAdded(balancerURI, (Collection)entryEvent.getValue());
            }
            catch (Throwable e) {
                GL.error((String)CLUSTER_LOGGER_NAME, (String)"Error in balancerEntryAdded event {}", (Object[])new Object[]{e});
            }
        }
    }

    private void fireBalancerEntryRemoved(EntryEvent<URI, Collection<URI>> entryEvent) {
        URI balancerURI = (URI)entryEvent.getKey();
        GL.debug((String)CLUSTER_LOGGER_NAME, (String)"Firing balancerEntryRemoved for: {}", (Object[])new Object[]{balancerURI});
        for (BalancerMapListener listener : this.balancerMapListeners) {
            try {
                listener.balancerEntryRemoved(balancerURI, (Collection)entryEvent.getValue());
            }
            catch (Throwable e) {
                GL.error((String)CLUSTER_LOGGER_NAME, (String)"Error in balancerEntryRemoved event {}", (Object[])new Object[]{e});
            }
        }
    }

    private void fireBalancerEntryUpdated(EntryEvent<URI, Collection<URI>> entryEvent) {
        URI balancerURI = (URI)entryEvent.getKey();
        GL.debug((String)CLUSTER_LOGGER_NAME, (String)"Firing balancerEntryUpdated for: {}", (Object[])new Object[]{balancerURI});
        for (BalancerMapListener listener : this.balancerMapListeners) {
            try {
                listener.balancerEntryUpdated(balancerURI, (Collection)entryEvent.getValue());
            }
            catch (Throwable e) {
                GL.error((String)CLUSTER_LOGGER_NAME, (String)"Error in balancerEntryUpdated event {}", (Object[])new Object[]{e});
            }
        }
    }

    public CollectionsFactory getCollectionsFactory() {
        this.initializeCluster(null);
        return this.collectionsFactory;
    }

    private void initializeCluster(Config config) {
        if (this.clusterInitialized.compareAndSet(false, true)) {
            this.clusterInstance = Hazelcast.newHazelcastInstance((Config)config);
            if (this.clusterInstance == null) {
                throw new RuntimeException("Unable to initialize the cluster");
            }
            Cluster cluster = this.clusterInstance.getCluster();
            cluster.addMembershipListener(this.membershipListener);
            LoggingService loggingService = this.clusterInstance.getLoggingService();
            loggingService.addLogListener(Level.FINEST, (LogListener)this);
            this.collectionsFactory = new ClusterCollectionsFactory(this.clusterInstance);
            this.messageBufferFactory = new ClusterMemoryMessageBufferFactory(this.clusterInstance);
            this.localNodeId = this.getMemberId(cluster.getLocalMember());
            this.clusterMessaging = new ClusterMessaging((ClusterContext)this, this.clusterInstance, this.schedulerProvider);
            IMap instanceKeyMap = this.collectionsFactory.getMap(INSTANCE_KEY_MAP);
            instanceKeyMap.put((Object)this.localNodeId, (Object)this.localInstanceKey);
            instanceKeyMap.addEntryListener(this.instanceKeyEntryListener, true);
            IMap balancerMap = this.collectionsFactory.getMap("balancerMap");
            balancerMap.addEntryListener(this.balancerMapEntryListener, true);
        }
    }

    public void log(LogEvent logEvent) {
        Member member = logEvent.getMember();
        LogRecord record = logEvent.getLogRecord();
        Level level = record.getLevel();
        if (level.equals(Level.SEVERE)) {
            this.logger.error(String.format(CLUSTER_LOG_FORMAT, member, record.getMessage()));
        } else if (level.equals(Level.WARNING)) {
            this.logger.warn(String.format(CLUSTER_LOG_FORMAT, member, record.getMessage()));
        } else if (level.equals(Level.INFO)) {
            this.logger.info(String.format(CLUSTER_LOG_FORMAT, member, record.getMessage()));
        } else if (level.equals(Level.FINE)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format(CLUSTER_LOG_FORMAT, member, record.getMessage()));
            }
        } else if ((level.equals(Level.FINER) || level.equals(Level.FINEST)) && this.logger.isTraceEnabled()) {
            this.logger.trace(String.format(CLUSTER_LOG_FORMAT, member, record.getMessage()));
        }
    }
}

