/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.context.resolve;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.kaazing.gateway.server.config.sep2014.ServiceAcceptOptionsType;
import org.kaazing.gateway.service.AcceptOptionsContext;
import org.kaazing.gateway.util.Utils;
import org.kaazing.gateway.util.ssl.SslCipherSuites;

public class DefaultAcceptOptionsContext
implements AcceptOptionsContext {
    private static int DEFAULT_WEBSOCKET_MAXIMUM_MESSAGE_SIZE = 131072;
    private static int DEFAULT_HTTP_KEEPALIVE_TIMEOUT = 30;
    private static final long UNLIMITED_MAX_OUTPUT_RATE = 0xFFFFFFFFL;
    private static long DEFAULT_TCP_MAXIMUM_OUTBOUND_RATE = 0xFFFFFFFFL;
    public static final String EXTENDED_HANDSHAKE_PROTOCOL_NAME = "x-kaazing-handshake";
    private static final String PING_PONG = "x-kaazing-ping-pong";
    private static final String IDLE_TIMEOUT = "x-kaazing-idle-timeout";
    private static final long DEFAULT_WS_INACTIVITY_TIMEOUT_MILLIS = 0L;
    private static List<String> DEFAULT_WEBSOCKET_PROTOCOLS = Arrays.asList("x-kaazing-handshake", null);
    private static List<String> DEFAULT_WEBSOCKET_EXTENSIONS = Arrays.asList("x-kaazing-ping-pong", null);
    private final boolean sslEncryptionEnabled;
    private final String[] sslCiphers;
    private final String[] sslProtocols;
    private final boolean sslWantClientAuth;
    private final boolean sslNeedClientAuth;
    private final URI tcpTransportURI;
    private final URI sslTransportURI;
    private final URI httpTransportURI;
    private final int wsMaxMessageSize;
    private final long wsInactivityTimeout;
    private final int httpKeepaliveTimeout;
    private final Map<String, String> binds = new HashMap<String, String>();
    private final List<String> wsProtocols;
    private final List<String> wsExtensions;
    private final long tcpMaximumOutboundRate;
    private final String udpInterface;
    private final URI pipeTransportURI;

    public DefaultAcceptOptionsContext() {
        this(ServiceAcceptOptionsType.Factory.newInstance(), ServiceAcceptOptionsType.Factory.newInstance());
    }

    public DefaultAcceptOptionsContext(ServiceAcceptOptionsType acceptOptions, ServiceAcceptOptionsType defaultOptions) {
        String tcpMax;
        long val;
        String value;
        String wsMax;
        long val2;
        String value2;
        ServiceAcceptOptionsType.SslVerifyClient.Enum verifyClient;
        ServiceAcceptOptionsType.SslEncryption.Enum encrypted;
        Boolean sslEncryptionEnabled = null;
        if (acceptOptions != null && (encrypted = acceptOptions.getSslEncryption()) != null) {
            sslEncryptionEnabled = encrypted != ServiceAcceptOptionsType.SslEncryption.DISABLED;
        }
        boolean wantClientAuth = false;
        boolean needClientAuth = false;
        if (acceptOptions != null && (verifyClient = acceptOptions.getSslVerifyClient()) != null) {
            if (verifyClient == ServiceAcceptOptionsType.SslVerifyClient.REQUIRED) {
                wantClientAuth = false;
                needClientAuth = true;
            } else if (verifyClient == ServiceAcceptOptionsType.SslVerifyClient.OPTIONAL) {
                wantClientAuth = true;
                needClientAuth = false;
            } else {
                wantClientAuth = false;
                needClientAuth = false;
            }
        }
        String udpInterface = null;
        if (acceptOptions != null) {
            udpInterface = acceptOptions.getUdpInterface();
        }
        String sslCiphers = null;
        if (acceptOptions != null) {
            sslCiphers = acceptOptions.getSslCiphers();
        }
        String sslProtocols = null;
        if (acceptOptions != null) {
            sslProtocols = acceptOptions.getSslProtocols();
        }
        String pipeTransport = null;
        if (acceptOptions != null) {
            pipeTransport = acceptOptions.getPipeTransport();
        }
        String tcpTransport = null;
        if (acceptOptions != null) {
            tcpTransport = acceptOptions.getTcpTransport();
        }
        String sslTransport = null;
        if (acceptOptions != null) {
            sslTransport = acceptOptions.getSslTransport();
        }
        String httpTransport = null;
        if (acceptOptions != null) {
            httpTransport = acceptOptions.getHttpTransport();
        }
        Long httpKeepaliveTimeout = null;
        if (acceptOptions != null && (value2 = acceptOptions.getHttpKeepaliveTimeout()) != null && (val2 = Utils.parseTimeInterval((String)value2, (TimeUnit)TimeUnit.SECONDS)) > 0L) {
            httpKeepaliveTimeout = val2;
        }
        Integer wsMaxMessageSize = null;
        if (acceptOptions != null && (wsMax = acceptOptions.getWsMaximumMessageSize()) != null) {
            wsMaxMessageSize = Utils.parseDataSize((String)wsMax);
        }
        Long wsInactivityTimeout = null;
        if (acceptOptions != null && (value = acceptOptions.getWsInactivityTimeout()) != null && (val = Utils.parseTimeInterval((String)value, (TimeUnit)TimeUnit.MILLISECONDS)) > 0L) {
            wsInactivityTimeout = val;
        }
        Long tcpMaxOutboundRate = null;
        if (acceptOptions != null && (tcpMax = acceptOptions.getTcpMaximumOutboundRate()) != null) {
            tcpMaxOutboundRate = Utils.parseDataRate((String)tcpMax);
        }
        if (defaultOptions != null) {
            String wsMax2;
            ServiceAcceptOptionsType.SslVerifyClient.Enum verifyClient2;
            this.addBind("ws", defaultOptions.getWsBind());
            this.addBind("wss", defaultOptions.getWssBind());
            this.addBind("http", defaultOptions.getHttpBind());
            this.addBind("https", defaultOptions.getHttpsBind());
            this.addBind("ssl", defaultOptions.getSslBind());
            this.addBind("tcp", defaultOptions.getTcpBind());
            if (sslEncryptionEnabled == null) {
                ServiceAcceptOptionsType.SslEncryption.Enum encrypted2 = defaultOptions.getSslEncryption();
                sslEncryptionEnabled = encrypted2 != ServiceAcceptOptionsType.SslEncryption.DISABLED;
            }
            if (!wantClientAuth && !needClientAuth && (verifyClient2 = defaultOptions.getSslVerifyClient()) != null) {
                if (verifyClient2 == ServiceAcceptOptionsType.SslVerifyClient.REQUIRED) {
                    wantClientAuth = false;
                    needClientAuth = true;
                } else if (verifyClient2 == ServiceAcceptOptionsType.SslVerifyClient.OPTIONAL) {
                    wantClientAuth = true;
                    needClientAuth = false;
                } else {
                    wantClientAuth = false;
                    needClientAuth = false;
                }
            }
            if (sslCiphers == null) {
                sslCiphers = defaultOptions.getSslCiphers();
            }
            if (sslProtocols == null) {
                sslProtocols = defaultOptions.getSslProtocols();
            }
            if (pipeTransport == null) {
                pipeTransport = defaultOptions.getPipeTransport();
            }
            if (tcpTransport == null) {
                tcpTransport = defaultOptions.getTcpTransport();
            }
            if (sslTransport == null) {
                sslTransport = defaultOptions.getSslTransport();
            }
            if (httpTransport == null) {
                httpTransport = defaultOptions.getHttpTransport();
            }
            if (httpKeepaliveTimeout == null) {
                try {
                    httpKeepaliveTimeout = Utils.parseTimeInterval((String)defaultOptions.getHttpKeepaliveTimeout(), (TimeUnit)TimeUnit.SECONDS);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Cannot parse http.keepalive.timeout as a time interval: \"" + defaultOptions.getHttpKeepaliveTimeout() + "\".");
                }
            }
            if (wsMaxMessageSize == null && (wsMax2 = defaultOptions.getWsMaximumMessageSize()) != null) {
                wsMaxMessageSize = Utils.parseDataSize((String)wsMax2);
            }
            if (wsInactivityTimeout == null) {
                try {
                    wsInactivityTimeout = Utils.parseTimeInterval((String)defaultOptions.getWsInactivityTimeout(), (TimeUnit)TimeUnit.MILLISECONDS);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Cannot parse ws.inactivity.timeout as a time interval: \"" + defaultOptions.getWsInactivityTimeout() + "\".");
                }
            }
            if (tcpMaxOutboundRate == null && (tcpMax = defaultOptions.getTcpMaximumOutboundRate()) != null) {
                tcpMaxOutboundRate = Utils.parseDataRate((String)tcpMax);
            }
        }
        this.sslEncryptionEnabled = sslEncryptionEnabled == null ? true : sslEncryptionEnabled;
        this.sslCiphers = sslCiphers != null ? SslCipherSuites.resolveCSV((String)sslCiphers) : null;
        this.sslProtocols = sslProtocols != null ? DefaultAcceptOptionsContext.resolveProtocols(sslProtocols) : null;
        this.sslWantClientAuth = wantClientAuth;
        this.sslNeedClientAuth = needClientAuth;
        if (pipeTransport != null) {
            this.pipeTransportURI = URI.create(pipeTransport);
            if (!this.pipeTransportURI.isAbsolute()) {
                throw new IllegalArgumentException(String.format("pipe.transport must contain an absolute URI, not \"%s\"", pipeTransport));
            }
        } else {
            this.pipeTransportURI = null;
        }
        if (tcpTransport != null) {
            this.tcpTransportURI = URI.create(tcpTransport);
            if (!this.tcpTransportURI.isAbsolute()) {
                throw new IllegalArgumentException(String.format("tcp.transport must contain an absolute URI, not \"%s\"", tcpTransport));
            }
        } else {
            this.tcpTransportURI = null;
        }
        if (sslTransport != null) {
            this.sslTransportURI = URI.create(sslTransport);
            if (!this.sslTransportURI.isAbsolute()) {
                throw new IllegalArgumentException(String.format("ssl.transport must contain an absolute URI, not \"%s\"", sslTransport));
            }
        } else {
            this.sslTransportURI = null;
        }
        if (httpTransport != null) {
            this.httpTransportURI = URI.create(httpTransport);
            if (!this.httpTransportURI.isAbsolute()) {
                throw new IllegalArgumentException(String.format("http.transport must contain an absolute URI, not \"%s\"", httpTransport));
            }
        } else {
            this.httpTransportURI = null;
        }
        this.tcpMaximumOutboundRate = tcpMaxOutboundRate == null ? DEFAULT_TCP_MAXIMUM_OUTBOUND_RATE : (tcpMaxOutboundRate == 0L || tcpMaxOutboundRate > 0xFFFFFFFFL ? 0xFFFFFFFFL : tcpMaxOutboundRate);
        this.wsMaxMessageSize = wsMaxMessageSize == null ? DEFAULT_WEBSOCKET_MAXIMUM_MESSAGE_SIZE : wsMaxMessageSize;
        this.wsInactivityTimeout = wsInactivityTimeout == null ? 0L : wsInactivityTimeout;
        this.httpKeepaliveTimeout = httpKeepaliveTimeout == null ? DEFAULT_HTTP_KEEPALIVE_TIMEOUT : httpKeepaliveTimeout.intValue();
        this.wsProtocols = DEFAULT_WEBSOCKET_PROTOCOLS;
        if (this.wsInactivityTimeout > 0L) {
            ArrayList<String> extensions = new ArrayList<String>(DEFAULT_WEBSOCKET_EXTENSIONS);
            extensions.add(IDLE_TIMEOUT);
            this.wsExtensions = extensions;
        } else {
            this.wsExtensions = DEFAULT_WEBSOCKET_EXTENSIONS;
        }
        if (acceptOptions != null) {
            this.addBind("ws", acceptOptions.getWsBind());
            this.addBind("wss", acceptOptions.getWssBind());
            this.addBind("http", acceptOptions.getHttpBind());
            this.addBind("https", acceptOptions.getHttpsBind());
            this.addBind("ssl", acceptOptions.getSslBind());
            this.addBind("tcp", acceptOptions.getTcpBind());
        }
        this.udpInterface = udpInterface;
    }

    public Map<String, String> getBinds() {
        return this.binds;
    }

    public boolean isSslEncryptionEnabled() {
        return this.sslEncryptionEnabled;
    }

    public Integer getSessionIdleTimeout(String scheme) {
        Integer ret = null;
        if (scheme.equals("http") || scheme.equals("https")) {
            ret = this.httpKeepaliveTimeout;
        }
        return ret;
    }

    public Integer getHttpKeepaliveTimeout() {
        return this.httpKeepaliveTimeout;
    }

    public int getWsMaxMessageSize() {
        return this.wsMaxMessageSize;
    }

    public long getWsInactivityTimeout() {
        return this.wsInactivityTimeout;
    }

    public long getTcpMaximumOutboundRate() {
        return this.tcpMaximumOutboundRate;
    }

    public List<String> getWsProtocols() {
        return this.wsProtocols;
    }

    public List<String> getWsExtensions() {
        return this.wsExtensions;
    }

    public URI getInternalURI(URI externalURI) {
        String authority = externalURI.getAuthority();
        String internalAuthority = this.binds.get(externalURI.getScheme());
        if (internalAuthority != null) {
            if (!internalAuthority.equals(authority)) {
                try {
                    return new URI(externalURI.getScheme(), internalAuthority, externalURI.getPath(), externalURI.getQuery(), externalURI.getFragment());
                }
                catch (URISyntaxException e) {
                    // empty catch block
                }
            }
            return externalURI;
        }
        return null;
    }

    public void addBind(String scheme, String hostPort) {
        if (hostPort != null) {
            if (!hostPort.contains(":")) {
                try {
                    int port = Integer.parseInt(hostPort);
                    this.binds.put(scheme, "0.0.0.0:" + port);
                }
                catch (NumberFormatException ex) {
                    throw new RuntimeException("Failed to add bind for scheme " + scheme + " to port " + hostPort, ex);
                }
            } else {
                this.binds.put(scheme, hostPort);
            }
        }
    }

    public String[] getSslCiphers() {
        return this.sslCiphers;
    }

    public String[] getSslProtocols() {
        return this.sslProtocols;
    }

    public boolean getSslWantClientAuth() {
        return this.sslWantClientAuth;
    }

    public boolean getSslNeedClientAuth() {
        return this.sslNeedClientAuth;
    }

    public URI getTcpTransport() {
        return this.tcpTransportURI;
    }

    public URI getSslTransport() {
        return this.sslTransportURI;
    }

    public URI getHttpTransport() {
        return this.httpTransportURI;
    }

    public URI getPipeTransport() {
        return this.pipeTransportURI;
    }

    public String getUdpInterface() {
        return this.udpInterface;
    }

    public Map<String, Object> asOptionsMap() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("supportedProtocols", this.getWsProtocols().toArray(new String[this.getWsProtocols().size()]));
        result.put("ws.extensions", this.getWsExtensions());
        result.put("ws[ws/rfc6455].ws[ws/rfc6455].extensions", this.getWsExtensions());
        result.put("ws[ws/draft-7x].ws[ws/draft-7x].extensions", this.getWsExtensions());
        result.put("ws.maxMessageSize", this.getWsMaxMessageSize());
        result.put("ws[ws/rfc6455].ws[ws/rfc6455].maxMessageSize", this.getWsMaxMessageSize());
        result.put("ws[ws/draft-7x].ws[ws/draft-7x].maxMessageSize", this.getWsMaxMessageSize());
        result.put("ws.inactivityTimeout", this.getWsInactivityTimeout());
        result.put("ws[ws/rfc6455].ws[ws/rfc6455].inactivityTimeout", this.getWsInactivityTimeout());
        result.put("ws[ws/draft-7x].ws[ws/draft-7x].inactivityTimeout", this.getWsInactivityTimeout());
        result.put("http[http/1.1].keepAliveTimeout", this.getHttpKeepaliveTimeout());
        result.put("pipe.transport", this.getPipeTransport());
        result.put("ssl.ciphers", this.getSslCiphers());
        result.put("ssl.protocols", this.getSslProtocols());
        result.put("ssl.encryptionEnabled", this.isSslEncryptionEnabled());
        result.put("ssl.wantClientAuth", this.getSslWantClientAuth());
        result.put("ssl.needClientAuth", this.getSslNeedClientAuth());
        result.put("tcp.transport", this.getTcpTransport());
        result.put("ssl.transport", this.getSslTransport());
        result.put("http[http/1.1].transport", this.getHttpTransport());
        result.put("tcp.maximumOutboundRate", this.getTcpMaximumOutboundRate());
        result.put("udp.interface", this.getUdpInterface());
        for (Map.Entry<String, String> entry : this.getBinds().entrySet()) {
            String internalBindOptionName = this.resolveInternalBindOptionName(entry.getKey());
            if (internalBindOptionName != null) {
                result.put(internalBindOptionName, entry.getValue());
                continue;
            }
            throw new RuntimeException("Cannot apply unknown bind option '" + entry.getKey() + "'.");
        }
        return result;
    }

    private String resolveInternalBindOptionName(String externalBindOptionName) {
        if (externalBindOptionName.equals("tcp")) {
            return "tcp.bind";
        }
        if (externalBindOptionName.equals("ssl")) {
            return "ssl.tcp.bind";
        }
        if (externalBindOptionName.equals("http")) {
            return "http.tcp.bind";
        }
        if (externalBindOptionName.equals("https")) {
            return "http.ssl.tcp.bind";
        }
        if (externalBindOptionName.equals("ws")) {
            return "ws.http.tcp.bind";
        }
        if (externalBindOptionName.equals("wss")) {
            return "ws.http.ssl.tcp.bind";
        }
        if (externalBindOptionName.equals("wsn")) {
            return "wsn.http.tcp.bind";
        }
        if (externalBindOptionName.equals("wsn+ssl")) {
            return "wsn.http.ssl.tcp.bind";
        }
        if (externalBindOptionName.equals("wsx")) {
            return "wsn.http.wsn.http.tcp.bind";
        }
        if (externalBindOptionName.equals("wsx+ssl")) {
            return "wsn.http.wsn.http.ssl.tcp.bind";
        }
        if (externalBindOptionName.equals("httpxe")) {
            return "http.http.tcp.bind";
        }
        if (externalBindOptionName.equals("httpxe+ssl")) {
            return "http.http.ssl.tcp.bind";
        }
        return null;
    }

    public static String[] resolveProtocols(String csv) {
        if (csv != null && !csv.equals("")) {
            return csv.split(",");
        }
        return null;
    }
}

