/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.config.parse.translate;

import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.kaazing.gateway.server.config.parse.translate.AbstractVisitor;

public class UpdateServiceNameVisitor
extends AbstractVisitor {
    private static final String SERVICE_NODE = "service";
    private Namespace namespace;

    @Override
    public void visit(Element element) throws Exception {
        Element typeElement = element.getChild("type", this.namespace);
        String type = typeElement.getTextTrim();
        if (type.equalsIgnoreCase("stomp.jms")) {
            typeElement.setText("jms");
        } else if (type.equals("stomp.interceptor")) {
            typeElement.setText("jms.proxy");
        } else if (type.equals("stomp.proxy")) {
            throw new RuntimeException("stomp.proxy is no longer supported, please migrate to jms.proxy instead");
        }
    }

    @Override
    public void translate(Document dom) throws Exception {
        Element root = dom.getRootElement();
        this.namespace = root.getNamespace();
        List children = dom.getRootElement().getChildren(SERVICE_NODE, this.namespace);
        for (Element child : children) {
            this.visit(child);
        }
    }
}

