/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.test.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.kaazing.gateway.server.test.config.Configuration;
import org.kaazing.gateway.server.test.config.ConfigurationVisitor;
import org.kaazing.gateway.server.test.config.Suppressible;
import org.kaazing.gateway.server.test.config.SuppressibleConfiguration;
import org.kaazing.gateway.server.test.config.SuppressibleServiceDefaultsConfiguration;
import org.kaazing.gateway.server.test.config.Suppressibles;

public class ServiceDefaultsConfiguration
implements Configuration<SuppressibleServiceDefaultsConfiguration> {
    private final SuppressibleServiceDefaultsConfiguration _configuration;
    private final Map<String, Suppressible<String>> acceptOptions = new HashMap<String, Suppressible<String>>();
    private final Map<String, String> unsuppressibleAcceptOptions = Suppressibles.unsuppressibleMap(this.acceptOptions);
    private final Map<String, Suppressible<String>> mimeMappings = new HashMap<String, Suppressible<String>>();
    private final Map<String, String> unsuppressibleMimeMappings = Suppressibles.unsuppressibleMap(this.mimeMappings);

    public ServiceDefaultsConfiguration() {
        this._configuration = new SuppressibleServiceDefaultsConfigurationImpl();
        this._configuration.setSuppression(Suppressibles.getDefaultSuppressions());
    }

    @Override
    public SuppressibleServiceDefaultsConfiguration getSuppressibleConfiguration() {
        return this._configuration;
    }

    @Override
    public void accept(ConfigurationVisitor visitor) {
        visitor.visit(this);
    }

    public Map<String, String> getAcceptOptions() {
        return this.unsuppressibleAcceptOptions;
    }

    public void addAcceptOption(String key, String value) {
        this.unsuppressibleAcceptOptions.put(key, value);
    }

    public Map<String, String> getMimeMappings() {
        return this.unsuppressibleMimeMappings;
    }

    public void addMimeMapping(String key, String value) {
        this.unsuppressibleMimeMappings.put(key, value);
    }

    private class SuppressibleServiceDefaultsConfigurationImpl
    extends SuppressibleServiceDefaultsConfiguration {
        private Set<SuppressibleConfiguration.Suppression> _suppressions;

        private SuppressibleServiceDefaultsConfigurationImpl() {
        }

        @Override
        public Set<SuppressibleConfiguration.Suppression> getSuppressions() {
            return this._suppressions;
        }

        @Override
        public void setSuppression(Set<SuppressibleConfiguration.Suppression> suppressions) {
            this._suppressions = suppressions;
        }

        @Override
        public Map<String, Suppressible<String>> getAcceptOptions() {
            return ServiceDefaultsConfiguration.this.acceptOptions;
        }

        @Override
        public void addAcceptOption(String key, Suppressible<String> value) {
            ServiceDefaultsConfiguration.this.acceptOptions.put(key, value);
        }

        @Override
        public Map<String, Suppressible<String>> getMimeMappings() {
            return ServiceDefaultsConfiguration.this.mimeMappings;
        }

        @Override
        public void addMimeMapping(String key, Suppressible<String> value) {
            ServiceDefaultsConfiguration.this.mimeMappings.put(key, value);
        }
    }
}

