/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.test.config;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import org.kaazing.gateway.server.test.config.ClusterConfiguration;
import org.kaazing.gateway.server.test.config.Configuration;
import org.kaazing.gateway.server.test.config.ConfigurationVisitor;
import org.kaazing.gateway.server.test.config.NetworkConfiguration;
import org.kaazing.gateway.server.test.config.SecurityConfiguration;
import org.kaazing.gateway.server.test.config.ServiceConfiguration;
import org.kaazing.gateway.server.test.config.ServiceDefaultsConfiguration;
import org.kaazing.gateway.server.test.config.SuppressibleConfiguration;
import org.kaazing.gateway.server.test.config.SuppressibleGatewayConfiguration;
import org.kaazing.gateway.server.test.config.Suppressibles;

public class GatewayConfiguration
implements Configuration<SuppressibleGatewayConfiguration> {
    private final SuppressibleGatewayConfiguration _configuration = new SuppressibleGatewayConfigurationImpl();
    private final Map<String, String> properties;
    private File webRootDirectory;
    private File tempDirectory;
    private MBeanServer jmxMBeanServer;
    private final List<ServiceConfiguration> services;
    private SecurityConfiguration security;
    private ClusterConfiguration cluster = null;
    private ServiceDefaultsConfiguration serviceDefaultsConfiguration = null;
    private NetworkConfiguration networkConfiguration;

    public GatewayConfiguration() {
        this._configuration.setSuppression(Suppressibles.getDefaultSuppressions());
        this.services = new LinkedList<ServiceConfiguration>();
        this.properties = new HashMap<String, String>();
    }

    @Override
    public void accept(ConfigurationVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public SuppressibleGatewayConfiguration getSuppressibleConfiguration() {
        return this._configuration;
    }

    public File getWebRootDirectory() {
        return this.webRootDirectory;
    }

    public void setWebRootDirectory(File webRootDirectory) {
        this.webRootDirectory = webRootDirectory;
    }

    public File getTempDirectory() {
        return this.tempDirectory;
    }

    public void setTempDirectory(File tempDirectory) {
        this.tempDirectory = tempDirectory;
    }

    public SecurityConfiguration getSecurity() {
        return this.security;
    }

    public void setSecurity(SecurityConfiguration security) {
        this.security = security;
    }

    public Collection<ServiceConfiguration> getServices() {
        return this.services;
    }

    public void setServices(List<ServiceConfiguration> newServices) {
        this.services.clear();
        this.services.addAll(newServices);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> newProperties) {
        this.properties.clear();
        this.properties.putAll(newProperties);
    }

    public ClusterConfiguration getCluster() {
        return this.cluster;
    }

    public void setCluster(ClusterConfiguration cluster) {
        this.cluster = cluster;
    }

    public ServiceDefaultsConfiguration getServiceDefaults() {
        return this.serviceDefaultsConfiguration;
    }

    public void setServiceDefaults(ServiceDefaultsConfiguration serviceDefaultsConfiguration) {
        this.serviceDefaultsConfiguration = serviceDefaultsConfiguration;
    }

    public MBeanServer getJmxMBeanServer() {
        return this.jmxMBeanServer;
    }

    public void setJmxMBeanServer(MBeanServer jmxMBeanServer) {
        this.jmxMBeanServer = jmxMBeanServer;
    }

    public NetworkConfiguration getNetwork() {
        return this.networkConfiguration;
    }

    public void setNetwork(NetworkConfiguration configuration) {
        this.networkConfiguration = configuration;
    }

    public String getConfigDir() {
        return this.properties.get("GATEWAY_CONFIG_DIRECTORY");
    }

    private class SuppressibleGatewayConfigurationImpl
    extends SuppressibleGatewayConfiguration {
        private Set<SuppressibleConfiguration.Suppression> _suppressions;

        private SuppressibleGatewayConfigurationImpl() {
        }

        @Override
        public Set<SuppressibleConfiguration.Suppression> getSuppressions() {
            return this._suppressions;
        }

        @Override
        public void setSuppression(Set<SuppressibleConfiguration.Suppression> suppressions) {
            this._suppressions = suppressions;
        }
    }
}

