/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.messaging.collections;

import com.hazelcast.core.AtomicNumber;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IList;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ITopic;
import org.kaazing.gateway.service.messaging.collections.CollectionsFactory;
import org.kaazing.gateway.util.AtomicCounter;

public class ClusterCollectionsFactory
implements CollectionsFactory {
    private HazelcastInstance cluster;

    public ClusterCollectionsFactory(HazelcastInstance cluster) {
        this.cluster = cluster;
    }

    public <E> IList<E> getList(String name) {
        return this.cluster.getList(name);
    }

    public <K, V> IMap<K, V> getMap(String name) {
        return this.cluster.getMap(name);
    }

    public <E> IQueue<E> getQueue(String name) {
        return this.cluster.getQueue(name);
    }

    public <E> ITopic<E> getTopic(String name) {
        return this.cluster.getTopic(name);
    }

    public ILock getLock(Object obj) {
        return this.cluster.getLock(obj);
    }

    public <K, V> void addEntryListener(EntryListener<K, V> listener, String name) {
        IMap map = this.cluster.getMap(name);
        if (map != null) {
            map.addEntryListener(listener, true);
        }
    }

    public AtomicCounter getAtomicCounter(String name) {
        return new ClusterAtomicCounter(this.cluster.getAtomicNumber(name));
    }

    private class ClusterAtomicCounter
    implements AtomicCounter {
        private AtomicNumber atomicNumber;

        private ClusterAtomicCounter(AtomicNumber number) {
            this.atomicNumber = number;
        }

        public long get() {
            return this.atomicNumber.get();
        }

        public long incrementAndGet() {
            return this.atomicNumber.incrementAndGet();
        }

        public long decrementAndGet() {
            return this.atomicNumber.decrementAndGet();
        }

        public boolean compareAndSet(long expect, long update) {
            return this.atomicNumber.compareAndSet(expect, update);
        }
    }
}

