/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.context.resolve;

import java.io.File;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.Key;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.management.MBeanServer;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.kaazing.gateway.resource.address.ResourceAddressFactory;
import org.kaazing.gateway.security.AuthenticationContext;
import org.kaazing.gateway.security.CrossSiteConstraintContext;
import org.kaazing.gateway.security.RealmContext;
import org.kaazing.gateway.security.SecurityContext;
import org.kaazing.gateway.security.auth.BasicLoginModule;
import org.kaazing.gateway.security.auth.NegotiateLoginModule;
import org.kaazing.gateway.security.auth.TimeoutLoginModule;
import org.kaazing.gateway.server.Gateway;
import org.kaazing.gateway.server.Launcher;
import org.kaazing.gateway.server.config.SchemeConfig;
import org.kaazing.gateway.server.config.parse.DefaultSchemeConfig;
import org.kaazing.gateway.server.config.sep2014.AuthenticationType;
import org.kaazing.gateway.server.config.sep2014.AuthorizationConstraintType;
import org.kaazing.gateway.server.config.sep2014.ClusterConnectOptionsType;
import org.kaazing.gateway.server.config.sep2014.ClusterType;
import org.kaazing.gateway.server.config.sep2014.CrossSiteConstraintType;
import org.kaazing.gateway.server.config.sep2014.GatewayConfigDocument;
import org.kaazing.gateway.server.config.sep2014.LoginModuleOptionsType;
import org.kaazing.gateway.server.config.sep2014.LoginModuleType;
import org.kaazing.gateway.server.config.sep2014.MimeMappingType;
import org.kaazing.gateway.server.config.sep2014.RealmType;
import org.kaazing.gateway.server.config.sep2014.SecurityType;
import org.kaazing.gateway.server.config.sep2014.ServiceAcceptOptionsType;
import org.kaazing.gateway.server.config.sep2014.ServiceConnectOptionsType;
import org.kaazing.gateway.server.config.sep2014.ServiceDefaultsType;
import org.kaazing.gateway.server.config.sep2014.ServicePropertiesType;
import org.kaazing.gateway.server.config.sep2014.ServiceType;
import org.kaazing.gateway.server.context.DependencyContext;
import org.kaazing.gateway.server.context.GatewayContext;
import org.kaazing.gateway.server.context.resolve.ContextResolver;
import org.kaazing.gateway.server.context.resolve.DefaultAcceptOptionsContext;
import org.kaazing.gateway.server.context.resolve.DefaultAuthenticationContext;
import org.kaazing.gateway.server.context.resolve.DefaultClusterContext;
import org.kaazing.gateway.server.context.resolve.DefaultConnectOptionsContext;
import org.kaazing.gateway.server.context.resolve.DefaultCrossSiteConstraintContext;
import org.kaazing.gateway.server.context.resolve.DefaultGatewayContext;
import org.kaazing.gateway.server.context.resolve.DefaultRealmContext;
import org.kaazing.gateway.server.context.resolve.DefaultRealmsContext;
import org.kaazing.gateway.server.context.resolve.DefaultSchemeContext;
import org.kaazing.gateway.server.context.resolve.DefaultSecurityContext;
import org.kaazing.gateway.server.context.resolve.DefaultServiceContext;
import org.kaazing.gateway.server.context.resolve.DefaultServiceDefaultsContext;
import org.kaazing.gateway.server.context.resolve.DefaultServiceProperties;
import org.kaazing.gateway.server.context.resolve.DefaultTransportContext;
import org.kaazing.gateway.server.context.resolve.RealmsContext;
import org.kaazing.gateway.server.context.resolve.SecurityContextResolver;
import org.kaazing.gateway.server.context.resolve.StandaloneClusterContext;
import org.kaazing.gateway.server.service.ServiceRegistry;
import org.kaazing.gateway.service.Service;
import org.kaazing.gateway.service.ServiceContext;
import org.kaazing.gateway.service.ServiceFactory;
import org.kaazing.gateway.service.ServiceProperties;
import org.kaazing.gateway.service.cluster.ClusterConnectOptionsContext;
import org.kaazing.gateway.service.cluster.ClusterContext;
import org.kaazing.gateway.service.cluster.MemberId;
import org.kaazing.gateway.transport.BridgeAcceptor;
import org.kaazing.gateway.transport.BridgeConnector;
import org.kaazing.gateway.transport.BridgeServiceFactory;
import org.kaazing.gateway.transport.Transport;
import org.kaazing.gateway.transport.TransportFactory;
import org.kaazing.gateway.util.GL;
import org.kaazing.gateway.util.InternalSystemProperty;
import org.kaazing.gateway.util.Utils;
import org.kaazing.gateway.util.aws.AwsUtils;
import org.kaazing.gateway.util.scheduler.SchedulerProvider;
import org.kaazing.gateway.util.ssl.SslCipherSuites;
import org.slf4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GatewayContextResolver {
    public static final String AUTHORIZATION_MODE_CHALLENGE = "challenge";
    public static final String AUTH_SCHEME_BASIC = "Basic";
    public static final String AUTH_SCHEME_NEGOTIATE = "Negotiate";
    public static final String AUTH_SCHEME_APPLICATION_TOKEN = "Application Token";
    public static final String AUTH_SCHEME_APPLICATION_PREFIX = "Application ";
    private static final Logger LOGGER = Launcher.getGatewayStartupLogger();
    private static final String SERVICE_TYPE_CLASS_PREFIX = "class:";
    private static final String LOGIN_MODULE_TYPE_CLASS_PREFIX = "class:";
    private static final Map<String, String> defaultMimeMappings = new HashMap<String, String>();
    private final Map<String, String> loginModuleClassNames;
    private final Map<String, AppConfigurationEntry.LoginModuleControlFlag> loginModuleControlFlags;
    private final File webDir;
    private final File tempDir;
    private final MBeanServer jmxMBeanServer;
    private final Map<String, SchemeConfig> schemeConfigsByName;
    private final Map<String, DefaultTransportContext> transportContextsBySchemeName;
    private final Map<String, DefaultTransportContext> transportContextsByName;
    private ContextResolver<SecurityType, DefaultSecurityContext> securityResolver;

    public GatewayContextResolver(File configDir, File webDir, File tempDir) {
        this(configDir, webDir, tempDir, null);
    }

    public GatewayContextResolver(File configDir, File webDir, File tempDir, MBeanServer mbeanServer) {
        this(new SecurityContextResolver(configDir, LOGGER), webDir, tempDir, mbeanServer);
    }

    public GatewayContextResolver(ContextResolver<SecurityType, DefaultSecurityContext> securityResolver, File webDir, File tempDir) {
        this(securityResolver, webDir, tempDir, null);
    }

    public GatewayContextResolver(ContextResolver<SecurityType, DefaultSecurityContext> securityResolver, File webDir, File tempDir, MBeanServer mbeanServer) {
        this.securityResolver = securityResolver;
        this.webDir = webDir;
        this.tempDir = tempDir;
        this.jmxMBeanServer = mbeanServer;
        this.loginModuleClassNames = new HashMap<String, String>();
        HashMap<String, AppConfigurationEntry.LoginModuleControlFlag> loginModuleControlFlags = new HashMap<String, AppConfigurationEntry.LoginModuleControlFlag>();
        loginModuleControlFlags.put("optional", AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL);
        loginModuleControlFlags.put("required", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED);
        loginModuleControlFlags.put("requisite", AppConfigurationEntry.LoginModuleControlFlag.REQUISITE);
        loginModuleControlFlags.put("sufficient", AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT);
        this.loginModuleControlFlags = loginModuleControlFlags;
        this.schemeConfigsByName = new HashMap<String, SchemeConfig>();
        this.transportContextsBySchemeName = new HashMap<String, DefaultTransportContext>();
        this.transportContextsByName = new HashMap<String, DefaultTransportContext>();
        SslCipherSuites.init();
    }

    public GatewayContext resolve(GatewayConfigDocument gatewayConfigDoc) throws Exception {
        return this.resolve(gatewayConfigDoc, System.getProperties());
    }

    public GatewayContext resolve(GatewayConfigDocument gatewayConfigDoc, Properties configuration) throws Exception {
        GatewayConfigDocument.GatewayConfig gatewayConfig = gatewayConfigDoc.getGatewayConfig();
        LinkedList schemeConfigs = new LinkedList();
        SecurityType[] securityConfigs = gatewayConfig.getSecurityArray();
        SecurityType securityConfig = securityConfigs.length > 0 ? securityConfigs[securityConfigs.length - 1] : null;
        ServiceType[] serviceConfigs = gatewayConfig.getServiceArray();
        ServiceDefaultsType[] serviceDefaultsArray = gatewayConfig.getServiceDefaultsArray();
        ServiceDefaultsType serviceDefaults = serviceDefaultsArray.length > 0 ? serviceDefaultsArray[serviceDefaultsArray.length - 1] : null;
        ClusterType[] clusterConfigs = gatewayConfig.getClusterArray();
        ClusterType clusterConfig = clusterConfigs.length > 0 ? clusterConfigs[clusterConfigs.length - 1] : null;
        DefaultSecurityContext securityContext = this.securityResolver.resolve(securityConfig);
        RealmsContext realmsContext = this.resolveRealms(securityConfig, securityContext, configuration);
        DefaultServiceDefaultsContext serviceDefaultsContext = this.resolveServiceDefaults(serviceDefaults);
        SchedulerProvider schedulerProvider = new SchedulerProvider(configuration);
        ClusterContext clusterContext = this.resolveCluster(clusterConfig, schedulerProvider);
        ServiceRegistry servicesByURI = new ServiceRegistry();
        Map<String, Object> dependencyContexts = this.resolveDependencyContext();
        ResourceAddressFactory resourceAddressFactory = this.resolveResourceAddressFactories();
        TransportFactory transportFactory = TransportFactory.newTransportFactory((Map)configuration);
        ServiceFactory serviceFactory = ServiceFactory.newServiceFactory();
        Collection<ServiceContext> services = this.resolveServices(servicesByURI, this.webDir, this.tempDir, serviceConfigs, securityContext, realmsContext, clusterContext, serviceDefaults, schedulerProvider, dependencyContexts, configuration, transportFactory, serviceFactory, resourceAddressFactory);
        this.resolveTransports(transportFactory);
        BridgeServiceFactory bridgeServiceFactory = this.resolveBridgeServiceFactory(transportFactory);
        Map<String, DefaultSchemeContext> schemeContexts = this.resolveSchemes(services, schemeConfigs, configuration, resourceAddressFactory);
        DefaultGatewayContext gatewayContext = new DefaultGatewayContext(schemeContexts, this.transportContextsBySchemeName, realmsContext, serviceDefaultsContext, services, servicesByURI, this.webDir, this.tempDir, clusterContext, schedulerProvider);
        HashMap<String, Object> injectables = new HashMap<String, Object>();
        injectables.putAll(dependencyContexts);
        injectables.put("serviceRegistry", servicesByURI);
        injectables.put("realmsContext", realmsContext);
        injectables.put("tempDirectory", this.tempDir);
        injectables.put("securityContext", securityContext);
        injectables.put("clusterContext", clusterContext);
        injectables.put("gatewayContext", gatewayContext);
        injectables.put("schedulerProvider", schedulerProvider);
        injectables.put("configuration", configuration);
        injectables.put("mbeanServer", this.jmxMBeanServer);
        injectables.put("bridgeServiceFactory", bridgeServiceFactory);
        injectables.put("resourceAddressFactory", resourceAddressFactory);
        injectables.put("transportFactory", transportFactory);
        gatewayContext.getInjectables().putAll(injectables);
        this.injectResources(services, bridgeServiceFactory, dependencyContexts, injectables);
        return gatewayContext;
    }

    private BridgeServiceFactory resolveBridgeServiceFactory(TransportFactory transportFactory) {
        return new BridgeServiceFactory(transportFactory);
    }

    private ResourceAddressFactory resolveResourceAddressFactories() {
        return ResourceAddressFactory.newResourceAddressFactory();
    }

    private Map<String, DefaultSchemeContext> resolveSchemes(Collection<? extends ServiceContext> serviceContexts, Collection<? extends SchemeConfig> schemeConfigs, Properties configuration, ResourceAddressFactory resourceAddressFactory) throws Exception {
        HashSet<String> schemeNames = new HashSet<String>();
        for (ServiceContext serviceContext : serviceContexts) {
            String connect;
            String schemeName;
            for (URI acceptURI : serviceContext.getAccepts()) {
                schemeName = acceptURI.getScheme();
                schemeNames.add(schemeName);
            }
            for (URI connectURI : serviceContext.getConnects()) {
                schemeName = connectURI.getScheme();
                schemeNames.add(schemeName);
            }
            ServiceProperties properties = serviceContext.getProperties();
            String accept = properties.get("accept");
            if (accept != null) {
                accept = accept.trim();
                schemeNames.add(new URI(accept).getScheme());
            }
            if ((connect = properties.get("connect")) == null) continue;
            connect = connect.trim();
            schemeNames.add(new URI(connect).getScheme());
        }
        if (schemeNames.contains("ws")) {
            schemeNames.add("http");
            schemeNames.add("httpx");
            schemeNames.add("httpxe");
            schemeNames.add("wsn");
            schemeNames.add("wsx");
        }
        if (schemeNames.contains("wss")) {
            schemeNames.add("https");
            schemeNames.add("httpx+ssl");
            schemeNames.add("httpxe+ssl");
            schemeNames.add("wsn+ssl");
            schemeNames.add("wsx+ssl");
        }
        if (schemeNames.contains("sse")) {
            schemeNames.add("httpxe");
        }
        if (schemeNames.contains("sse+ssl")) {
            schemeNames.add("httpxe+ssl");
        }
        schemeNames.add("tcp");
        for (SchemeConfig schemeConfig : schemeConfigs) {
            String schemeName = schemeConfig.getName();
            this.schemeConfigsByName.put(schemeName, schemeConfig);
            schemeNames.add(schemeName);
        }
        HashMap<String, DefaultSchemeContext> schemeContexts = new HashMap<String, DefaultSchemeContext>();
        for (String schemeName : schemeNames) {
            DefaultSchemeContext schemeContext = (DefaultSchemeContext)schemeContexts.get(schemeName);
            if (schemeContext != null) continue;
            SchemeConfig schemeConfig = this.supplySchemeConfig(schemeName);
            int defaultPort = schemeConfig.getDefaultPort();
            String transportName = schemeConfig.getTransportName();
            DefaultTransportContext transportContext = this.transportContextsByName.get(transportName);
            if (transportContext == null) {
                throw new IllegalArgumentException("Missing transport \"" + transportName + "\"");
            }
            schemeContext = new DefaultSchemeContext(schemeName, defaultPort, resourceAddressFactory);
            schemeContexts.put(schemeName, schemeContext);
            this.transportContextsBySchemeName.put(schemeName, transportContext);
        }
        return schemeContexts;
    }

    private SchemeConfig supplySchemeConfig(String schemeName) {
        SchemeConfig schemeConfig = this.schemeConfigsByName.get(schemeName);
        if (schemeConfig == null) {
            schemeConfig = this.findSchemeConfig(schemeName);
            if (schemeConfig == null) {
                throw new IllegalArgumentException("Missing scheme \"" + schemeName + "\"");
            }
            if (schemeConfig != null) {
                this.schemeConfigsByName.put(schemeName, schemeConfig);
            }
        }
        return schemeConfig;
    }

    private DefaultServiceDefaultsContext resolveServiceDefaults(ServiceDefaultsType serviceDefaults) {
        if (serviceDefaults == null) {
            return null;
        }
        DefaultAcceptOptionsContext acceptOptions = null;
        ServiceAcceptOptionsType serviceAcceptOptions = serviceDefaults.getAcceptOptions();
        if (serviceAcceptOptions != null) {
            acceptOptions = new DefaultAcceptOptionsContext(null, serviceAcceptOptions);
        }
        HashMap<String, String> mimeMappings = null;
        MimeMappingType[] mimeMappingTypes = serviceDefaults.getMimeMappingArray();
        if (mimeMappingTypes != null) {
            mimeMappings = new HashMap<String, String>();
            for (MimeMappingType mmt : mimeMappingTypes) {
                mimeMappings.put(mmt.getExtension(), mmt.getMimeType());
            }
        }
        return new DefaultServiceDefaultsContext(acceptOptions, mimeMappings);
    }

    private Collection<ServiceContext> resolveServices(ServiceRegistry serviceRegistry, File webDir, File tempDir, ServiceType[] serviceConfigs, SecurityContext securityContext, RealmsContext realmsContext, ClusterContext clusterContext, ServiceDefaultsType defaultServiceConfig, SchedulerProvider schedulerProvider, Map<String, Object> dependencyContexts, Properties configuration, TransportFactory transportFactory, ServiceFactory serviceFactory, ResourceAddressFactory resourceAddressFactory) throws Exception {
        HashSet<ServiceContext> serviceContexts = new HashSet<ServiceContext>();
        HashMap<String, String> serviceDefaultsMimeMappings = new HashMap<String, String>();
        serviceDefaultsMimeMappings.putAll(defaultMimeMappings);
        if (defaultServiceConfig != null) {
            for (MimeMappingType mimeMappingType : defaultServiceConfig.getMimeMappingArray()) {
                serviceDefaultsMimeMappings.put(mimeMappingType.getExtension().toLowerCase(), mimeMappingType.getMimeType());
            }
        }
        ArrayList<HashMap<URI, Map<String, CrossSiteConstraintContext>>> authorityToSetOfAcceptConstraintsByURI = new ArrayList<HashMap<URI, Map<String, CrossSiteConstraintContext>>>();
        for (ServiceType serviceConfig : serviceConfigs) {
            String connectProperty;
            String serviceName = serviceConfig.getName();
            String serviceDescription = serviceConfig.getDescription();
            String[] acceptStrings = serviceConfig.getAcceptArray();
            String[] balanceStrings = serviceConfig.getBalanceArray();
            String[] connectStrings = serviceConfig.getConnectArray();
            String serviceType = serviceConfig.getType();
            Service serviceInstance = null;
            Class<?> serviceClass = null;
            if (serviceType.startsWith("class:")) {
                String className = serviceType.substring("class:".length());
                try {
                    Class<?> clazz = Class.forName(className);
                    if (!Service.class.isAssignableFrom(clazz)) {
                        throw new IllegalArgumentException("Incompatible gateway service class: " + className);
                    }
                    serviceClass = clazz;
                    serviceInstance = (Service)serviceClass.newInstance();
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Unknown gateway service class: " + className);
                }
            } else {
                serviceInstance = serviceFactory.newService(serviceType);
                if (serviceInstance == null) {
                    throw new IllegalArgumentException("Unrecognized service type: " + serviceType);
                }
            }
            ServicePropertiesType propertiesType = serviceConfig.getProperties();
            DefaultServiceProperties properties = this.parsePropertiesType(propertiesType);
            Collection<URI> acceptURIs = this.resolveURIs(acceptStrings);
            Collection<URI> balanceURIs = this.resolveURIs(balanceStrings);
            Collection<URI> connectURIs = this.resolveURIs(connectStrings);
            String acceptProperty = properties.get("accept");
            if (acceptProperty != null) {
                acceptProperty = acceptProperty.trim();
                acceptProperty = this.resolveURI(GatewayContextResolver.getCanonicalURI(acceptProperty, false)).toString();
                properties.put("accept", acceptProperty);
            }
            if ((connectProperty = properties.get("connect")) != null) {
                connectProperty = connectProperty.trim();
                properties.remove("connect");
                connectURIs.add(this.resolveURI(GatewayContextResolver.getCanonicalURI(connectProperty, true)));
            }
            LinkedList requireRolesCollection = new LinkedList();
            for (AuthorizationConstraintType authConstraint : serviceConfig.getAuthorizationConstraintArray()) {
                Collections.addAll(requireRolesCollection, authConstraint.getRequireRoleArray());
            }
            String[] requireRoles = requireRolesCollection.toArray(new String[requireRolesCollection.size()]);
            HashMap<String, String> mimeMappings = new HashMap<String, String>();
            mimeMappings.putAll(serviceDefaultsMimeMappings);
            for (MimeMappingType mimeMappingType : serviceConfig.getMimeMappingArray()) {
                mimeMappings.put(mimeMappingType.getExtension().toLowerCase(), mimeMappingType.getMimeType());
            }
            HashMap<URI, Map<String, CrossSiteConstraintContext>> acceptConstraintsByURI = new HashMap<URI, Map<String, CrossSiteConstraintContext>>();
            for (URI acceptURI : acceptURIs) {
                CrossSiteConstraintType[] crossSiteConstraints;
                int wildcardOriginCount = 0;
                for (CrossSiteConstraintType crossSiteConstraint : crossSiteConstraints = serviceConfig.getCrossSiteConstraintArray()) {
                    HashMap<String, DefaultCrossSiteConstraintContext> acceptConstraints;
                    Integer maximumAge;
                    String allowOrigin = (String)crossSiteConstraint.getAllowOrigin();
                    String allowMethods = crossSiteConstraint.getAllowMethods();
                    String allowHeaders = crossSiteConstraint.getAllowHeaders();
                    BigInteger maximumAgeBigInt = crossSiteConstraint.getMaximumAge();
                    Integer n = maximumAge = maximumAgeBigInt == null ? null : Integer.valueOf(maximumAgeBigInt.intValue());
                    if (allowOrigin == null) {
                        throw new IllegalArgumentException("Cross-site allow-origin is required");
                    }
                    if ("*".equals(allowOrigin)) {
                        ++wildcardOriginCount;
                    } else {
                        URI allowOriginURI = GatewayContextResolver.getCanonicalURI(allowOrigin, false);
                        allowOrigin = allowOriginURI.toString();
                        String allowOriginScheme = allowOriginURI.getScheme();
                        if (!"http".equals(allowOriginScheme) && !"https".equals(allowOriginScheme)) {
                            throw new IllegalArgumentException("Cross-site allow-origin must have URI syntax with http or https scheme");
                        }
                        if (allowOriginURI.getPath() != null && allowOriginURI.getQuery() != null || allowOriginURI.getFragment() != null) {
                            throw new IllegalArgumentException("Cross-site allow-origin must have URI syntax without path, query or fragment");
                        }
                        if (allowOriginURI.getPort() == -1) {
                            if ("http".equals(allowOriginScheme)) {
                                allowOrigin = allowOrigin + ":80";
                            } else if ("https".equals(allowOriginScheme)) {
                                allowOrigin = allowOrigin + ":443";
                            } else {
                                throw new IllegalArgumentException("Unable to default port for scheme: \"" + allowOriginScheme + "\"");
                            }
                        }
                    }
                    if (allowMethods != null) {
                        String[] allowMethodsArray;
                        for (String allowMethod : allowMethodsArray = allowMethods.split(",")) {
                            HttpMethod.valueOf(allowMethod);
                        }
                    } else {
                        allowMethods = "GET,POST";
                    }
                    if ((acceptConstraints = (HashMap<String, DefaultCrossSiteConstraintContext>)acceptConstraintsByURI.get(acceptURI)) == null) {
                        acceptConstraints = new HashMap<String, DefaultCrossSiteConstraintContext>();
                        acceptConstraintsByURI.put(acceptURI, acceptConstraints);
                    }
                    authorityToSetOfAcceptConstraintsByURI.add(acceptConstraintsByURI);
                    DefaultCrossSiteConstraintContext acceptConstraint = new DefaultCrossSiteConstraintContext(allowOrigin, allowMethods, allowHeaders, maximumAge);
                    CrossSiteConstraintContext oldAcceptConstraint = acceptConstraints.put(allowOrigin, acceptConstraint);
                    if (oldAcceptConstraint == null) continue;
                    throw new IllegalArgumentException("Duplicate cross-site-constraint for service " + acceptURI + " with allow-origin " + allowOrigin);
                }
                if (wildcardOriginCount > 0 && crossSiteConstraints.length > 1) {
                    throw new IllegalArgumentException("Conflicting cross site constraints specified for service \"" + acceptURI + "\". Remove the wildcard to specify more restrictive cross site constraints");
                }
                String host = acceptURI.getHost();
                if (host == null || host.isEmpty()) {
                    throw new IllegalArgumentException("Host is required for service \"" + acceptURI + "\".");
                }
                if (!requireRolesCollection.contains("*") || requireRolesCollection.size() <= 1) continue;
                throw new IllegalArgumentException("Conflicting security constraints specified for service \"" + acceptURI + "\". Remove the wildcard to specify restricted roles");
            }
            RealmContext serviceRealmContext = null;
            String realmName = serviceConfig.getRealmName();
            if (serviceConfig.isSetRealmName() && (serviceRealmContext = realmsContext.getRealmContext(realmName)) == null) {
                throw new IllegalArgumentException("Unrecognized realm name \"" + realmName + "\".");
            }
            ServiceAcceptOptionsType acceptOptions = serviceConfig.getAcceptOptions();
            ServiceAcceptOptionsType defaultOptionsConfig = defaultServiceConfig != null ? defaultServiceConfig.getAcceptOptions() : null;
            DefaultAcceptOptionsContext acceptOptionsContext = new DefaultAcceptOptionsContext(acceptOptions, defaultOptionsConfig);
            ServiceConnectOptionsType connectOptions = serviceConfig.getConnectOptions();
            DefaultConnectOptionsContext connectOptionsContext = new DefaultConnectOptionsContext(connectOptions);
            Key encryptionKey = null;
            if (serviceRealmContext == null && requireRolesCollection.size() > 0) {
                throw new IllegalArgumentException("Authorization constraints require a specified realm-name for service \"" + serviceDescription + "\"");
            }
            DefaultServiceContext serviceContext = new DefaultServiceContext(serviceType, serviceName, serviceDescription, serviceInstance, webDir, tempDir, balanceURIs, acceptURIs, connectURIs, properties, requireRoles, mimeMappings, acceptConstraintsByURI, clusterContext, acceptOptionsContext, connectOptionsContext, serviceRealmContext, encryptionKey, schedulerProvider, this.supportsAccepts(serviceType), this.supportsConnects(serviceType), this.supportsMimeMappings(serviceType), InternalSystemProperty.TCP_PROCESSOR_COUNT.getIntProperty(configuration), transportFactory, resourceAddressFactory);
            serviceContexts.add(serviceContext);
            for (URI acceptURI : acceptURIs) {
                String authority = acceptURI.getAuthority();
                if (authority.indexOf(58) == -1) {
                    SchemeConfig schemeConfig = this.supplySchemeConfig(acceptURI.getScheme());
                    authority = authority + ":" + schemeConfig.getDefaultPort();
                    acceptURI = URI.create(acceptURI.getScheme() + "://" + authority + acceptURI.getPath());
                }
                serviceRegistry.register(acceptURI, serviceContext);
            }
        }
        for (ServiceContext ctxt : serviceContexts) {
            ctxt.setListsOfAcceptConstraintsByURI(authorityToSetOfAcceptConstraintsByURI);
        }
        return serviceContexts;
    }

    private DefaultServiceProperties parsePropertiesType(ServicePropertiesType propertiesType) {
        DefaultServiceProperties properties = new DefaultServiceProperties();
        if (propertiesType != null) {
            this.parseProperties(propertiesType.getDomNode(), properties);
        }
        return properties;
    }

    private void parseProperties(Node parent, ServiceProperties properties) {
        NodeList childNodes = parent.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (1 != node.getNodeType()) continue;
            NodeList content = node.getChildNodes();
            String nodeValue = "";
            boolean isSimpleProperty = true;
            for (int j = 0; j < content.getLength(); ++j) {
                String fragment;
                Node child = content.item(j);
                if (child == null) continue;
                if (child.getNodeType() == 1) {
                    isSimpleProperty = false;
                    DefaultServiceProperties newProperties = new DefaultServiceProperties();
                    properties.getNested(node.getLocalName(), true).add(newProperties);
                    this.parseProperties(node, newProperties);
                    break;
                }
                if (child.getNodeType() != 3 || (fragment = child.getNodeValue()) == null) continue;
                nodeValue = nodeValue + fragment;
            }
            if (!isSimpleProperty) continue;
            properties.put(node.getLocalName(), nodeValue);
        }
    }

    private Collection<URI> resolveURIs(String[] acceptURIs) throws URISyntaxException {
        HashSet<URI> urisWithPort = new HashSet<URI>();
        for (String uri : acceptURIs) {
            URI resolvedURI = this.resolveURI(GatewayContextResolver.getCanonicalURI(uri, true));
            urisWithPort.add(resolvedURI);
        }
        return urisWithPort;
    }

    private URI resolveURI(URI uri) throws URISyntaxException {
        String schemeName = uri.getScheme();
        SchemeConfig schemeConfig = this.supplySchemeConfig(schemeName);
        int defaultPort = schemeConfig.getDefaultPort();
        if (uri.getPort() == -1) {
            if (defaultPort == -1) {
                LOGGER.error("Missing port number in URI \"" + uri + "\". You must include an explicit port number in this URI in your gateway configuration file.");
                throw new IllegalArgumentException("Missing port for URI \"" + uri + "\"");
            }
            if (defaultPort != 0) {
                String host = uri.getHost();
                String path = uri.getPath();
                String query = uri.getQuery();
                String fragment = uri.getFragment();
                uri = new URI(schemeName, null, host, defaultPort, path, query, fragment);
            }
        } else if (defaultPort == 0) {
            LOGGER.error("Port number not allowed in URI \"" + uri + "\". You must remove the port number from this URI in your gateway configuration file.");
            throw new IllegalArgumentException("Port not allowed in URI \"" + uri + "\"");
        }
        return uri;
    }

    private ClusterContext resolveCluster(ClusterType clusterConfig, SchedulerProvider schedulerProvider) {
        if (clusterConfig == null) {
            return new StandaloneClusterContext();
        }
        String name = clusterConfig.getName();
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("Invalid name in the cluster configuration");
        }
        name = name.trim();
        final ClusterConnectOptionsType connectOptions = clusterConfig.getConnectOptions();
        ClusterConnectOptionsContext connectOptionsContext = new ClusterConnectOptionsContext(){

            public String getAwsSecretKey() {
                return connectOptions == null ? null : connectOptions.getAwsSecretKey();
            }

            public String getAwsAccessKeyId() {
                return connectOptions == null ? null : connectOptions.getAwsAccessKeyId();
            }
        };
        List<MemberId> accepts = this.processClusterMembers(clusterConfig.getAcceptArray(), "<accept>", null, -1);
        int clusterPort = accepts.size() > 0 ? accepts.get(0).getPort() : -1;
        List<MemberId> connects = this.processClusterMembers(clusterConfig.getConnectArray(), "<connect>", connectOptions, clusterPort);
        return new DefaultClusterContext(clusterConfig.getName(), accepts, connects, schedulerProvider, connectOptionsContext);
    }

    private List<MemberId> processClusterMembers(String[] collection, String processing, ClusterConnectOptionsType connectOptions, int clusterPort) {
        ArrayList<MemberId> memberIds = new ArrayList<MemberId>();
        if (collection != null) {
            for (String member : collection) {
                String host;
                int port;
                URI uri;
                try {
                    uri = GatewayContextResolver.getCanonicalURI(member, true);
                }
                catch (IllegalArgumentException ex) {
                    GL.error((String)"ha", (String)"Unrecognized {} url {} resulted in exception {}", (Object[])new Object[]{processing, member, ex});
                    throw new IllegalArgumentException("Invalid URL in the cluster configuration:" + member, ex);
                }
                String scheme = uri.getScheme();
                if (scheme.equals("tcp") || scheme.equals("udp") || scheme.equals("aws")) {
                    port = uri.getPort();
                    if (port == -1) {
                        GL.error((String)"ha", (String)"Port number is missing while processing {} for {}", (Object[])new Object[]{processing, member});
                        throw new IllegalArgumentException("Invalid port number specified for " + processing + ": " + member);
                    }
                    host = uri.getHost();
                    if (scheme.equals("aws")) {
                        this.validateAwsClusterDiscovery(uri, connectOptions, processing, clusterPort, collection.length);
                    }
                } else {
                    GL.error((String)"ha", (String)"Unrecognized scheme {} for {} in {}", (Object[])new Object[]{uri.getScheme(), processing, member});
                    throw new IllegalArgumentException("Invalid scheme " + uri.getScheme() + " in the URL for " + processing + " in " + member);
                }
                memberIds.add(new MemberId(scheme, host, port, uri.getPath()));
            }
        }
        return memberIds;
    }

    private void validateAwsClusterDiscovery(URI uri, ClusterConnectOptionsType connectOptions, String processing, int clusterPort, int collectionLength) {
        if (!AwsUtils.isDeployedToAWS() || !processing.equals("<connect>")) {
            GL.error((String)"ha", (String)"Unrecognized scheme {} for {} in {}", (Object[])new Object[]{uri.getScheme(), processing, uri.toString()});
            throw new IllegalStateException("Invalid scheme " + uri.getScheme() + " in the URL for " + processing + " in " + uri.toString());
        }
        if (connectOptions == null) {
            GL.error((String)"ha", (String)"Missing <connect-options> in the <cluster> when using auto-discovery", (Object[])new Object[0]);
            throw new IllegalStateException("Missing <connect-options> in <cluster> when using auto-discovery");
        }
        if (collectionLength > 1) {
            GL.error((String)"ha", (String)"Only one {} element should  be specified in <cluster> for auto-discovery", (Object[])new Object[]{processing});
            throw new IllegalStateException("Only one <connect> tag should be specified in <cluster> for auto-discovery");
        }
        if (clusterPort != uri.getPort()) {
            GL.error((String)"ha", (String)"Mismatch in port numbers {} and {}", (Object[])new Object[]{clusterPort, uri.getPort()});
            throw new IllegalArgumentException("Port numbers on the network interface in <accept> and the member in <connect> do not match");
        }
        String scheme = uri.getScheme();
        if (!scheme.equalsIgnoreCase("aws")) {
            throw new IllegalStateException("Invalid scheme '" + scheme + "' specified in the URI " + uri.toString() + " instead of 'aws:'");
        }
        String host = uri.getHost();
        if (!host.equalsIgnoreCase("security-group")) {
            throw new IllegalStateException("Invalid host '" + host + "' specified in the URI " + uri.toString() + " instead of 'security-group'");
        }
        String accessKeyId = connectOptions.getAwsAccessKeyId();
        String secretKey = connectOptions.getAwsSecretKey();
        if (accessKeyId == null) {
            GL.error((String)"ha", (String)"Missing <aws.access-key-id> element in <connect-options>", (Object[])new Object[0]);
            throw new IllegalStateException("Missing <aws.access-key-id> element in the <connect-options>");
        }
        if (secretKey == null) {
            GL.error((String)"ha", (String)"Missing <aws.secret-key> element in <connect-options>", (Object[])new Object[0]);
            throw new IllegalStateException("Missing <aws.secret-key> element in the <connect-options>");
        }
    }

    private RealmsContext resolveRealms(SecurityType securityConfig, SecurityContext securityContext, Properties configuration) {
        HashMap<String, DefaultRealmContext> realmContexts = new HashMap<String, DefaultRealmContext>();
        if (securityConfig != null) {
            for (RealmType realmConfig : securityConfig.getRealmArray()) {
                String name = realmConfig.getName();
                if (realmContexts.get(name) != null) {
                    throw new RuntimeException(String.format("Found %s duplicate <realm> elements in <security> element", name));
                }
                String description = realmConfig.getDescription();
                String[] userPrincipalClasses = realmConfig.getUserPrincipalClassArray();
                AuthenticationType authType = realmConfig.getAuthentication();
                DefaultAuthenticationContext authenticationContext = null;
                if (authType != null) {
                    authenticationContext = new DefaultAuthenticationContext(authType.getHttpChallengeScheme().toString(), authType.getHttpHeaderArray(), authType.getHttpQueryParameterArray(), authType.getHttpCookieArray(), this.resolveAuthorizationMode(authType.getAuthorizationMode()), authType.getSessionTimeout());
                }
                LoginModuleType[] loginModulesArray = authType == null ? new LoginModuleType[]{} : (authType.isSetLoginModules() ? authType.getLoginModules().getLoginModuleArray() : new LoginModuleType[]{});
                LinkedList<AppConfigurationEntry> configurationEntries = new LinkedList<AppConfigurationEntry>();
                for (LoginModuleType loginModule : loginModulesArray) {
                    String className;
                    AppConfigurationEntry.LoginModuleControlFlag controlFlag;
                    String type = loginModule.getType();
                    String success = loginModule.getSuccess().toString();
                    HashMap<String, String> options = new HashMap<String, String>();
                    options.put("GATEWAY_CONFIG_DIRECTORY", configuration.getProperty("GATEWAY_CONFIG_DIRECTORY"));
                    LoginModuleOptionsType rawOptions = loginModule.getOptions();
                    if (rawOptions != null) {
                        NodeList childNodes = rawOptions.getDomNode().getChildNodes();
                        for (int i = 0; i < childNodes.getLength(); ++i) {
                            Node node = childNodes.item(i);
                            if (1 != node.getNodeType()) continue;
                            NodeList content = node.getChildNodes();
                            options.put(node.getLocalName(), content.item(0).getNodeValue());
                        }
                    }
                    if ((controlFlag = this.loginModuleControlFlags.get(success)) == null) {
                        throw new IllegalArgumentException("Unrecognized login module type: " + type);
                    }
                    if (type.startsWith("class:")) {
                        className = type.substring("class:".length());
                        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                        try {
                            classLoader.loadClass(className);
                        }
                        catch (ClassNotFoundException e) {
                            throw new IllegalArgumentException("Unable to find the login module class: " + className, e);
                        }
                        configurationEntries.add(new AppConfigurationEntry(className, controlFlag, options));
                        continue;
                    }
                    className = this.getLoginModuleClass(type);
                    if (className == null) {
                        throw new IllegalArgumentException("Unrecognized login module type: " + type);
                    }
                    configurationEntries.add(new AppConfigurationEntry(className, controlFlag, options));
                }
                this.updateLoginModuleConfigurationEntries(securityConfig, authType, authenticationContext, configurationEntries, configuration);
                realmContexts.put(name, new DefaultRealmContext(name, description, userPrincipalClasses, new SingletonConfiguration(name, configurationEntries), authenticationContext));
            }
        }
        return new DefaultRealmsContext(Collections.unmodifiableMap(realmContexts));
    }

    private void updateLoginModuleConfigurationEntries(SecurityType securityConfig, AuthenticationType authType, AuthenticationContext authenticationContext, List<AppConfigurationEntry> configurationEntries, Properties gatewayProperties) {
        boolean authenticationContextIsPresent;
        boolean bl = authenticationContextIsPresent = authenticationContext != null;
        if (authenticationContextIsPresent) {
            HashMap<String, String> options;
            String httpChallengeScheme = authenticationContext.getHttpChallengeScheme();
            if (httpChallengeScheme.startsWith(AUTH_SCHEME_APPLICATION_PREFIX)) {
                httpChallengeScheme = httpChallengeScheme.substring(AUTH_SCHEME_APPLICATION_PREFIX.length());
            }
            if (AUTH_SCHEME_BASIC.equals(httpChallengeScheme)) {
                options = new HashMap<String, String>();
                options.put("tryFirstToken", "true");
                configurationEntries.add(0, new AppConfigurationEntry(BasicLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL, options));
            }
            if (AUTH_SCHEME_NEGOTIATE.equals(httpChallengeScheme)) {
                options = new HashMap();
                options.put("tryFirstToken", "true");
                configurationEntries.add(0, new AppConfigurationEntry(NegotiateLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL, options));
            }
            if (authType.isSetSessionTimeout()) {
                options = new HashMap();
                if (authType.isSetSessionTimeout()) {
                    options.put("session-timeout", this.resolveTimeIntervalValue(authType.getSessionTimeout()));
                }
                configurationEntries.add(0, new AppConfigurationEntry(TimeoutLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL, options));
            }
        }
    }

    private String resolveTimeIntervalValue(String value) {
        long l = Utils.parseTimeInterval((String)value, (TimeUnit)TimeUnit.SECONDS, (long)0L);
        if (l == 0L) {
            return null;
        }
        return String.valueOf(l);
    }

    private String resolveAuthorizationMode(AuthenticationType.AuthorizationMode.Enum authorizationMode) {
        if (authorizationMode == null) {
            return AUTHORIZATION_MODE_CHALLENGE;
        }
        return authorizationMode.toString();
    }

    private Map<String, Object> resolveDependencyContext() {
        HashMap<String, Object> dependencyContextMap = new HashMap<String, Object>();
        ServiceLoader<DependencyContext> dependencyContextLoader = ServiceLoader.load(DependencyContext.class);
        for (DependencyContext context : dependencyContextLoader) {
            dependencyContextMap.put(context.getName(), context);
        }
        return dependencyContextMap;
    }

    private String getLoginModuleClass(String loginModuleType) {
        String loginModuleClassName = this.loginModuleClassNames.get(loginModuleType);
        if (loginModuleClassName == null) {
            loginModuleClassName = this.findLoginModuleClass(loginModuleType);
            this.loginModuleClassNames.put(loginModuleType, loginModuleClassName);
        }
        return loginModuleClassName;
    }

    private String findLoginModuleClass(String loginModuleType) {
        String packageName = Gateway.class.getPackage().getName();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL resource = classLoader.getResource("META-INF/services/" + packageName.replace('.', '/') + "/loginModule/" + loginModuleType);
        if (resource == null) {
            throw new IllegalArgumentException("Unrecognized login module type: " + loginModuleType);
        }
        try {
            Properties properties = new Properties();
            properties.load(resource.openStream());
            String className = properties.getProperty("class");
            if (className != null) {
                return className;
            }
            throw new IllegalArgumentException("Unrecognized login module type: " + loginModuleType);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unrecognized login module type: " + loginModuleType, e);
        }
    }

    private DefaultSchemeConfig findSchemeConfig(String schemeName) {
        String packageName = Gateway.class.getPackage().getName();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL resource = classLoader.getResource("META-INF/services/" + packageName.replace('.', '/') + "/scheme/" + schemeName);
        if (resource != null) {
            try {
                Properties properties = new Properties();
                properties.load(resource.openStream());
                String transportName = properties.getProperty("transport");
                String defaultPort = properties.getProperty("port");
                DefaultSchemeConfig schemeConfig = new DefaultSchemeConfig();
                schemeConfig.setName(schemeName);
                schemeConfig.setTransportName(transportName);
                if (defaultPort != null) {
                    schemeConfig.setDefaultPort(Integer.parseInt(defaultPort));
                }
                return schemeConfig;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private Map<String, DefaultTransportContext> resolveTransports(TransportFactory transportFactory) throws Exception {
        for (String transportName : transportFactory.getTransportNames()) {
            Transport transport = transportFactory.getTransport(transportName);
            DefaultTransportContext transportContext = new DefaultTransportContext(transportName, transport.getAcceptor(), transport.getConnector());
            this.transportContextsByName.put(transportName, transportContext);
        }
        return this.transportContextsByName;
    }

    private boolean supportsAccepts(String serviceType) {
        return !serviceType.equals("management.jmx") && !serviceType.equals("$management.jmx$");
    }

    private boolean supportsConnects(String serviceType) {
        return !serviceType.equals("jms") && !serviceType.equals("echo") && !serviceType.equals("management.jmx") && !serviceType.equals("$management.jmx$") && !serviceType.equals("management.snmp") && !serviceType.equals("$management.snmp$") && !serviceType.equals("directory");
    }

    private boolean supportsMimeMappings(String serviceType) {
        return serviceType.equals("directory");
    }

    private void injectResources(Collection<ServiceContext> services, BridgeServiceFactory bridgeServiceFactory, Map<String, Object> dependencyContexts, Map<String, Object> injectables) {
        for (DefaultTransportContext transport : this.transportContextsByName.values()) {
            BridgeConnector connector;
            BridgeAcceptor acceptor = transport.getAcceptor();
            if (acceptor != null) {
                injectables.put(transport.getName() + ".acceptor", acceptor);
            }
            if ((connector = transport.getConnector()) == null) continue;
            injectables.put(transport.getName() + ".connector", connector);
        }
        for (DefaultTransportContext transport : this.transportContextsByName.values()) {
            this.injectResources(transport.getAcceptor(), injectables);
            this.injectResources(transport.getConnector(), injectables);
        }
        for (ServiceContext serviceContext : services) {
            this.injectResources(serviceContext.getService(), injectables);
        }
        this.injectResources(bridgeServiceFactory, injectables);
        for (Object obj : dependencyContexts.values()) {
            this.injectResources(obj, injectables);
        }
    }

    private void injectResources(Object target, Map<String, Object> values) {
        if (target == null) {
            return;
        }
        Class<?> clazz = target.getClass();
        for (Method method : clazz.getMethods()) {
            Resource resource = method.getAnnotation(Resource.class);
            if (resource == null) continue;
            String name = resource.name();
            Object val = values.get(name);
            try {
                method.invoke(target, val);
            }
            catch (Exception e) {
                LOGGER.warn("Error while injecting named " + name + " resource", (Throwable)e);
            }
        }
    }

    public static URI getCanonicalURI(String uriString, boolean canonicalizePath) {
        if (uriString != null && !"".equals(uriString)) {
            return GatewayContextResolver.getCanonicalURI(URI.create(uriString), canonicalizePath);
        }
        return null;
    }

    public static URI getCanonicalURI(URI uri, boolean canonicalizePath) {
        URI canonicalURI = uri;
        if (uri != null) {
            String newPath;
            boolean trailingSlashWithPathlessScheme;
            String host = uri.getHost();
            String path = uri.getPath();
            boolean emptyPath = "".equals(path);
            boolean noPathToCanonicalize = canonicalizePath && (path == null || emptyPath);
            boolean trailingSlashPath = "/".equals(path);
            String scheme = uri.getScheme();
            boolean pathlessScheme = "ssl".equals(scheme) || "tcp".equals(scheme) || "pipe".equals(scheme) || "udp".equals(scheme);
            boolean bl = trailingSlashWithPathlessScheme = trailingSlashPath && pathlessScheme;
            Object object = trailingSlashWithPathlessScheme ? "" : (noPathToCanonicalize ? (pathlessScheme ? null : "/") : (newPath = null));
            if (host != null && !host.equals(host.toLowerCase()) || newPath != null) {
                path = newPath == null ? path : newPath;
                try {
                    canonicalURI = new URI(scheme, uri.getUserInfo(), host == null ? null : host.toLowerCase(), uri.getPort(), path, uri.getQuery(), uri.getFragment());
                }
                catch (URISyntaxException ex) {
                    throw new IllegalArgumentException("Invalid URI: " + uri + " in Gateway configuration file", ex);
                }
            }
        }
        return canonicalURI;
    }

    static {
        defaultMimeMappings.put("html", "text/html");
        defaultMimeMappings.put("htm", "text/html");
        defaultMimeMappings.put("js", "text/javascript");
        defaultMimeMappings.put("png", "image/png");
        defaultMimeMappings.put("gif", "image/gif");
        defaultMimeMappings.put("jpg", "image/jpeg");
        defaultMimeMappings.put("jpeg", "image/jpeg");
        defaultMimeMappings.put("css", "text/css");
        defaultMimeMappings.put("swf", "application/x-shockwave-flash");
        defaultMimeMappings.put("xap", "application/x-silverlight-app");
        defaultMimeMappings.put("htc", "text/x-component");
        defaultMimeMappings.put("jnlp", "application/x-java-jnlp-file");
        defaultMimeMappings.put("manifest", "text/cache-manifest");
        defaultMimeMappings.put("appcache", "text/cache-manifest");
        defaultMimeMappings.put("vtt", "text/vtt");
        defaultMimeMappings.put("aspx", "text/html");
    }

    private static class SingletonConfiguration
    extends Configuration {
        private final Map<String, AppConfigurationEntry[]> configurationEntries;

        public SingletonConfiguration(String applicationName, Collection<AppConfigurationEntry> configurationEntries) {
            AppConfigurationEntry[] array = new AppConfigurationEntry[configurationEntries.size()];
            this.configurationEntries = Collections.singletonMap(applicationName, configurationEntries.toArray(array));
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String configName) {
            return this.configurationEntries.get(configName);
        }

        public void setAppConfigurationEntry(String configName, AppConfigurationEntry[] entry) {
            this.configurationEntries.put(configName, entry);
        }
    }

    static enum HttpMethod {
        OPTIONS,
        GET,
        HEAD,
        POST,
        PUT,
        DELETE,
        TRACE,
        CONNECT;

    }
}

