/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.test.config;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.kaazing.gateway.server.test.config.Suppressible;
import org.kaazing.gateway.server.test.config.SuppressibleConfiguration;

public class Suppressibles {
    public static <K, V> Map<K, V> unsuppressibleMap(Map<K, Suppressible<V>> suppressibleMap) {
        return new UnsuppressibleMap(suppressibleMap);
    }

    public static <E> Set<E> unsuppressibleSet(Set<Suppressible<E>> suppressibleCollection) {
        return new UnsuppressibleSet(suppressibleCollection);
    }

    public static <E> Collection<E> unsuppressibleCollection(Collection<Suppressible<E>> suppressibleCollection) {
        return new UnsuppressibleCollection(suppressibleCollection);
    }

    public static <K, V> Map.Entry<K, V> unsuppressibleEntry(Map.Entry<K, Suppressible<V>> suppressibleEntry) {
        return new UnsuppressibleEntry(suppressibleEntry);
    }

    public static <E> Iterator<E> unsuppressibleIterator(Iterator<Suppressible<E>> suppressibleIterator) {
        return new UnsuppressibleIterator(suppressibleIterator);
    }

    public static Set<SuppressibleConfiguration.Suppression> getDefaultSuppressions() {
        return EnumSet.of(SuppressibleConfiguration.Suppression.NONE);
    }

    public static <E> List<E> unsuppressibleList(List<Suppressible<E>> suppressibleList) {
        return new UnsuppressibleList(suppressibleList);
    }

    public static <E> ListIterator<E> unsuppressibleListIterator(ListIterator<Suppressible<E>> suppressibleIterator) {
        return new UnsuppressibleListIterator(suppressibleIterator);
    }

    private Suppressibles() {
    }

    private static class UnsuppressibleCollection<E>
    implements Collection<E> {
        private final Collection<Suppressible<E>> suppressible;

        private UnsuppressibleCollection(Collection<Suppressible<E>> suppressible) {
            this.suppressible = suppressible;
        }

        @Override
        public int size() {
            return this.suppressible.size();
        }

        @Override
        public boolean isEmpty() {
            return this.suppressible.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            for (Suppressible<E> suppressedEntry : this.suppressible) {
                if (!suppressedEntry.value().equals(o)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Iterator<E> iterator() {
            return Suppressibles.unsuppressibleIterator(this.suppressible.iterator());
        }

        @Override
        public Object[] toArray() {
            ArrayList<E> result = new ArrayList<E>();
            for (Suppressible<E> suppressedEntry : this.suppressible) {
                result.add(suppressedEntry.value());
            }
            return result.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            if (a.length < this.size()) {
                Object[] b = (Object[])Array.newInstance(a.getClass(), this.size());
                Iterator<Suppressible<E>> iter = this.suppressible.iterator();
                int i = 0;
                while (iter.hasNext()) {
                    b[i++] = iter.next();
                }
                return b;
            }
            Iterator<Suppressible<E>> iter = this.suppressible.iterator();
            while (iter.hasNext()) {
                int i = 0;
                a[i++] = iter.next();
            }
            return a;
        }

        @Override
        public boolean add(E e) {
            return this.suppressible.add(new Suppressible<E>(e, new SuppressibleConfiguration.Suppression[0]));
        }

        @Override
        public boolean remove(Object o) {
            for (Suppressible<E> suppressedEntry : this.suppressible) {
                if (!suppressedEntry.value().equals(o)) continue;
                return this.suppressible.remove(this.suppressible);
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (Suppressible<E> suppressedEntry : this.suppressible) {
                if (c.contains(suppressedEntry.value())) continue;
                return false;
            }
            return false;
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            boolean result = false;
            for (E e : c) {
                result |= this.add(e);
            }
            return result;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean result = false;
            for (Object e : c) {
                result |= this.remove(e);
            }
            return result;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            boolean result = false;
            for (Suppressible<E> suppressedEntry : this.suppressible) {
                if (c.contains(suppressedEntry.value())) continue;
                result |= this.suppressible.remove(suppressedEntry);
            }
            return result;
        }

        @Override
        public void clear() {
            this.suppressible.clear();
        }
    }

    private static class UnsuppressibleList<E>
    implements List<E> {
        private final List<Suppressible<E>> suppressible;
        private Collection<E> collectionCache;

        private UnsuppressibleList(List<Suppressible<E>> suppressible) {
            this.suppressible = suppressible;
        }

        private Collection<E> getCollectionCache() {
            if (this.collectionCache == null) {
                this.collectionCache = Suppressibles.unsuppressibleCollection(this.suppressible);
            }
            return this.collectionCache;
        }

        @Override
        public int size() {
            return this.suppressible.size();
        }

        @Override
        public boolean isEmpty() {
            return this.suppressible.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.getCollectionCache().contains(o);
        }

        @Override
        public Iterator<E> iterator() {
            return this.getCollectionCache().iterator();
        }

        @Override
        public Object[] toArray() {
            return this.getCollectionCache().toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.getCollectionCache().toArray(a);
        }

        @Override
        public boolean add(E e) {
            return this.suppressible.add(new Suppressible<E>(e, SuppressibleConfiguration.Suppression.NONE));
        }

        @Override
        public boolean remove(Object o) {
            return this.getCollectionCache().remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.getCollectionCache().containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            boolean result = false;
            for (E e : c) {
                result |= this.add(e);
            }
            return result;
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            int i;
            Iterator<E> iter = c.iterator();
            for (i = 0; i < c.size(); ++i) {
                this.add(index + i, iter.next());
            }
            return i > 0;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.getCollectionCache().removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.getCollectionCache().retainAll(c);
        }

        @Override
        public void clear() {
            this.suppressible.clear();
        }

        @Override
        public E get(int index) {
            return this.suppressible.get(index).value();
        }

        @Override
        public E set(int index, E element) {
            return this.suppressible.set(index, new Suppressible<E>(element, SuppressibleConfiguration.Suppression.NONE)).value();
        }

        @Override
        public void add(int index, E element) {
            this.suppressible.add(index, new Suppressible<E>(element, SuppressibleConfiguration.Suppression.NONE));
        }

        @Override
        public E remove(int index) {
            Suppressible<E> remove = this.suppressible.remove(index);
            if (remove == null) {
                return null;
            }
            return remove.value();
        }

        @Override
        public int indexOf(Object o) {
            for (int i = 0; i < this.suppressible.size(); ++i) {
                if (!this.suppressible.get(i).value().equals(o)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            int last = -1;
            for (int i = 0; i < this.suppressible.size(); ++i) {
                if (!this.suppressible.get(i).value().equals(o)) continue;
                last = i;
            }
            return last;
        }

        @Override
        public ListIterator<E> listIterator() {
            return Suppressibles.unsuppressibleListIterator(this.suppressible.listIterator());
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            return Suppressibles.unsuppressibleListIterator(this.suppressible.listIterator(index));
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            return Suppressibles.unsuppressibleList(this.suppressible.subList(fromIndex, toIndex));
        }
    }

    private static class UnsuppressibleIterator<E>
    implements Iterator<E> {
        private final Iterator<Suppressible<E>> suppressible;

        private UnsuppressibleIterator(Iterator<Suppressible<E>> suppressible) {
            this.suppressible = suppressible;
        }

        @Override
        public boolean hasNext() {
            return this.suppressible.hasNext();
        }

        @Override
        public E next() {
            Suppressible<E> next = this.suppressible.next();
            if (next == null) {
                return null;
            }
            return next.value();
        }

        @Override
        public void remove() {
            this.suppressible.remove();
        }
    }

    private static class UnsuppressibleListIterator<E>
    implements ListIterator<E> {
        private ListIterator<Suppressible<E>> suppressible;

        private UnsuppressibleListIterator(ListIterator<Suppressible<E>> suppressiblelistIterator) {
            this.suppressible = suppressiblelistIterator;
        }

        @Override
        public boolean hasNext() {
            return this.suppressible.hasNext();
        }

        @Override
        public E next() {
            Suppressible<E> next = this.suppressible.next();
            if (next == null) {
                return null;
            }
            return next.value();
        }

        @Override
        public boolean hasPrevious() {
            return this.suppressible.hasPrevious();
        }

        @Override
        public E previous() {
            Suppressible<E> previous = this.suppressible.previous();
            if (previous == null) {
                return null;
            }
            return previous.value();
        }

        @Override
        public int nextIndex() {
            return this.suppressible.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.suppressible.previousIndex();
        }

        @Override
        public void remove() {
            this.suppressible.remove();
        }

        @Override
        public void set(E e) {
            this.suppressible.set(new Suppressible<E>(e, SuppressibleConfiguration.Suppression.NONE));
        }

        @Override
        public void add(E e) {
            this.suppressible.add(new Suppressible<E>(e, SuppressibleConfiguration.Suppression.NONE));
        }
    }

    private static class UnsuppressibleSet<E>
    implements Set<E> {
        private final Set<Suppressible<E>> suppressible;
        private Collection<E> collectionCache;

        private UnsuppressibleSet(Set<Suppressible<E>> suppressible) {
            this.suppressible = suppressible;
        }

        private Collection<E> getCollectionCache() {
            if (this.collectionCache == null) {
                this.collectionCache = Suppressibles.unsuppressibleCollection(this.suppressible);
            }
            return this.collectionCache;
        }

        @Override
        public int size() {
            return this.suppressible.size();
        }

        @Override
        public boolean isEmpty() {
            return this.suppressible.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.getCollectionCache().contains(o);
        }

        @Override
        public Iterator<E> iterator() {
            return this.getCollectionCache().iterator();
        }

        @Override
        public Object[] toArray() {
            return this.getCollectionCache().toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.getCollectionCache().toArray(a);
        }

        @Override
        public boolean add(E e) {
            return this.suppressible.add(new Suppressible<E>(e, new SuppressibleConfiguration.Suppression[0]));
        }

        @Override
        public boolean remove(Object o) {
            return this.getCollectionCache().remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.getCollectionCache().containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            boolean result = false;
            for (E value : c) {
                result |= this.add(value);
            }
            return result;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.getCollectionCache().retainAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.getCollectionCache().removeAll(c);
        }

        @Override
        public void clear() {
            this.suppressible.clear();
        }
    }

    private static class DelegatingEntrySet<E extends Map.Entry<K, V>, K, V>
    implements Set<E> {
        private Set<Map.Entry<K, Suppressible<V>>> entrySet;

        public DelegatingEntrySet(Set<Map.Entry<K, Suppressible<V>>> entrySet) {
            this.entrySet = entrySet;
        }

        @Override
        public int size() {
            return this.entrySet.size();
        }

        @Override
        public boolean isEmpty() {
            return this.entrySet.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            if (!this.isEntryOfSametype(o)) {
                return false;
            }
            Map.Entry comparedTo = (Map.Entry)o;
            for (Map.Entry<K, Suppressible<V>> entry : this.entrySet) {
                if (!entry.getKey().equals(comparedTo.getKey()) || !Suppressibles.unsuppressibleEntry(entry).getValue().equals(comparedTo.getValue())) continue;
                return true;
            }
            return false;
        }

        @Override
        public Iterator<E> iterator() {
            return new DelegatingEntryIterator(this.entrySet.iterator());
        }

        @Override
        public Object[] toArray() {
            ArrayList<Map.Entry<K, V>> result = new ArrayList<Map.Entry<K, V>>();
            for (Map.Entry<K, Suppressible<V>> entry : this.entrySet) {
                result.add(Suppressibles.unsuppressibleEntry(entry));
            }
            return result.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            ArrayList<Map.Entry<K, V>> result = new ArrayList<Map.Entry<K, V>>();
            for (Map.Entry<K, Suppressible<V>> entry : this.entrySet) {
                result.add(Suppressibles.unsuppressibleEntry(entry));
            }
            return result.toArray(a);
        }

        @Override
        public boolean add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            if (this.isEntrySetOfSametype(c)) {
                Set comparedTo = (Set)c;
                for (Map.Entry entry : comparedTo) {
                    if (this.contains(entry)) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            this.entrySet.clear();
        }

        private boolean isEntryOfSametype(Object o) {
            if (!o.getClass().isInstance(Map.Entry.class)) {
                return false;
            }
            try {
                Map.Entry comparedTo = (Map.Entry)o;
            }
            catch (Exception e) {
                throw new ClassCastException();
            }
            return true;
        }

        private boolean isEntrySetOfSametype(Object o) {
            if (!o.getClass().isInstance(Set.class)) {
                return false;
            }
            try {
                Set comparedTo = (Set)o;
            }
            catch (Exception e) {
                throw new ClassCastException();
            }
            return true;
        }
    }

    private static class DelegatingEntryIterator<E extends Map.Entry<K, V>, K, V>
    implements Iterator<E> {
        private Iterator<Map.Entry<K, Suppressible<V>>> suppressible;

        public DelegatingEntryIterator(Iterator<Map.Entry<K, Suppressible<V>>> iterator) {
            this.suppressible = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.suppressible.hasNext();
        }

        @Override
        public E next() {
            return (E)Suppressibles.unsuppressibleEntry(this.suppressible.next());
        }

        @Override
        public void remove() {
            this.suppressible.remove();
        }
    }

    private static class UnsuppressibleMap<K, V>
    implements Map<K, V> {
        private final Map<K, Suppressible<V>> suppressible;
        private Collection<V> collectionValueCache = null;

        private UnsuppressibleMap(Map<K, Suppressible<V>> suppressible) {
            this.suppressible = suppressible;
        }

        @Override
        public int size() {
            return this.suppressible.size();
        }

        @Override
        public boolean isEmpty() {
            return this.suppressible.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.suppressible.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            if (this.collectionValueCache == null) {
                this.collectionValueCache = Suppressibles.unsuppressibleCollection(this.suppressible.values());
            }
            return this.collectionValueCache.contains(value);
        }

        @Override
        public V get(Object key) {
            Suppressible<V> value = this.suppressible.get(key);
            if (value == null) {
                return null;
            }
            return value.value();
        }

        @Override
        public V put(K key, V value) {
            Suppressible<V> returnValue = this.suppressible.put(key, new Suppressible<V>(value, new SuppressibleConfiguration.Suppression[0]));
            if (returnValue == null) {
                return null;
            }
            return returnValue.value();
        }

        @Override
        public V remove(Object key) {
            Suppressible<V> remove = this.suppressible.remove(key);
            if (remove == null) {
                return null;
            }
            return remove.value();
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            for (Map.Entry<K, V> entry : m.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public void clear() {
            this.suppressible.clear();
        }

        @Override
        public Set<K> keySet() {
            return this.suppressible.keySet();
        }

        @Override
        public Collection<V> values() {
            if (this.collectionValueCache == null) {
                this.collectionValueCache = Suppressibles.unsuppressibleCollection(this.suppressible.values());
            }
            return this.collectionValueCache;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new DelegatingEntrySet(this.suppressible.entrySet());
        }
    }

    private static class UnsuppressibleEntry<K, V>
    implements Map.Entry<K, V> {
        private Map.Entry<K, Suppressible<V>> suppressible;

        private UnsuppressibleEntry(Map.Entry<K, Suppressible<V>> suppressible) {
            this.suppressible = suppressible;
        }

        @Override
        public K getKey() {
            return this.suppressible.getKey();
        }

        @Override
        public V getValue() {
            Suppressible<V> value = this.suppressible.getValue();
            if (value == null) {
                return null;
            }
            return value.value();
        }

        @Override
        public V setValue(V value) {
            this.suppressible.setValue(new Suppressible<V>(value, new SuppressibleConfiguration.Suppression[0]));
            return this.getValue();
        }
    }
}

