/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public final class VersionUtils {
    public static String PRODUCT_TITLE = null;
    public static String PRODUCT_VERSION = null;
    public static String PRODUCT_EDITION = null;
    public static String PRODUCT_DEPENDENCIES = null;

    public static String getGatewayProductTitle() {
        VersionUtils.getGatewayProductInfo();
        return PRODUCT_TITLE;
    }

    public static String getGatewayProductVersion() {
        VersionUtils.getGatewayProductInfo();
        return PRODUCT_VERSION;
    }

    public static String getGatewayProductVersionMajor() {
        String v = VersionUtils.getGatewayProductVersion();
        if (v == null) {
            return null;
        }
        int dotPos = v.indexOf(".");
        return dotPos < 0 ? v : v.substring(0, dotPos);
    }

    public static String getGatewayProductVersionMinor() {
        String v = VersionUtils.getGatewayProductVersion();
        if (v == null || v.length() == 0) {
            return null;
        }
        int dotPos = v.indexOf(".");
        if (dotPos < 0) {
            return v + ".0";
        }
        return (dotPos = v.indexOf(".", dotPos + 1)) < 0 ? v : v.substring(0, dotPos);
    }

    public static String getGatewayProductVersionPatch() {
        String v = VersionUtils.getGatewayProductVersion();
        if (v == null || v.length() == 0) {
            return null;
        }
        int dotPos = v.indexOf(".");
        if (dotPos < 0) {
            return v + ".0.0";
        }
        if ((dotPos = v.indexOf(".", dotPos + 1)) < 0) {
            return v + ".0";
        }
        return (dotPos = v.indexOf(".", dotPos + 1)) < 0 ? v : v.substring(0, dotPos);
    }

    public static String getGatewayProductVersionBuild() {
        String v = VersionUtils.getGatewayProductVersion();
        if (v == null || v.length() == 0) {
            return null;
        }
        int dotPos = v.indexOf(".");
        if (dotPos < 0) {
            return v + ".0.0.0";
        }
        if ((dotPos = v.indexOf(".", dotPos + 1)) < 0) {
            return v + ".0.0";
        }
        if ((dotPos = v.indexOf(".", dotPos + 1)) < 0) {
            return v + ".0";
        }
        return v;
    }

    public static String getGatewayProductEdition() {
        VersionUtils.getGatewayProductInfo();
        return PRODUCT_EDITION;
    }

    public static String getGatewayProductDependencies() {
        VersionUtils.getGatewayProductInfo();
        return PRODUCT_DEPENDENCIES;
    }

    private static final void getGatewayProductInfo() {
        if (PRODUCT_TITLE != null) {
            return;
        }
        boolean foundJar = false;
        String[] pathEntries = System.getProperty("java.class.path").split(System.getProperty("path.separator"));
        HashMap<String, Attributes> products = new HashMap<String, Attributes>(7);
        HashSet<String> removals = new HashSet<String>(7);
        for (String pathEntry : pathEntries) {
            if (!pathEntry.contains("distribution.version")) continue;
            try {
                String[] deps;
                JarFile jar = new JarFile(pathEntry);
                Manifest mf = jar.getManifest();
                Attributes attrs = mf.getMainAttributes();
                if (attrs == null) continue;
                String title = attrs.getValue("Implementation-Title");
                String version = attrs.getValue("Implementation-Version");
                String product = attrs.getValue("Kaazing-Product");
                String dependencies = attrs.getValue("Kaazing-Dependencies");
                if (title == null || version == null) continue;
                foundJar = true;
                products.put(product != null ? product : title, attrs);
                if (dependencies == null) continue;
                for (String dep : deps = dependencies.split(",")) {
                    removals.add(dep);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        Iterator it = removals.iterator();
        while (it.hasNext()) {
            products.remove(it.next());
        }
        if (!foundJar || products.size() == 0) {
            PRODUCT_TITLE = "Kaazing WebSocket Gateway (Development)";
            PRODUCT_VERSION = null;
            PRODUCT_EDITION = null;
            PRODUCT_DEPENDENCIES = null;
        } else {
            Attributes attrs = (Attributes)products.values().iterator().next();
            PRODUCT_TITLE = attrs.getValue("Implementation-Title");
            PRODUCT_VERSION = attrs.getValue("Implementation-Version");
            PRODUCT_EDITION = attrs.getValue("Kaazing-Product");
            PRODUCT_DEPENDENCIES = attrs.getValue("Kaazing-Dependencies");
        }
    }
}

