/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.security.auth;

import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.kaazing.gateway.security.auth.config.JaasConfig;
import org.kaazing.gateway.security.auth.config.RoleConfig;
import org.kaazing.gateway.security.auth.config.UserConfig;
import org.kaazing.gateway.security.auth.config.parse.JaasConfigParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLoginModule
implements LoginModule {
    public static final String CLASS_NAME = FileLoginModule.class.getName();
    public static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    private static final String INITIALIZATION_FAILED_MESSAGE = "[FileLoginModule] Initialization failed";
    private static final String AUTHENTICATION_FAILED_MESSAGE = "[FileLoginModule] Authentication failed";
    private static final String FILE_KEY = "file";
    private static final String NAME = "javax.security.auth.login.name";
    private static final String PWD = "javax.security.auth.login.password";
    private static final ConcurrentMap<String, JaasConfig> SHARED_STATE = new ConcurrentHashMap<String, JaasConfig>();
    private State state = State.INITIALIZE_REQUIRED;
    private Subject subject;
    private UserConfig user;
    private Collection<RoleConfig> userRoles;
    private CallbackHandler handler;
    private JaasConfig jaasConfig;
    private Map sharedState;
    private boolean tryFirstPass;
    private boolean debug;
    private String username;
    private char[] password;

    @Override
    public void initialize(Subject subject, CallbackHandler callback, Map<String, ?> sharedState, Map<String, ?> options) {
        JaasConfig jaasConfig;
        this.sharedState = sharedState;
        this.tryFirstPass = "true".equalsIgnoreCase((String)options.get("tryFirstPass"));
        this.debug = "true".equalsIgnoreCase((String)options.get("debug"));
        String jaasFilename = (String)options.get(FILE_KEY);
        if (jaasFilename == null) {
            IllegalArgumentException iae = new IllegalArgumentException(String.format("Missing required option \"%s\" to locate JAAS configuration file", FILE_KEY));
            if (this.debug) {
                LOG.debug(INITIALIZATION_FAILED_MESSAGE, (Throwable)iae);
            }
        }
        if ((jaasConfig = (JaasConfig)SHARED_STATE.get(jaasFilename)) == null) {
            String configDir;
            File jaasFile = new File(jaasFilename);
            if (!jaasFile.isAbsolute() && (configDir = (String)options.get("GATEWAY_CONFIG_DIRECTORY")) != null) {
                jaasFile = new File(configDir, jaasFilename);
            }
            if (jaasFile.exists() && jaasFile.isFile()) {
                try {
                    jaasConfig = new JaasConfigParser().parse(jaasFile.toURI().toURL());
                    SHARED_STATE.put(jaasFilename, jaasConfig);
                }
                catch (Exception e) {
                    if (this.debug) {
                        LOG.debug(INITIALIZATION_FAILED_MESSAGE, (Throwable)e);
                    }
                    throw new IllegalArgumentException(e);
                }
            } else {
                IllegalArgumentException iae = new IllegalArgumentException(String.format("Unable to use \"%s\" for file-based login: File does not exist or is directory", jaasFile));
                if (this.debug) {
                    LOG.debug(INITIALIZATION_FAILED_MESSAGE, (Throwable)iae);
                }
                throw iae;
            }
        }
        this.state = State.INITIALIZE_COMPLETE;
        this.subject = subject;
        this.handler = callback;
        this.jaasConfig = jaasConfig;
    }

    @Override
    public boolean login() throws LoginException {
        switch (this.state) {
            case INITIALIZE_COMPLETE: {
                return this.login0();
            }
            case LOGIN_COMPLETE: {
                return this.login0();
            }
            case COMMIT_COMPLETE: {
                return true;
            }
        }
        throw new LoginException("Login module is not initialized");
    }

    @Override
    public boolean logout() throws LoginException {
        switch (this.state) {
            case COMMIT_COMPLETE: {
                this.logout0();
                return true;
            }
            case INITIALIZE_REQUIRED: {
                throw new LoginException("Login module is not initialized");
            }
        }
        return false;
    }

    @Override
    public boolean commit() throws LoginException {
        switch (this.state) {
            case COMMIT_COMPLETE: {
                return true;
            }
            case INITIALIZE_COMPLETE: {
                this.logout0();
                return false;
            }
            case LOGIN_COMPLETE: {
                this.commit0();
                return true;
            }
        }
        throw new LoginException("Login module is not initialized");
    }

    @Override
    public boolean abort() throws LoginException {
        switch (this.state) {
            case LOGIN_COMPLETE: 
            case COMMIT_COMPLETE: {
                this.logout0();
                return true;
            }
        }
        return false;
    }

    private boolean login0() throws LoginException {
        block6: {
            if (this.tryFirstPass) {
                try {
                    this.attemptAuthenticate(true);
                    return true;
                }
                catch (LoginException le) {
                    this.cleanState();
                    if (!this.debug) break block6;
                    LOG.debug("[FileLoginModule] read from shared state failed", (Throwable)le);
                }
            }
        }
        try {
            this.attemptAuthenticate(false);
            return true;
        }
        catch (LoginException loginException) {
            this.cleanState();
            if (this.debug) {
                LOG.debug("[FileLoginModule] regular authentication failed", (Throwable)loginException);
            }
            throw loginException;
        }
    }

    private void cleanState() {
        this.user = null;
        this.userRoles = null;
        this.username = null;
        if (this.password != null) {
            Arrays.fill(this.password, '\u0000');
        }
        this.password = null;
    }

    private void attemptAuthenticate(boolean useSharedState) throws LoginException {
        this.getUsernamePassword(useSharedState);
        if (this.username == null) {
            LoginException le = new LoginException("Username not found");
            if (this.debug) {
                LOG.debug(AUTHENTICATION_FAILED_MESSAGE, (Throwable)le);
            }
            throw le;
        }
        if (this.password == null) {
            LoginException le = new LoginException("Password not found");
            if (this.debug) {
                LOG.debug(AUTHENTICATION_FAILED_MESSAGE, (Throwable)le);
            }
            throw le;
        }
        Map<String, UserConfig> users = this.jaasConfig.getUsers();
        Map<String, RoleConfig> roles = this.jaasConfig.getRoles();
        this.user = users.get(this.username);
        if (this.user == null) {
            FailedLoginException le = new FailedLoginException(String.format("User '%s' not found", this.username));
            if (this.debug) {
                LOG.debug(AUTHENTICATION_FAILED_MESSAGE, (Throwable)le);
            }
            throw le;
        }
        boolean passwordOK = new String(this.password).equals(this.user.getPassword());
        if (!passwordOK) {
            FailedLoginException le = new FailedLoginException("Wrong password");
            if (this.debug) {
                LOG.debug(AUTHENTICATION_FAILED_MESSAGE, (Throwable)le);
            }
            throw le;
        }
        this.userRoles = new HashSet<RoleConfig>();
        LinkedList<String> roleNames = new LinkedList<String>();
        roleNames.addAll(this.user.getRoleNames());
        while (!roleNames.isEmpty()) {
            String roleName = (String)roleNames.poll();
            RoleConfig role = roles.get(roleName);
            if (role == null) {
                IllegalArgumentException iae = new IllegalArgumentException(String.format("Unrecognized role \"%s\"", roleName));
                if (this.debug) {
                    LOG.debug(AUTHENTICATION_FAILED_MESSAGE, (Throwable)iae);
                }
                this.cleanState();
                throw iae;
            }
            if (!this.userRoles.add(role)) continue;
            roleNames.addAll(role.getRoleNames());
        }
        this.state = State.LOGIN_COMPLETE;
    }

    private void getUsernamePassword(boolean useSharedState) throws LoginException {
        if (useSharedState) {
            this.username = (String)this.sharedState.get(NAME);
            this.password = (char[])this.sharedState.get(PWD);
            return;
        }
        NameCallback nameCB = new NameCallback("username");
        PasswordCallback passwordCB = new PasswordCallback("password", false);
        try {
            this.handler.handle(new Callback[]{nameCB, passwordCB});
        }
        catch (IOException | UnsupportedCallbackException e) {
            if (this.debug) {
                LOG.debug("[FileLoginModule] - Encountered exception while handling name, password callbacks.", (Throwable)e);
            }
            throw (LoginException)new LoginException(e.getMessage()).initCause(e);
        }
        this.username = nameCB.getName();
        this.password = passwordCB.getPassword();
        passwordCB.clearPassword();
    }

    private void logout0() throws LoginException {
        Set<Principal> principals = this.subject.getPrincipals();
        principals.remove(this.user);
        if (this.userRoles != null) {
            principals.removeAll(this.userRoles);
        }
        this.user = null;
        this.userRoles = null;
        this.state = State.INITIALIZE_COMPLETE;
    }

    private void commit0() throws LoginException {
        Set<Principal> principals = this.subject.getPrincipals();
        principals.add(this.user);
        principals.addAll(this.userRoles);
        this.state = State.COMMIT_COMPLETE;
    }

    private static enum State {
        INITIALIZE_REQUIRED,
        INITIALIZE_COMPLETE,
        LOGIN_COMPLETE,
        COMMIT_COMPLETE;

    }
}

