/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.security.auth.context;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.login.Configuration;
import org.kaazing.gateway.security.LoginContextFactory;
import org.kaazing.gateway.security.auth.context.DefaultLoginContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoginContextFactories {
    private static Map<String, LoginContextFactory> CACHE = new ConcurrentHashMap<String, LoginContextFactory>();
    private static Logger LOG = LoggerFactory.getLogger((String)"login.context");

    private LoginContextFactories() {
    }

    public static LoginContextFactory create(String name, Configuration configuration) {
        LoginContextFactory defaultProvider;
        String key = name + (configuration != null ? Integer.valueOf(configuration.hashCode()) : "null");
        if (CACHE.containsKey(key)) {
            defaultProvider = CACHE.get(key);
        } else {
            defaultProvider = new DefaultLoginContextFactory(name, configuration);
            CACHE.put(key, defaultProvider);
        }
        return defaultProvider;
    }

    static Logger getLogger() {
        return LOG;
    }
}

