/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.security.auth;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.kaazing.gateway.security.auth.BaseStateDrivenLoginModule;
import org.kaazing.gateway.security.auth.DispatchCallbackHandler;
import org.kaazing.gateway.security.auth.NegotiateLoginModuleCallbackRegistrar;
import org.kaazing.gateway.server.spi.security.AuthenticationTokenCallback;
import org.kaazing.gateway.util.Encoding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NegotiateLoginModule
extends BaseStateDrivenLoginModule {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    public static final String CLASS_NAME = NegotiateLoginModule.class.getName();
    public static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    private static final String KAAZING_TOKEN_KEY = "org.kaazing.gateway.server.auth.token";
    private static final String KAAZING_GSS_TOKEN_KEY = "org.kaazing.gateway.server.auth.gss.token";
    private boolean debug;
    private boolean tryFirstToken;
    private final NegotiateLoginModuleCallbackRegistrar callbackRegistrar = NegotiateLoginModule.newCallbackRegistrar();

    private static NegotiateLoginModuleCallbackRegistrar newCallbackRegistrar() {
        ServiceLoader<NegotiateLoginModuleCallbackRegistrar> loader = ServiceLoader.load(NegotiateLoginModuleCallbackRegistrar.class);
        Iterator<NegotiateLoginModuleCallbackRegistrar> iterator = loader.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.debug = "true".equalsIgnoreCase((String)options.get("debug"));
        this.tryFirstToken = "true".equalsIgnoreCase((String)options.get("tryFirstToken"));
    }

    @Override
    protected boolean doLogin() throws LoginException {
        block7: {
            if (!this.authenticationSchemeIsNegotiate()) {
                throw new LoginException("Only able to handle Negotiate authentication scheme");
            }
            if (this.tryFirstToken) {
                try {
                    this.attemptAuthenticate(true);
                    return false;
                }
                catch (Exception le) {
                    this.cleanState();
                    if (!this.debug) break block7;
                    LOG.debug("[NegotiateLoginModule] reading from shared state failed", (Throwable)le);
                }
            }
        }
        try {
            this.attemptAuthenticate(false);
            return false;
        }
        catch (Exception loginException) {
            this.cleanState();
            if (this.debug) {
                LOG.debug("[NegotiateLoginModule] regular authentication failed", (Throwable)loginException);
            }
            throw loginException;
        }
    }

    private void attemptAuthenticate(boolean useSharedState) throws LoginException {
        try {
            String negotiateAuthToken = this.getNegotiateAuthToken(useSharedState);
            if (negotiateAuthToken == null) {
                throw new LoginException("No HTTP Negotiate Authentication Token found.");
            }
            if (negotiateAuthToken.startsWith("Negotiate ")) {
                negotiateAuthToken = negotiateAuthToken.substring("Negotiate ".length());
            }
            if (this.callbackRegistrar != null) {
                ByteBuffer gssBuf = Encoding.BASE64.decode(ByteBuffer.wrap(negotiateAuthToken.getBytes(UTF8)));
                byte[] gss = new byte[gssBuf.remaining()];
                gssBuf.get(gss);
                this.sharedState.put(KAAZING_GSS_TOKEN_KEY, gss);
                this.callbackRegistrar.register((DispatchCallbackHandler)this.handler, negotiateAuthToken, gss);
            }
        }
        catch (Exception e) {
            if (this.debug) {
                LOG.debug("[NegotiateLoginModule] Exception decoding HTTP Basic Authentication token", (Throwable)e);
            }
            throw (LoginException)new LoginException().initCause(e);
        }
    }

    private boolean authenticationSchemeIsNegotiate() throws LoginException {
        AuthenticationTokenCallback authenticationTokenCallback = new AuthenticationTokenCallback();
        try {
            this.handler.handle(new Callback[]{authenticationTokenCallback});
        }
        catch (IOException | UnsupportedCallbackException e) {
            if (this.debug) {
                LOG.debug("[NegotiateLoginModule] Encountered exception handling AuthenticationTokenCallback.", (Throwable)e);
            }
            throw (LoginException)new LoginException(e.getMessage()).initCause(e);
        }
        return authenticationTokenCallback.getAuthenticationToken() != null && authenticationTokenCallback.getAuthenticationToken().getScheme() != null && authenticationTokenCallback.getAuthenticationToken().getScheme().equalsIgnoreCase("Negotiate");
    }

    private String getNegotiateAuthToken(boolean useSharedState) throws LoginException {
        if (useSharedState) {
            return (String)this.sharedState.get(KAAZING_TOKEN_KEY);
        }
        AuthenticationTokenCallback authenticationTokenCallback = new AuthenticationTokenCallback();
        try {
            this.handler.handle(new Callback[]{authenticationTokenCallback});
        }
        catch (IOException | UnsupportedCallbackException e) {
            if (this.debug) {
                LOG.debug("[NegotiateLoginModule] Encountered exception handling AuthenticationTokenCallback.", (Throwable)e);
            }
            throw (LoginException)new LoginException(e.getMessage()).initCause(e);
        }
        return authenticationTokenCallback.getAuthenticationToken() == null ? null : authenticationTokenCallback.getAuthenticationToken().get();
    }

    private void cleanState() {
        if (this.callbackRegistrar != null) {
            this.sharedState.remove(KAAZING_GSS_TOKEN_KEY);
            this.callbackRegistrar.unregister((DispatchCallbackHandler)this.handler);
        }
    }

    @Override
    protected boolean doCommit() throws LoginException {
        return true;
    }

    @Override
    protected boolean doLogout() throws LoginException {
        this.cleanState();
        return true;
    }
}

