/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.security.auth;

import java.io.IOException;
import java.util.function.Function;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.kaazing.gateway.server.spi.security.NamedSubjectCallback;

public class NamedSubjectCallbackHandler
implements CallbackHandler {
    private final Function<String, Subject> subjects;

    public NamedSubjectCallbackHandler(Function<String, Subject> subjects) {
        this.subjects = subjects;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (!(callback instanceof NamedSubjectCallback)) {
                throw new UnsupportedCallbackException(callback);
            }
            NamedSubjectCallback subjectCB = (NamedSubjectCallback)callback;
            String realm = subjectCB.getName();
            subjectCB.setSubject(this.subjects.apply(realm));
        }
    }
}

