/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.security.auth.token;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.kaazing.gateway.server.spi.security.AuthenticationToken;

public class DefaultAuthenticationToken
extends AuthenticationToken {
    private String scheme;
    private List<String> components;
    private Map<String, String> namedComponents;

    public DefaultAuthenticationToken() {
        this(1);
    }

    public DefaultAuthenticationToken(int initialCapacity) {
        this.components = new ArrayList<String>(initialCapacity);
        this.namedComponents = new LinkedHashMap<String, String>(initialCapacity);
    }

    public DefaultAuthenticationToken(String component) {
        this();
        this.add(component);
    }

    public DefaultAuthenticationToken(String scheme, String component) {
        this();
        this.add(component);
        this.scheme = scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void add(String component) {
        this.components.add(component);
    }

    public void add(String name, String namedComponent) {
        this.namedComponents.put(name, namedComponent);
    }

    public String get() {
        if (this.size() == 0) {
            return null;
        }
        return this.get(0);
    }

    public String get(int index) {
        if (index >= 0 && index < this.components.size()) {
            return this.components.get(index);
        }
        if (index >= this.components.size() && index < this.components.size() + this.namedComponents.size()) {
            int namedIndex = index - this.components.size();
            ArrayList<String> namedValues = new ArrayList<String>(this.namedComponents.values());
            return (String)namedValues.get(namedIndex);
        }
        throw new IndexOutOfBoundsException("Attempting access token component " + index + " when only " + this.size() + " components are available.");
    }

    public String get(String name) {
        return this.namedComponents.get(name);
    }

    public String getScheme() {
        return this.scheme;
    }

    public int size() {
        return this.components.size() + this.namedComponents.size();
    }

    public boolean isEmpty() {
        boolean isEmpty = true;
        if (this.size() == 0) {
            return true;
        }
        for (int i = 0; i < this.size(); ++i) {
            String v = this.get(i);
            if (v == null || v.length() <= 0) continue;
            isEmpty = false;
        }
        return isEmpty;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(" scheme=").append(this.scheme);
        if (this.size() == 0) {
            sb.append(" <empty authentication token> ]");
            return sb.toString();
        }
        for (String component : this.components) {
            if (component == null) {
                sb.append(' ').append('{').append(component).append('}');
                continue;
            }
            sb.append(' ').append("{'").append(component).append("'}");
        }
        for (String name : this.namedComponents.keySet()) {
            sb.append(' ').append("{'").append(name).append("'->'" + this.namedComponents.get(name) + "'}");
        }
        sb.append(" ]");
        return sb.toString();
    }
}

