/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.security.auth;

import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public abstract class BaseStateDrivenLoginModule
implements LoginModule {
    protected State state = State.INITIALIZE_REQUIRED;
    protected Subject subject;
    protected CallbackHandler handler;
    protected Map<String, ?> sharedState;
    protected Map<String, ?> options;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.handler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        this.state = State.INITIALIZE_COMPLETE;
    }

    @Override
    public boolean login() throws LoginException {
        switch (this.state) {
            case INITIALIZE_COMPLETE: {
                return this.login0();
            }
            case LOGIN_COMPLETE: {
                return this.login0();
            }
            case COMMIT_COMPLETE: {
                return true;
            }
        }
        throw new LoginException("Login module is not initialized");
    }

    @Override
    public boolean commit() throws LoginException {
        switch (this.state) {
            case COMMIT_COMPLETE: {
                return true;
            }
            case INITIALIZE_COMPLETE: {
                this.logout0();
                return false;
            }
            case LOGIN_COMPLETE: {
                this.commit0();
                return true;
            }
        }
        throw new LoginException("Login module is not initialized");
    }

    private boolean login0() throws LoginException {
        boolean result = this.doLogin();
        if (result) {
            this.state = State.LOGIN_COMPLETE;
        }
        return result;
    }

    private boolean commit0() throws LoginException {
        boolean result = this.doCommit();
        if (result) {
            this.state = State.COMMIT_COMPLETE;
        }
        return result;
    }

    private boolean logout0() throws LoginException {
        boolean result = this.doLogout();
        if (result) {
            this.state = State.INITIALIZE_COMPLETE;
        }
        return result;
    }

    @Override
    public boolean abort() throws LoginException {
        switch (this.state) {
            case LOGIN_COMPLETE: 
            case COMMIT_COMPLETE: {
                this.logout0();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean logout() throws LoginException {
        switch (this.state) {
            case COMMIT_COMPLETE: {
                this.logout0();
                return true;
            }
            case INITIALIZE_REQUIRED: {
                throw new LoginException("Login module is not initialized");
            }
        }
        return this.logout0();
    }

    protected abstract boolean doLogin() throws LoginException;

    protected abstract boolean doCommit() throws LoginException;

    protected abstract boolean doLogout() throws LoginException;

    protected static enum State {
        INITIALIZE_REQUIRED,
        INITIALIZE_COMPLETE,
        LOGIN_COMPLETE,
        COMMIT_COMPLETE;

    }
}

