/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.security.auth;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.kaazing.gateway.security.auth.BaseStateDrivenLoginModule;
import org.kaazing.gateway.security.auth.DefaultLoginResult;
import org.kaazing.gateway.server.spi.security.LoginResult;
import org.kaazing.gateway.server.spi.security.LoginResultCallback;
import org.kaazing.gateway.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeoutLoginModule
extends BaseStateDrivenLoginModule {
    public static final String CLASS_NAME = TimeoutLoginModule.class.getName();
    public static final Logger logger = LoggerFactory.getLogger((String)CLASS_NAME);
    private static final String SESSION_TIMEOUT_KEY = "session-timeout";
    private boolean debug;
    private Long sessionTimeout;
    private boolean forceFailure;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.debug = "true".equalsIgnoreCase((String)options.get("debug"));
        this.forceFailure = "true".equalsIgnoreCase((String)options.get("force-failure"));
        this.sessionTimeout = this.readOption(options, SESSION_TIMEOUT_KEY);
        if (this.sessionTimeout == null) {
            throw new RuntimeException("You must specify session-timeout option.");
        }
        if (this.debug) {
            logger.trace("[TimeoutLoginModule] session timeout configured as '" + this.sessionTimeout + "'");
        }
    }

    @Override
    protected boolean doLogin() throws LoginException {
        LoginResult loginResult = this.getLoginResultFromCallback();
        if (loginResult == null) {
            return false;
        }
        boolean performedAction = false;
        if (this.sessionTimeout != null) {
            if (this.debug) {
                logger.trace("[TimeoutLoginModule] Setting session timeout to '" + this.sessionTimeout + "'");
            }
            loginResult.setSessionTimeout(this.sessionTimeout.longValue());
            performedAction = true;
        }
        if (!performedAction || this.forceFailure) {
            this.cleanState();
            return false;
        }
        return performedAction;
    }

    @Override
    protected boolean doCommit() throws LoginException {
        return true;
    }

    @Override
    protected boolean doLogout() throws LoginException {
        this.cleanState();
        return true;
    }

    private LoginResult getLoginResultFromCallback() {
        LoginResultCallback loginResultCallback = new LoginResultCallback();
        try {
            this.handler.handle(new Callback[]{loginResultCallback});
        }
        catch (IOException ioe) {
            if (logger.isTraceEnabled()) {
                logger.trace("[TimeoutLoginModule]: encountered exception handling loginResultCallback", (Throwable)ioe);
            }
            return null;
        }
        catch (UnsupportedCallbackException uce) {
            if (logger.isTraceEnabled()) {
                logger.trace("[TimeoutLoginModule]: UnsupportedCallbackException handling loginResultCallback");
            }
            return null;
        }
        return loginResultCallback.getLoginResult();
    }

    private Long readOption(Map<String, ?> options, String key) {
        String timeIntervalValue = (String)options.get(key);
        if (timeIntervalValue == null) {
            return null;
        }
        try {
            return Utils.parseTimeInterval((String)timeIntervalValue, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (NumberFormatException e) {
            logger.error("[TimeoutLoginModule] Cannot determine the value for " + key, (Throwable)e);
            throw e;
        }
    }

    private void cleanState() {
        this.sessionTimeout = 0L;
        DefaultLoginResult loginResult = (DefaultLoginResult)this.getLoginResultFromCallback();
        if (loginResult != null) {
            loginResult.clearTimeouts();
        }
    }
}

