/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.security.auth;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.security.auth.login.LoginException;
import org.kaazing.gateway.server.spi.security.LoginResult;

public class DefaultLoginResult
extends LoginResult {
    private static final long FIVE_MINUTES = TimeUnit.MINUTES.toSeconds(5L);
    static final long[] NO_PERIODS_AVAILABLE = new long[0];
    LoginResult.Type loginResultType;
    LoginException loginException;
    Set<Object> loginChallengeData = new HashSet<Object>();
    Object loginAuthorizationAttachment;
    private Long sessionTimeout;
    private long[] calculatedPeriodTimeoutValues = NO_PERIODS_AVAILABLE;

    public DefaultLoginResult() {
        this.loginResultType = LoginResult.Type.SUCCESS;
    }

    public LoginResult.Type getType() {
        return this.loginResultType;
    }

    public void challenge(Object ... challengeData) {
        this.loginResultType = LoginResult.Type.CHALLENGE;
        if (challengeData != null) {
            for (Object datum : challengeData) {
                this.loginChallengeData.add(datum);
            }
        }
    }

    public void setAuthorizationAttachment(Object authorizationAttachment) {
        if (authorizationAttachment != null) {
            this.loginAuthorizationAttachment = authorizationAttachment;
        }
    }

    public void failure(LoginException e) {
        this.loginResultType = LoginResult.Type.FAILURE;
        this.loginException = e;
    }

    public void success() {
        this.loginResultType = LoginResult.Type.SUCCESS;
    }

    public void clearTimeouts() {
        this.sessionTimeout = null;
    }

    public void setSessionTimeout(long deltaSeconds) throws IllegalArgumentException {
        if (deltaSeconds < 0L) {
            throw new IllegalArgumentException("session timeout cannot be negative.");
        }
        if (deltaSeconds == 0L) {
            this.failure(new LoginException("session timeout was set to zero, thereby invalidating this Login Result."));
        } else {
            this.sessionTimeout = deltaSeconds;
        }
    }

    public Long getSessionTimeout() {
        return this.sessionTimeout;
    }

    public LoginException getLoginException() {
        return this.loginException;
    }

    public Object[] getLoginChallengeData() {
        if (this.loginChallengeData.isEmpty()) {
            return null;
        }
        return this.loginChallengeData.toArray();
    }

    public boolean hasLoginAuthorizationAttachment() {
        return this.loginAuthorizationAttachment != null;
    }

    public Object getLoginAuthorizationAttachment() {
        return this.loginAuthorizationAttachment;
    }
}

