/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.resource.address;

import org.kaazing.gateway.resource.address.ResourceFactory;
import org.kaazing.gateway.resource.address.uri.URIUtils;

public class ResourceFactories {
    private ResourceFactories() {
    }

    public static ResourceFactory keepAuthorityOnly(String newScheme) {
        return new KeepAuthorityOnlyTransportFactory(newScheme);
    }

    public static ResourceFactory changeSchemeOnly(String newScheme) {
        return new ChangeSchemeOnlyTransportFactory(newScheme);
    }

    private static final class ChangeSchemeOnlyTransportFactory
    extends ResourceFactory {
        private final String newScheme;

        public ChangeSchemeOnlyTransportFactory(String newScheme) {
            this.newScheme = newScheme;
        }

        @Override
        public String createURI(String location) {
            return URIUtils.modifyURIScheme(location, this.newScheme);
        }
    }

    private static final class KeepAuthorityOnlyTransportFactory
    extends ResourceFactory {
        private final String newScheme;

        public KeepAuthorityOnlyTransportFactory(String newScheme) {
            this.newScheme = newScheme;
        }

        @Override
        public String createURI(String location) {
            return String.format("%s://%s", this.newScheme, URIUtils.getAuthority(location));
        }
    }
}

