/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.resource.address.ws;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.resource.address.ResourceAddressFactory;
import org.kaazing.gateway.resource.address.ResourceAddressFactorySpi;
import org.kaazing.gateway.resource.address.ResourceFactories;
import org.kaazing.gateway.resource.address.ResourceFactory;
import org.kaazing.gateway.resource.address.ResourceOptions;
import org.kaazing.gateway.resource.address.ws.WsResourceAddress;

public class WsResourceAddressFactorySpi
extends ResourceAddressFactorySpi<WsResourceAddress> {
    private static final String SCHEME_NAME = "ws";
    private static final int SCHEME_PORT = 80;
    private static final ResourceFactory TRANSPORT_FACTORY = ResourceFactories.changeSchemeOnly((String)"http");
    private static final String PROTOCOL_NAME = "ws/rfc6455";
    private static final List<String> WS_ALTERNATE_SCHEMES = Arrays.asList("wsx-draft", "ws-draft", "wsx", "wse");
    private List<ResourceFactory> alternateResourceFactories;

    public String getSchemeName() {
        return SCHEME_NAME;
    }

    protected int getSchemePort() {
        return 80;
    }

    protected String getTransportName() {
        return SCHEME_NAME;
    }

    protected ResourceFactory getTransportFactory() {
        return TRANSPORT_FACTORY;
    }

    protected String getProtocolName() {
        return PROTOCOL_NAME;
    }

    protected void parseNamedOptions0(String location, ResourceOptions options, Map<String, Object> optionsByName) {
        String[] requiredProtocols;
        String[] supportedProtocols;
        Long inactivityTimeout;
        Integer maxMessageSize;
        Boolean lightweight;
        Boolean codecRequired = (Boolean)optionsByName.remove(WsResourceAddress.CODEC_REQUIRED.name());
        if (codecRequired != null) {
            options.setOption(WsResourceAddress.CODEC_REQUIRED, (Object)codecRequired);
        }
        if ((lightweight = (Boolean)optionsByName.remove(WsResourceAddress.LIGHTWEIGHT.name())) != null) {
            options.setOption(WsResourceAddress.LIGHTWEIGHT, (Object)lightweight);
        }
        if ((maxMessageSize = (Integer)optionsByName.remove(WsResourceAddress.MAX_MESSAGE_SIZE.name())) != null) {
            options.setOption(WsResourceAddress.MAX_MESSAGE_SIZE, (Object)maxMessageSize);
        }
        if ((inactivityTimeout = (Long)optionsByName.remove(WsResourceAddress.INACTIVITY_TIMEOUT.name())) != null) {
            options.setOption(WsResourceAddress.INACTIVITY_TIMEOUT, (Object)inactivityTimeout);
        }
        if ((supportedProtocols = (String[])optionsByName.remove(WsResourceAddress.SUPPORTED_PROTOCOLS.name())) != null) {
            options.setOption(WsResourceAddress.SUPPORTED_PROTOCOLS, (Object)supportedProtocols);
        }
        if ((requiredProtocols = (String[])optionsByName.remove(WsResourceAddress.REQUIRED_PROTOCOLS.name())) != null) {
            options.setOption(WsResourceAddress.REQUIRED_PROTOCOLS, (Object)requiredProtocols);
        }
    }

    public void setResourceAddressFactory(ResourceAddressFactory addressFactory) {
        super.setResourceAddressFactory(addressFactory);
        HashMap alternateAddressFactories = addressFactory.getAlternateAddressFactories(this.getSchemeName());
        alternateAddressFactories = new HashMap(alternateAddressFactories);
        ArrayList<ResourceFactory> alternateResourceFactories = new ArrayList<ResourceFactory>();
        for (String scheme : WS_ALTERNATE_SCHEMES) {
            if (alternateAddressFactories.get(scheme) == null) continue;
            alternateResourceFactories.add(ResourceFactories.changeSchemeOnly((String)scheme));
            alternateAddressFactories.remove(scheme);
        }
        for (String scheme : alternateAddressFactories.keySet()) {
            alternateResourceFactories.add(ResourceFactories.changeSchemeOnly((String)scheme));
        }
        this.alternateResourceFactories = Collections.unmodifiableList(alternateResourceFactories);
    }

    protected List<ResourceFactory> getAlternateResourceFactories() {
        return this.alternateResourceFactories;
    }

    protected void setAlternateOption(String location, ResourceOptions options, Map<String, Object> optionsByName) {
        List<ResourceFactory> resourceFactories = this.getAlternateResourceFactories();
        if (resourceFactories != null && !resourceFactories.isEmpty() && this.getResourceAddressFactory() != null) {
            WsResourceAddress alternateAddress = null;
            for (ResourceFactory resourceFactory : resourceFactories) {
                alternateAddress = (WsResourceAddress)this.newResourceAddressWithAlternate(resourceFactory.createURI(location), this.getNewOptionsByName(options, optionsByName), alternateAddress);
            }
            options.setOption(ResourceAddress.ALTERNATE, alternateAddress);
        }
    }

    protected WsResourceAddress newResourceAddress0(String original, String location) {
        URI uriLocation = URI.create(location);
        String path = uriLocation.getPath();
        if (uriLocation.getHost() == null) {
            throw new IllegalArgumentException(String.format("Missing host in URI: %s", location));
        }
        if (uriLocation.getPort() == -1) {
            throw new IllegalArgumentException(String.format("Missing port in URI: %s", location));
        }
        if (path == null || path.length() == 0) {
            throw new IllegalArgumentException(String.format("Missing path in URI: %s", location));
        }
        return new WsResourceAddress(this, original, uriLocation);
    }

    protected void setOptions(WsResourceAddress address, ResourceOptions options, Object qualifier) {
        options.setOption(ResourceAddress.BIND_ALTERNATE, (Object)Boolean.FALSE);
        super.setOptions((ResourceAddress)address, options, qualifier);
        if ("x-kaazing-handshake".equals(address.getOption(ResourceAddress.NEXT_PROTOCOL))) {
            options.setOption(WsResourceAddress.LIGHTWEIGHT, (Object)Boolean.TRUE);
        }
        address.setOption0(WsResourceAddress.CODEC_REQUIRED, options.getOption(WsResourceAddress.CODEC_REQUIRED));
        address.setOption0(WsResourceAddress.LIGHTWEIGHT, options.getOption(WsResourceAddress.LIGHTWEIGHT));
        address.setOption0(WsResourceAddress.MAX_MESSAGE_SIZE, options.getOption(WsResourceAddress.MAX_MESSAGE_SIZE));
        address.setOption0(WsResourceAddress.INACTIVITY_TIMEOUT, options.getOption(WsResourceAddress.INACTIVITY_TIMEOUT));
        address.setOption0(WsResourceAddress.SUPPORTED_PROTOCOLS, options.getOption(WsResourceAddress.SUPPORTED_PROTOCOLS));
        address.setOption0(WsResourceAddress.REQUIRED_PROTOCOLS, options.getOption(WsResourceAddress.REQUIRED_PROTOCOLS));
    }
}

