/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.resource.address.ws;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.resource.address.ResourceAddressFactorySpi;
import org.kaazing.gateway.resource.address.ResourceOption;

public class WsResourceAddress
extends ResourceAddress {
    private static final long serialVersionUID = 1L;
    static final String TRANSPORT_NAME = "ws";
    private static final int MAX_MESSAGE_SIZE_DEFAULT = 0;
    private static final List<String> EXTENSIONS_DEFAULT = Collections.emptyList();
    public static final long INACTIVITY_TIMEOUT_DEFAULT = 0L;
    private static final String[] SUPPORTED_PROTOCOLS_DEFAULT = new String[0];
    private static final String[] REQUIRED_PROTOCOLS_DEFAULT = new String[0];
    public static final ResourceOption<Boolean> CODEC_REQUIRED = new WsCodecRequiredOption();
    public static final ResourceOption<Boolean> LIGHTWEIGHT = new WsLightweightOption();
    public static final ResourceOption<List<String>> EXTENSIONS = new WsExtensionsOption();
    public static final ResourceOption<Integer> MAX_MESSAGE_SIZE = new WsMaxMessageSizeOption();
    public static final ResourceOption<Long> INACTIVITY_TIMEOUT = new WsInactivityTimeoutOption();
    public static final ResourceOption<String[]> SUPPORTED_PROTOCOLS = new WsSupportedProtocolsOption();
    public static final ResourceOption<String[]> REQUIRED_PROTOCOLS = new WsRequiredProtocolsOption();
    private Boolean codecRequired;
    private Boolean lightweight;
    private List<String> extensions = (List)EXTENSIONS.defaultValue();
    private int maxMessageSize = (Integer)MAX_MESSAGE_SIZE.defaultValue();
    private long inactivityTimeout = (Long)INACTIVITY_TIMEOUT.defaultValue();
    private String[] supportedProtocols;
    private String[] requiredProtocols = (String[])REQUIRED_PROTOCOLS.defaultValue();

    WsResourceAddress(ResourceAddressFactorySpi factory, String original, URI resource) {
        super(factory, original, resource);
    }

    protected <V> V getOption0(ResourceOption<V> option) {
        if (option instanceof WsResourceOption) {
            WsResourceOption wsOption = (WsResourceOption)option;
            switch (wsOption.kind) {
                case CODEC_REQUIRED: {
                    return (V)this.codecRequired;
                }
                case LIGHTWEIGHT: {
                    return (V)this.lightweight;
                }
                case EXTENSIONS: {
                    return (V)this.extensions;
                }
                case MAX_MESSAGE_SIZE: {
                    return (V)Integer.valueOf(this.maxMessageSize);
                }
                case INACTIVITY_TIMEOUT: {
                    return (V)Long.valueOf(this.inactivityTimeout);
                }
                case SUPPORTED_PROTOCOLS: {
                    return (V)this.supportedProtocols;
                }
                case REQUIRED_PROTOCOLS: {
                    return (V)this.requiredProtocols;
                }
            }
        }
        return (V)super.getOption0(option);
    }

    protected <V> void setOption0(ResourceOption<V> option, V value) {
        if (option instanceof WsResourceOption) {
            WsResourceOption wsOption = (WsResourceOption)option;
            switch (wsOption.kind) {
                case CODEC_REQUIRED: {
                    this.codecRequired = (Boolean)value;
                    return;
                }
                case LIGHTWEIGHT: {
                    this.lightweight = (Boolean)value;
                    return;
                }
                case EXTENSIONS: {
                    this.extensions = (List)value;
                    return;
                }
                case MAX_MESSAGE_SIZE: {
                    this.maxMessageSize = (Integer)value;
                    return;
                }
                case INACTIVITY_TIMEOUT: {
                    this.inactivityTimeout = (Long)value;
                    return;
                }
                case SUPPORTED_PROTOCOLS: {
                    this.supportedProtocols = (String[])value;
                    return;
                }
                case REQUIRED_PROTOCOLS: {
                    this.requiredProtocols = (String[])value;
                    return;
                }
            }
        }
        super.setOption0(option, value);
    }

    private static final class WsRequiredProtocolsOption
    extends WsResourceOption<String[]> {
        private WsRequiredProtocolsOption() {
            super(WsResourceOption.Kind.REQUIRED_PROTOCOLS, "requiredProtocols", REQUIRED_PROTOCOLS_DEFAULT);
        }
    }

    private static final class WsSupportedProtocolsOption
    extends WsResourceOption<String[]> {
        private WsSupportedProtocolsOption() {
            super(WsResourceOption.Kind.SUPPORTED_PROTOCOLS, "supportedProtocols", SUPPORTED_PROTOCOLS_DEFAULT);
        }
    }

    private static final class WsInactivityTimeoutOption
    extends WsResourceOption<Long> {
        private WsInactivityTimeoutOption() {
            super(WsResourceOption.Kind.INACTIVITY_TIMEOUT, "inactivityTimeout", 0L);
        }
    }

    private static final class WsMaxMessageSizeOption
    extends WsResourceOption<Integer> {
        private WsMaxMessageSizeOption() {
            super(WsResourceOption.Kind.MAX_MESSAGE_SIZE, "maxMessageSize", 0);
        }
    }

    private static final class WsExtensionsOption
    extends WsResourceOption<List<String>> {
        private WsExtensionsOption() {
            super(WsResourceOption.Kind.EXTENSIONS, "extensions", EXTENSIONS_DEFAULT);
        }
    }

    private static final class WsLightweightOption
    extends WsResourceOption<Boolean> {
        private WsLightweightOption() {
            super(WsResourceOption.Kind.LIGHTWEIGHT, "lightweight", Boolean.FALSE);
        }
    }

    private static final class WsCodecRequiredOption
    extends WsResourceOption<Boolean> {
        private WsCodecRequiredOption() {
            super(WsResourceOption.Kind.CODEC_REQUIRED, "codecRequired", Boolean.TRUE);
        }
    }

    static class WsResourceOption<T>
    extends ResourceOption<T> {
        private static final Map<String, ResourceOption<?>> OPTION_NAMES = new HashMap();
        private final Kind kind;

        private WsResourceOption(Kind kind, String name) {
            this(kind, name, null);
        }

        private WsResourceOption(Kind kind, String name, T defaultValue) {
            super(OPTION_NAMES, name, defaultValue);
            this.kind = kind;
        }

        protected static enum Kind {
            CODEC_REQUIRED,
            LIGHTWEIGHT,
            EXTENSIONS,
            MAX_MESSAGE_SIZE,
            INACTIVITY_TIMEOUT,
            SUPPORTED_PROTOCOLS,
            REQUIRED_PROTOCOLS;

        }
    }
}

