/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.resource.address.ws;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.kaazing.gateway.resource.address.ResourceAddressFactory;
import org.kaazing.gateway.resource.address.ResourceFactories;
import org.kaazing.gateway.resource.address.ResourceFactory;
import org.kaazing.gateway.resource.address.ws.WsResourceAddressFactorySpi;

public class WssResourceAddressFactorySpi
extends WsResourceAddressFactorySpi {
    static final String SCHEME_NAME = "wss";
    private static final int SCHEME_PORT = 443;
    private static final ResourceFactory TRANSPORT_FACTORY = ResourceFactories.changeSchemeOnly((String)"https");
    private static final List<String> WSS_ALTERNATE_SCHEMES = Arrays.asList("wsx-draft+ssl", "ws-draft+ssl", "wsx+ssl", "wse+ssl");
    private List<ResourceFactory> alternateResourceFactories;

    @Override
    public String getSchemeName() {
        return SCHEME_NAME;
    }

    @Override
    protected int getSchemePort() {
        return 443;
    }

    @Override
    protected ResourceFactory getTransportFactory() {
        return TRANSPORT_FACTORY;
    }

    @Override
    public void setResourceAddressFactory(ResourceAddressFactory addressFactory) {
        super.setResourceAddressFactory(addressFactory);
        HashMap alternateAddressFactories = addressFactory.getAlternateAddressFactories(this.getSchemeName());
        alternateAddressFactories = new HashMap(alternateAddressFactories);
        ArrayList<ResourceFactory> alternateResourceFactories = new ArrayList<ResourceFactory>();
        for (String scheme : WSS_ALTERNATE_SCHEMES) {
            if (alternateAddressFactories.get(scheme) == null) continue;
            alternateResourceFactories.add(ResourceFactories.changeSchemeOnly((String)scheme));
            alternateAddressFactories.remove(scheme);
        }
        for (String scheme : alternateAddressFactories.keySet()) {
            alternateResourceFactories.add(ResourceFactories.changeSchemeOnly((String)scheme));
        }
        this.alternateResourceFactories = Collections.unmodifiableList(alternateResourceFactories);
    }

    @Override
    protected List<ResourceFactory> getAlternateResourceFactories() {
        return this.alternateResourceFactories;
    }
}

