/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.resource.address.ssl;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.resource.address.ResourceAddressFactorySpi;
import org.kaazing.gateway.resource.address.ResourceOption;
import org.kaazing.gateway.security.KeySelector;

public final class SslResourceAddress
extends ResourceAddress {
    private static final long serialVersionUID = 1L;
    static final String TRANSPORT_NAME = "ssl";
    public static final ResourceOption<String[]> CIPHERS = new SslCiphersOption();
    public static final ResourceOption<Boolean> ENCRYPTION_ENABLED = new SslEncryptionOption();
    public static final ResourceOption<Boolean> WANT_CLIENT_AUTH = new SslWantClientAuthOption();
    public static final ResourceOption<Boolean> NEED_CLIENT_AUTH = new SslNeedClientAuthOption();
    public static final ResourceOption<KeySelector> KEY_SELECTOR = new SslKeySelectorOption();
    public static final ResourceOption<String[]> PROTOCOLS = new SslProtocolsOption();
    private String[] ciphers;
    private String[] protocols;
    private boolean encryption = true;
    private boolean wantClientAuth;
    private boolean needClientAuth;
    private KeySelector keySelector;

    SslResourceAddress(ResourceAddressFactorySpi factory, String original, URI resource) {
        super(factory, original, resource);
    }

    protected <V> V getOption0(ResourceOption<V> option) {
        if (option instanceof SslResourceOption) {
            SslResourceOption sslOption = (SslResourceOption)option;
            switch (sslOption.kind) {
                case CIPHERS: {
                    return (V)this.ciphers;
                }
                case ENCRYPTION: {
                    return (V)Boolean.valueOf(this.encryption);
                }
                case WANT_CLIENT_AUTH: {
                    return (V)Boolean.valueOf(this.wantClientAuth);
                }
                case NEED_CLIENT_AUTH: {
                    return (V)Boolean.valueOf(this.needClientAuth);
                }
                case KEY_SELECTOR: {
                    return (V)this.keySelector;
                }
                case PROTOCOLS: {
                    return (V)this.protocols;
                }
            }
        }
        return (V)super.getOption0(option);
    }

    protected <V> void setOption0(ResourceOption<V> option, V value) {
        if (option instanceof SslResourceOption) {
            SslResourceOption sslOption = (SslResourceOption)option;
            switch (sslOption.kind) {
                case CIPHERS: {
                    this.ciphers = (String[])value;
                    return;
                }
                case ENCRYPTION: {
                    this.encryption = (Boolean)value;
                    return;
                }
                case WANT_CLIENT_AUTH: {
                    this.wantClientAuth = (Boolean)value;
                    return;
                }
                case NEED_CLIENT_AUTH: {
                    this.needClientAuth = (Boolean)value;
                    return;
                }
                case KEY_SELECTOR: {
                    this.keySelector = (KeySelector)value;
                    return;
                }
                case PROTOCOLS: {
                    this.protocols = (String[])value;
                    return;
                }
            }
        }
        super.setOption0(option, value);
    }

    private static final class SslProtocolsOption
    extends SslResourceOption<String[]> {
        private SslProtocolsOption() {
            super(SslResourceOption.Kind.PROTOCOLS, "protocols");
        }
    }

    private static final class SslKeySelectorOption
    extends SslResourceOption<KeySelector> {
        private SslKeySelectorOption() {
            super(SslResourceOption.Kind.KEY_SELECTOR, "keySelector");
        }
    }

    private static final class SslNeedClientAuthOption
    extends SslResourceOption<Boolean> {
        private SslNeedClientAuthOption() {
            super(SslResourceOption.Kind.NEED_CLIENT_AUTH, "needClientAuth", Boolean.FALSE);
        }
    }

    private static final class SslWantClientAuthOption
    extends SslResourceOption<Boolean> {
        private SslWantClientAuthOption() {
            super(SslResourceOption.Kind.WANT_CLIENT_AUTH, "wantClientAuth", Boolean.FALSE);
        }
    }

    private static final class SslEncryptionOption
    extends SslResourceOption<Boolean> {
        private SslEncryptionOption() {
            super(SslResourceOption.Kind.ENCRYPTION, "encryptionEnabled", Boolean.TRUE);
        }
    }

    private static final class SslCiphersOption
    extends SslResourceOption<String[]> {
        private SslCiphersOption() {
            super(SslResourceOption.Kind.CIPHERS, "ciphers", new String[]{"DEFAULT"});
        }
    }

    static class SslResourceOption<T>
    extends ResourceOption<T> {
        private static final Map<String, ResourceOption<?>> OPTION_NAMES = new HashMap();
        private final Kind kind;

        private SslResourceOption(Kind kind, String name) {
            this(kind, name, null);
        }

        private SslResourceOption(Kind kind, String name, T defaultValue) {
            super(OPTION_NAMES, name, defaultValue);
            this.kind = kind;
        }

        protected static enum Kind {
            CIPHERS,
            ENCRYPTION,
            WANT_CLIENT_AUTH,
            NEED_CLIENT_AUTH,
            KEY_SELECTOR,
            PROTOCOLS;

        }
    }
}

