/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.resource.address.ssl;

import java.net.URI;
import java.util.Map;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.resource.address.ResourceAddressFactorySpi;
import org.kaazing.gateway.resource.address.ResourceFactories;
import org.kaazing.gateway.resource.address.ResourceFactory;
import org.kaazing.gateway.resource.address.ResourceOptions;
import org.kaazing.gateway.resource.address.ssl.SslResourceAddress;
import org.kaazing.gateway.security.KeySelector;

public class SslResourceAddressFactorySpi
extends ResourceAddressFactorySpi<SslResourceAddress> {
    private static final String SCHEME_NAME = "ssl";
    private static final ResourceFactory TRANSPORT_FACTORY = ResourceFactories.keepAuthorityOnly((String)"tcp");
    private static final String PROTOCOL_NAME = "ssl";

    public String getSchemeName() {
        return "ssl";
    }

    protected String getTransportName() {
        return "ssl";
    }

    protected ResourceFactory getTransportFactory() {
        return TRANSPORT_FACTORY;
    }

    protected String getProtocolName() {
        return "ssl";
    }

    protected void parseNamedOptions0(URI location, ResourceOptions options, Map<String, Object> optionsByName) {
        String[] protocols;
        KeySelector keySelector;
        Boolean needClientAuth;
        Boolean wantClientAuth;
        Boolean encryption;
        String[] ciphers = (String[])optionsByName.remove(SslResourceAddress.CIPHERS.name());
        if (ciphers != null) {
            options.setOption(SslResourceAddress.CIPHERS, (Object)ciphers);
        }
        if ((encryption = (Boolean)optionsByName.remove(SslResourceAddress.ENCRYPTION_ENABLED.name())) != null) {
            options.setOption(SslResourceAddress.ENCRYPTION_ENABLED, (Object)encryption);
        }
        if ((wantClientAuth = (Boolean)optionsByName.remove(SslResourceAddress.WANT_CLIENT_AUTH.name())) != null) {
            options.setOption(SslResourceAddress.WANT_CLIENT_AUTH, (Object)wantClientAuth);
        }
        if ((needClientAuth = (Boolean)optionsByName.remove(SslResourceAddress.NEED_CLIENT_AUTH.name())) != null) {
            options.setOption(SslResourceAddress.NEED_CLIENT_AUTH, (Object)needClientAuth);
        }
        if ((keySelector = (KeySelector)optionsByName.remove(SslResourceAddress.KEY_SELECTOR.name())) != null) {
            options.setOption(SslResourceAddress.KEY_SELECTOR, (Object)keySelector);
        }
        if ((protocols = (String[])optionsByName.remove(SslResourceAddress.PROTOCOLS.name())) != null) {
            options.setOption(SslResourceAddress.PROTOCOLS, (Object)protocols);
        }
    }

    protected SslResourceAddress newResourceAddress0(URI original, URI location) {
        String host = location.getHost();
        int port = location.getPort();
        String path = location.getPath();
        if (host == null) {
            throw new IllegalArgumentException(String.format("Missing host in URI: %s", location));
        }
        if (port == -1) {
            throw new IllegalArgumentException(String.format("Missing port in URI: %s", location));
        }
        if (path != null && !path.isEmpty()) {
            throw new IllegalArgumentException(String.format("Unexpected path \"%s\" in URI: %s", path, location));
        }
        return new SslResourceAddress(original, location);
    }

    protected void setOptions(SslResourceAddress address, ResourceOptions options, Object qualifier) {
        super.setOptions((ResourceAddress)address, options, qualifier);
        address.setOption0(SslResourceAddress.CIPHERS, options.getOption(SslResourceAddress.CIPHERS));
        address.setOption0(SslResourceAddress.ENCRYPTION_ENABLED, options.getOption(SslResourceAddress.ENCRYPTION_ENABLED));
        address.setOption0(SslResourceAddress.WANT_CLIENT_AUTH, options.getOption(SslResourceAddress.WANT_CLIENT_AUTH));
        address.setOption0(SslResourceAddress.NEED_CLIENT_AUTH, options.getOption(SslResourceAddress.NEED_CLIENT_AUTH));
        address.setOption0(SslResourceAddress.KEY_SELECTOR, options.getOption(SslResourceAddress.KEY_SELECTOR));
        address.setOption0(SslResourceAddress.PROTOCOLS, options.getOption(SslResourceAddress.PROTOCOLS));
    }
}

