/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.resource.address.rtmp;

import java.net.URI;
import org.kaazing.gateway.resource.address.ResourceAddressFactorySpi;
import org.kaazing.gateway.resource.address.ResourceFactories;
import org.kaazing.gateway.resource.address.ResourceFactory;
import org.kaazing.gateway.resource.address.rtmp.RtmpResourceAddress;

public class RtmpResourceAddressFactorySpi
extends ResourceAddressFactorySpi<RtmpResourceAddress> {
    private static final String SCHEME_NAME = "rtmp";
    private static final int SCHEME_PORT = 1935;
    private static final ResourceFactory TRANSPORT_FACTORY = ResourceFactories.keepAuthorityOnly((String)"tcp");
    private static final String PROTOCOL_NAME = "rtmp/1.0";

    public String getSchemeName() {
        return SCHEME_NAME;
    }

    protected int getSchemePort() {
        return 1935;
    }

    protected String getTransportName() {
        return SCHEME_NAME;
    }

    protected ResourceFactory getTransportFactory() {
        return TRANSPORT_FACTORY;
    }

    protected String getProtocolName() {
        return PROTOCOL_NAME;
    }

    protected RtmpResourceAddress newResourceAddress0(String original, String location) {
        URI uriLocation = URI.create(location);
        String path = uriLocation.getPath();
        if (uriLocation.getHost() == null) {
            throw new IllegalArgumentException(String.format("Missing host in URI: %s", location));
        }
        if (uriLocation.getPort() == -1) {
            throw new IllegalArgumentException(String.format("Missing port in URI: %s", location));
        }
        if (path == null || path.length() == 0) {
            throw new IllegalArgumentException(String.format("Missing path in URI: %s", location));
        }
        return new RtmpResourceAddress(this, original, uriLocation);
    }
}

