/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.resource.address.pipe;

import java.net.URI;
import org.kaazing.gateway.resource.address.ResourceAddressFactorySpi;
import org.kaazing.gateway.resource.address.ResourceFactory;
import org.kaazing.gateway.resource.address.pipe.PipeResourceAddress;
import org.kaazing.gateway.resource.address.uri.URIUtils;

public class PipeResourceAddressFactorySpi
extends ResourceAddressFactorySpi<PipeResourceAddress> {
    private static final String SCHEME_NAME = "pipe";
    private static final String PROTOCOL_NAME = "pipe";
    private static final String PIPE_PATH_ERROR_MESSAGE = "Use pipe://%s instead of pipe://%s%s because named pipe URIs shouldn't contain paths.";

    public String getSchemeName() {
        return "pipe";
    }

    protected String getTransportName() {
        return "pipe";
    }

    protected String getProtocolName() {
        return "pipe";
    }

    protected ResourceFactory getTransportFactory() {
        return null;
    }

    protected PipeResourceAddress newResourceAddress0(String original, String location) {
        String pipeName = URIUtils.getAuthority((String)location);
        String pathName = URIUtils.getPath((String)location);
        if (pipeName == null) {
            throw new IllegalArgumentException(String.format("URI %s missing pipe name", location));
        }
        if (pathName != null && !pathName.isEmpty()) {
            throw new IllegalArgumentException(String.format(PIPE_PATH_ERROR_MESSAGE, pipeName, pipeName, pathName));
        }
        URI uriLocation = URI.create(location);
        return new PipeResourceAddress(this, original, uriLocation);
    }
}

