/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.resource.address.http;

import java.io.File;
import java.net.URI;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.kaazing.gateway.resource.address.IdentityResolver;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.resource.address.ResourceAddressFactorySpi;
import org.kaazing.gateway.resource.address.ResourceFactories;
import org.kaazing.gateway.resource.address.ResourceFactory;
import org.kaazing.gateway.resource.address.ResourceOption;
import org.kaazing.gateway.resource.address.ResourceOptions;
import org.kaazing.gateway.resource.address.http.GatewayHttpOriginSecurity;
import org.kaazing.gateway.resource.address.http.HttpIdentityResolver;
import org.kaazing.gateway.resource.address.http.HttpOriginSecurity;
import org.kaazing.gateway.resource.address.http.HttpRealmInfo;
import org.kaazing.gateway.resource.address.http.HttpResourceAddress;
import org.kaazing.gateway.resource.address.uri.URIUtils;

public class HttpResourceAddressFactorySpi
extends ResourceAddressFactorySpi<HttpResourceAddress> {
    public static final int SCHEME_PORT = 80;
    private static final String SCHEME_NAME = "http";
    private static final ResourceFactory TRANSPORT_FACTORY = ResourceFactories.keepAuthorityOnly((String)"tcp");
    private static final String PROTOCOL_NAME = "http/1.1";
    private static final Map<String, List<ResourceFactory>> RESOURCE_FACTORIES_BY_KEY = new HashMap<String, List<ResourceFactory>>();

    public String getSchemeName() {
        return SCHEME_NAME;
    }

    protected int getSchemePort() {
        return 80;
    }

    protected String getTransportName() {
        return SCHEME_NAME;
    }

    protected ResourceFactory getTransportFactory() {
        return TRANSPORT_FACTORY;
    }

    protected String getProtocolName() {
        return PROTOCOL_NAME;
    }

    protected void parseNamedOptions0(String location, ResourceOptions options, Map<String, Object> optionsByName) {
        IdentityResolver httpIdentityResolver;
        HttpRealmInfo[] realms;
        Object maxAuthenticationAttempts;
        Boolean hostHeaderEnabled;
        Boolean userAgentHeaderEnabled;
        Boolean serverHeaderEnabled;
        Collection balanceOrigin;
        List authorityToSetOfAcceptConstraintsByURI;
        File tempDirectory;
        Map acceptConstraints;
        Set injectableHeaders;
        String serviceDomain;
        String encryptionKeyAlias;
        String authenticationIdentifier;
        String authenticationConnect;
        String[] requiredRoles;
        Integer keepAliveConnections;
        Integer keepAliveTimeout;
        Object maxRedirects;
        Boolean keepAlive = (Boolean)optionsByName.remove(HttpResourceAddress.KEEP_ALIVE.name());
        if (keepAlive != null) {
            options.setOption(HttpResourceAddress.KEEP_ALIVE, (Object)keepAlive);
        }
        if ((maxRedirects = optionsByName.remove(HttpResourceAddress.MAXIMUM_REDIRECTS.name())) != null) {
            options.setOption(HttpResourceAddress.MAXIMUM_REDIRECTS, (Object)(maxRedirects instanceof String ? Integer.parseInt((String)maxRedirects) : (Integer)maxRedirects));
        }
        if ((keepAliveTimeout = (Integer)optionsByName.remove(HttpResourceAddress.KEEP_ALIVE_TIMEOUT.name())) != null) {
            options.setOption(HttpResourceAddress.KEEP_ALIVE_TIMEOUT, (Object)keepAliveTimeout);
        }
        if ((keepAliveConnections = (Integer)optionsByName.remove(HttpResourceAddress.KEEP_ALIVE_CONNECTIONS.name())) != null) {
            options.setOption(HttpResourceAddress.KEEP_ALIVE_CONNECTIONS, (Object)keepAliveConnections);
        }
        if ((requiredRoles = (String[])optionsByName.remove(HttpResourceAddress.REQUIRED_ROLES.name())) != null) {
            options.setOption(HttpResourceAddress.REQUIRED_ROLES, (Object)requiredRoles);
        }
        if ((authenticationConnect = (String)optionsByName.remove(HttpResourceAddress.AUTHENTICATION_CONNECT.name())) != null) {
            options.setOption(HttpResourceAddress.AUTHENTICATION_CONNECT, (Object)authenticationConnect);
        }
        if ((authenticationIdentifier = (String)optionsByName.remove(HttpResourceAddress.AUTHENTICATION_IDENTIFIER.name())) != null) {
            options.setOption(HttpResourceAddress.AUTHENTICATION_IDENTIFIER, (Object)authenticationIdentifier);
        }
        if ((encryptionKeyAlias = (String)optionsByName.remove(HttpResourceAddress.ENCRYPTION_KEY_ALIAS.name())) != null) {
            options.setOption(HttpResourceAddress.ENCRYPTION_KEY_ALIAS, (Object)encryptionKeyAlias);
        }
        if ((serviceDomain = (String)optionsByName.remove(HttpResourceAddress.SERVICE_DOMAIN.name())) != null) {
            options.setOption(HttpResourceAddress.SERVICE_DOMAIN, (Object)serviceDomain);
        }
        if ((injectableHeaders = (Set)optionsByName.remove(HttpResourceAddress.INJECTABLE_HEADERS.name())) != null) {
            options.setOption(HttpResourceAddress.INJECTABLE_HEADERS, (Object)injectableHeaders);
        }
        if ((acceptConstraints = (Map)optionsByName.remove(HttpResourceAddress.ORIGIN_SECURITY.name())) != null) {
            options.setOption(HttpResourceAddress.ORIGIN_SECURITY, (Object)new HttpOriginSecurity(acceptConstraints));
        }
        if ((tempDirectory = (File)optionsByName.remove(HttpResourceAddress.TEMP_DIRECTORY.name())) != null) {
            options.setOption(HttpResourceAddress.TEMP_DIRECTORY, (Object)tempDirectory);
        }
        if ((authorityToSetOfAcceptConstraintsByURI = (List)optionsByName.remove(HttpResourceAddress.GATEWAY_ORIGIN_SECURITY.name())) != null) {
            options.setOption(HttpResourceAddress.GATEWAY_ORIGIN_SECURITY, (Object)new GatewayHttpOriginSecurity(authorityToSetOfAcceptConstraintsByURI));
        }
        if ((balanceOrigin = (Collection)optionsByName.remove(HttpResourceAddress.BALANCE_ORIGINS.name())) != null) {
            options.setOption(HttpResourceAddress.BALANCE_ORIGINS, (Object)balanceOrigin);
        }
        if ((serverHeaderEnabled = (Boolean)optionsByName.remove(HttpResourceAddress.SERVER_HEADER_ENABLED.name())) != null) {
            options.setOption(HttpResourceAddress.SERVER_HEADER_ENABLED, (Object)serverHeaderEnabled);
        }
        Boolean dateHeaderEnabled = (Boolean)optionsByName.remove(HttpResourceAddress.DATE_HEADER_ENABLED.name());
        if (serverHeaderEnabled != null) {
            options.setOption(HttpResourceAddress.DATE_HEADER_ENABLED, (Object)dateHeaderEnabled);
        }
        if ((userAgentHeaderEnabled = (Boolean)optionsByName.remove(HttpResourceAddress.USER_AGENT_HEADER_ENABLED.name())) != null) {
            options.setOption(HttpResourceAddress.USER_AGENT_HEADER_ENABLED, (Object)userAgentHeaderEnabled);
        }
        if ((hostHeaderEnabled = (Boolean)optionsByName.remove(HttpResourceAddress.HOST_HEADER_ENABLED.name())) != null) {
            options.setOption(HttpResourceAddress.HOST_HEADER_ENABLED, (Object)hostHeaderEnabled);
        }
        if ((maxAuthenticationAttempts = optionsByName.remove(HttpResourceAddress.MAX_AUTHENTICATION_ATTEMPTS.name())) != null) {
            if (maxAuthenticationAttempts instanceof String) {
                maxAuthenticationAttempts = Integer.parseInt((String)maxAuthenticationAttempts);
            }
            options.setOption(HttpResourceAddress.MAX_AUTHENTICATION_ATTEMPTS, (Object)((Integer)maxAuthenticationAttempts));
        }
        if ((realms = (HttpRealmInfo[])optionsByName.remove(HttpResourceAddress.REALMS.name())) != null) {
            options.setOption(HttpResourceAddress.REALMS, (Object)realms);
        }
        if ((httpIdentityResolver = (IdentityResolver)optionsByName.remove(ResourceAddress.IDENTITY_RESOLVER.name())) != null) {
            options.setOption((ResourceOption)ResourceAddress.IDENTITY_RESOLVER, (Object)httpIdentityResolver);
        } else {
            Collection<Class<? extends Principal>> userPrincipalClasses = this.getUserPrincipalClasses((HttpRealmInfo[])optionsByName.remove(HttpResourceAddress.REALMS.name()));
            if (userPrincipalClasses != null && !userPrincipalClasses.isEmpty()) {
                httpIdentityResolver = new HttpIdentityResolver(userPrincipalClasses);
                options.setOption((ResourceOption)ResourceAddress.IDENTITY_RESOLVER, (Object)httpIdentityResolver);
            }
        }
    }

    private Collection<Class<? extends Principal>> getUserPrincipalClasses(HttpRealmInfo[] realms) {
        if (realms != null && realms.length > 0) {
            if (realms.length == 1) {
                return realms[0].getUserPrincipleClasses();
            }
            return Arrays.stream(realms).map(r -> r.getUserPrincipleClasses()).filter(upc -> upc != null).flatMap(upc -> upc.stream()).collect(Collectors.toList());
        }
        return Collections.emptySet();
    }

    protected void setAlternateOption(String location, ResourceOptions options, Map<String, Object> optionsByName) {
        List<ResourceFactory> resourceFactories;
        boolean secureScheme;
        String key = (String)options.getOption(HttpResourceAddress.NEXT_PROTOCOL);
        String scheme = URIUtils.getScheme((String)location);
        boolean bl = secureScheme = "https".equals(scheme) || scheme.contains("+ssl");
        if (key != null && secureScheme) {
            key = key + " secure";
        }
        if ((resourceFactories = RESOURCE_FACTORIES_BY_KEY.get(key)) != null && !resourceFactories.isEmpty() && this.getResourceAddressFactory() != null) {
            HttpResourceAddress alternateAddress = null;
            for (ResourceFactory resourceFactory : resourceFactories) {
                alternateAddress = (HttpResourceAddress)this.newResourceAddressWithAlternate(resourceFactory.createURI(location), this.getNewOptionsByName(options, optionsByName), alternateAddress);
            }
            options.setOption(ResourceAddress.ALTERNATE, alternateAddress);
        }
    }

    protected HttpResourceAddress newResourceAddress0(String original, String location) {
        String host = URIUtils.getHost((String)location);
        int port = URIUtils.getPort((String)location);
        String path = URIUtils.getPath((String)location);
        if (host == null) {
            throw new IllegalArgumentException(String.format("Missing host in URI: %s", location));
        }
        if (port == -1) {
            throw new IllegalArgumentException(String.format("Missing port in URI: %s", location));
        }
        if (path == null || path.length() == 0) {
            throw new IllegalArgumentException(String.format("Missing path in URI: %s", location));
        }
        URI uriLocation = URI.create(location);
        return new HttpResourceAddress(this, original, uriLocation);
    }

    protected void setOptions(HttpResourceAddress address, ResourceOptions options, Object qualifier) {
        Collection<Class<? extends Principal>> realmUserPrincipalClasses;
        super.setOptions((ResourceAddress)address, options, qualifier);
        address.setOption0(HttpResourceAddress.KEEP_ALIVE, options.getOption(HttpResourceAddress.KEEP_ALIVE));
        address.setOption0(HttpResourceAddress.MAXIMUM_REDIRECTS, options.getOption(HttpResourceAddress.MAXIMUM_REDIRECTS));
        address.setOption0(HttpResourceAddress.KEEP_ALIVE_TIMEOUT, options.getOption(HttpResourceAddress.KEEP_ALIVE_TIMEOUT));
        address.setOption0(HttpResourceAddress.KEEP_ALIVE_CONNECTIONS, options.getOption(HttpResourceAddress.KEEP_ALIVE_CONNECTIONS));
        address.setOption0(HttpResourceAddress.REQUIRED_ROLES, options.getOption(HttpResourceAddress.REQUIRED_ROLES));
        address.setOption0(HttpResourceAddress.INJECTABLE_HEADERS, options.getOption(HttpResourceAddress.INJECTABLE_HEADERS));
        address.setOption0(HttpResourceAddress.ORIGIN_SECURITY, options.getOption(HttpResourceAddress.ORIGIN_SECURITY));
        address.setOption0(HttpResourceAddress.TEMP_DIRECTORY, options.getOption(HttpResourceAddress.TEMP_DIRECTORY));
        address.setOption0(HttpResourceAddress.GATEWAY_ORIGIN_SECURITY, options.getOption(HttpResourceAddress.GATEWAY_ORIGIN_SECURITY));
        address.setOption0(HttpResourceAddress.BALANCE_ORIGINS, options.getOption(HttpResourceAddress.BALANCE_ORIGINS));
        address.setOption0(HttpResourceAddress.AUTHENTICATION_CONNECT, options.getOption(HttpResourceAddress.AUTHENTICATION_CONNECT));
        address.setOption0(HttpResourceAddress.AUTHENTICATION_IDENTIFIER, options.getOption(HttpResourceAddress.AUTHENTICATION_IDENTIFIER));
        address.setOption0(HttpResourceAddress.ENCRYPTION_KEY_ALIAS, options.getOption(HttpResourceAddress.ENCRYPTION_KEY_ALIAS));
        address.setOption0(HttpResourceAddress.SERVICE_DOMAIN, options.getOption(HttpResourceAddress.SERVICE_DOMAIN));
        address.setOption0(HttpResourceAddress.SERVER_HEADER_ENABLED, options.getOption(HttpResourceAddress.SERVER_HEADER_ENABLED));
        address.setOption0(HttpResourceAddress.USER_AGENT_HEADER_ENABLED, options.getOption(HttpResourceAddress.USER_AGENT_HEADER_ENABLED));
        address.setOption0(HttpResourceAddress.HOST_HEADER_ENABLED, options.getOption(HttpResourceAddress.HOST_HEADER_ENABLED));
        address.setOption0(HttpResourceAddress.DATE_HEADER_ENABLED, options.getOption(HttpResourceAddress.DATE_HEADER_ENABLED));
        address.setOption0(HttpResourceAddress.MAX_AUTHENTICATION_ATTEMPTS, options.getOption(HttpResourceAddress.MAX_AUTHENTICATION_ATTEMPTS));
        address.setOption0(HttpResourceAddress.REALMS, options.getOption(HttpResourceAddress.REALMS));
        if (address.getOption((ResourceOption)ResourceAddress.IDENTITY_RESOLVER) == null && (realmUserPrincipalClasses = this.getUserPrincipalClasses((HttpRealmInfo[])address.getOption(HttpResourceAddress.REALMS))) != null && !realmUserPrincipalClasses.isEmpty()) {
            HttpIdentityResolver httpIdentityResolver = new HttpIdentityResolver(realmUserPrincipalClasses);
            address.setIdentityResolver((ResourceAddress.DefaultResourceOption<IdentityResolver>)ResourceAddress.IDENTITY_RESOLVER, httpIdentityResolver);
        }
    }

    static {
        List<ResourceFactory> insecureAlternateResourceFactories = Collections.singletonList(ResourceFactories.changeSchemeOnly((String)"httpxe"));
        List<ResourceFactory> secureAlternateResourceFactories = Collections.singletonList(ResourceFactories.changeSchemeOnly((String)"httpxe+ssl"));
        RESOURCE_FACTORIES_BY_KEY.put("wse/1.0", insecureAlternateResourceFactories);
        RESOURCE_FACTORIES_BY_KEY.put("wse/1.0 secure", secureAlternateResourceFactories);
    }
}

