/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.resource.address.http;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.kaazing.gateway.security.CrossSiteConstraintContext;

public class HttpOriginSecurity {
    private final Map<String, HttpOriginConstraint> constraints;

    public HttpOriginSecurity(Map<String, ? extends CrossSiteConstraintContext> acceptConstraints) {
        if (acceptConstraints == null) {
            throw new NullPointerException("acceptConstraints");
        }
        HashMap<String, HttpOriginConstraint> constraints = new HashMap<String, HttpOriginConstraint>();
        for (Map.Entry<String, ? extends CrossSiteConstraintContext> entry : acceptConstraints.entrySet()) {
            String sourceOrigin = entry.getKey();
            CrossSiteConstraintContext originConstraint = entry.getValue();
            constraints.put(sourceOrigin, new HttpOriginConstraint(originConstraint));
        }
        this.constraints = Collections.unmodifiableMap(constraints);
    }

    public Collection<String> getSourceOrigins() {
        return this.constraints.keySet();
    }

    public HttpOriginConstraint getConstraint(String sourceOrigin) {
        return this.constraints.get(sourceOrigin);
    }

    public static final class HttpOriginConstraint {
        private final CrossSiteConstraintContext constraint;

        HttpOriginConstraint(CrossSiteConstraintContext constraint) {
            this.constraint = constraint;
        }

        public String getAllowOrigin() {
            return this.constraint.getAllowOrigin();
        }

        public String getAllowMethods() {
            return this.constraint.getAllowMethods();
        }

        public String getAllowHeaders() {
            return this.constraint.getAllowHeaders();
        }

        public Integer getMaximumAge() {
            return this.constraint.getMaximumAge();
        }
    }
}

