/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.resource.address.http;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kaazing.gateway.resource.address.IdentityResolver;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.resource.address.ResourceAddressFactorySpi;
import org.kaazing.gateway.resource.address.ResourceFactories;
import org.kaazing.gateway.resource.address.ResourceFactory;
import org.kaazing.gateway.resource.address.ResourceOption;
import org.kaazing.gateway.resource.address.ResourceOptions;
import org.kaazing.gateway.resource.address.http.GatewayHttpOriginSecurity;
import org.kaazing.gateway.resource.address.http.HttpIdentityResolver;
import org.kaazing.gateway.resource.address.http.HttpOriginSecurity;
import org.kaazing.gateway.resource.address.http.HttpResourceAddress;
import org.kaazing.gateway.resource.address.uri.URIUtils;
import org.kaazing.gateway.security.LoginContextFactory;

public class HttpResourceAddressFactorySpi
extends ResourceAddressFactorySpi<HttpResourceAddress> {
    public static final int SCHEME_PORT = 80;
    private static final String SCHEME_NAME = "http";
    private static final ResourceFactory TRANSPORT_FACTORY = ResourceFactories.keepAuthorityOnly((String)"tcp");
    private static final String PROTOCOL_NAME = "http/1.1";
    private static final Map<String, List<ResourceFactory>> RESOURCE_FACTORIES_BY_KEY = new HashMap<String, List<ResourceFactory>>();

    public String getSchemeName() {
        return SCHEME_NAME;
    }

    protected int getSchemePort() {
        return 80;
    }

    protected String getTransportName() {
        return SCHEME_NAME;
    }

    protected ResourceFactory getTransportFactory() {
        return TRANSPORT_FACTORY;
    }

    protected String getProtocolName() {
        return PROTOCOL_NAME;
    }

    protected void parseNamedOptions0(String location, ResourceOptions options, Map<String, Object> optionsByName) {
        IdentityResolver httpIdentityResolver;
        Collection realmUserPrincipalClasses;
        Boolean serverHeaderEnabled;
        Collection balanceOrigin;
        List authorityToSetOfAcceptConstraintsByURI;
        File tempDirectory;
        Map acceptConstraints;
        Set injectableHeaders;
        String serviceDomain;
        String encryptionKeyAlias;
        String authenticationIdentifier;
        String authenticationConnect;
        LoginContextFactory loginContextFactory;
        String[] realmAuthenticationCookieNames;
        String[] realmAuthenticationParameterNames;
        String[] realmAuthenticationHeaderNames;
        String realmDescription;
        String realmChallengeScheme;
        String realmAuthorizationMode;
        String realmName;
        String[] requiredRoles;
        Integer keepAliveConnections;
        Integer keepAliveTimeout;
        Object maxRedirects;
        Boolean keepAlive = (Boolean)optionsByName.remove(HttpResourceAddress.KEEP_ALIVE.name());
        if (keepAlive != null) {
            options.setOption(HttpResourceAddress.KEEP_ALIVE, (Object)keepAlive);
        }
        if ((maxRedirects = optionsByName.remove(HttpResourceAddress.MAXIMUM_REDIRECTS.name())) != null) {
            options.setOption(HttpResourceAddress.MAXIMUM_REDIRECTS, (Object)(maxRedirects instanceof String ? Integer.parseInt((String)maxRedirects) : (Integer)maxRedirects));
        }
        if ((keepAliveTimeout = (Integer)optionsByName.remove(HttpResourceAddress.KEEP_ALIVE_TIMEOUT.name())) != null) {
            options.setOption(HttpResourceAddress.KEEP_ALIVE_TIMEOUT, (Object)keepAliveTimeout);
        }
        if ((keepAliveConnections = (Integer)optionsByName.remove(HttpResourceAddress.KEEP_ALIVE_CONNECTIONS.name())) != null) {
            options.setOption(HttpResourceAddress.KEEP_ALIVE_CONNECTIONS, (Object)keepAliveConnections);
        }
        if ((requiredRoles = (String[])optionsByName.remove(HttpResourceAddress.REQUIRED_ROLES.name())) != null) {
            options.setOption(HttpResourceAddress.REQUIRED_ROLES, (Object)requiredRoles);
        }
        if ((realmName = (String)optionsByName.remove(HttpResourceAddress.REALM_NAME.name())) != null) {
            options.setOption(HttpResourceAddress.REALM_NAME, (Object)realmName);
        }
        if ((realmAuthorizationMode = (String)optionsByName.remove(HttpResourceAddress.REALM_AUTHORIZATION_MODE.name())) != null) {
            options.setOption(HttpResourceAddress.REALM_AUTHORIZATION_MODE, (Object)realmAuthorizationMode);
        }
        if ((realmChallengeScheme = (String)optionsByName.remove(HttpResourceAddress.REALM_CHALLENGE_SCHEME.name())) != null) {
            options.setOption(HttpResourceAddress.REALM_CHALLENGE_SCHEME, (Object)realmChallengeScheme);
        }
        if ((realmDescription = (String)optionsByName.remove(HttpResourceAddress.REALM_DESCRIPTION.name())) != null) {
            options.setOption(HttpResourceAddress.REALM_DESCRIPTION, (Object)realmDescription);
        }
        if ((realmAuthenticationHeaderNames = (String[])optionsByName.remove(HttpResourceAddress.REALM_AUTHENTICATION_HEADER_NAMES.name())) != null) {
            options.setOption(HttpResourceAddress.REALM_AUTHENTICATION_HEADER_NAMES, (Object)realmAuthenticationHeaderNames);
        }
        if ((realmAuthenticationParameterNames = (String[])optionsByName.remove(HttpResourceAddress.REALM_AUTHENTICATION_PARAMETER_NAMES.name())) != null) {
            options.setOption(HttpResourceAddress.REALM_AUTHENTICATION_PARAMETER_NAMES, (Object)realmAuthenticationParameterNames);
        }
        if ((realmAuthenticationCookieNames = (String[])optionsByName.remove(HttpResourceAddress.REALM_AUTHENTICATION_COOKIE_NAMES.name())) != null) {
            options.setOption(HttpResourceAddress.REALM_AUTHENTICATION_COOKIE_NAMES, (Object)realmAuthenticationCookieNames);
        }
        if ((loginContextFactory = (LoginContextFactory)optionsByName.remove(HttpResourceAddress.LOGIN_CONTEXT_FACTORY.name())) != null) {
            options.setOption(HttpResourceAddress.LOGIN_CONTEXT_FACTORY, (Object)loginContextFactory);
        }
        if ((authenticationConnect = (String)optionsByName.remove(HttpResourceAddress.AUTHENTICATION_CONNECT.name())) != null) {
            options.setOption(HttpResourceAddress.AUTHENTICATION_CONNECT, (Object)authenticationConnect);
        }
        if ((authenticationIdentifier = (String)optionsByName.remove(HttpResourceAddress.AUTHENTICATION_IDENTIFIER.name())) != null) {
            options.setOption(HttpResourceAddress.AUTHENTICATION_IDENTIFIER, (Object)authenticationIdentifier);
        }
        if ((encryptionKeyAlias = (String)optionsByName.remove(HttpResourceAddress.ENCRYPTION_KEY_ALIAS.name())) != null) {
            options.setOption(HttpResourceAddress.ENCRYPTION_KEY_ALIAS, (Object)encryptionKeyAlias);
        }
        if ((serviceDomain = (String)optionsByName.remove(HttpResourceAddress.SERVICE_DOMAIN.name())) != null) {
            options.setOption(HttpResourceAddress.SERVICE_DOMAIN, (Object)serviceDomain);
        }
        if ((injectableHeaders = (Set)optionsByName.remove(HttpResourceAddress.INJECTABLE_HEADERS.name())) != null) {
            options.setOption(HttpResourceAddress.INJECTABLE_HEADERS, (Object)injectableHeaders);
        }
        if ((acceptConstraints = (Map)optionsByName.remove(HttpResourceAddress.ORIGIN_SECURITY.name())) != null) {
            options.setOption(HttpResourceAddress.ORIGIN_SECURITY, (Object)new HttpOriginSecurity(acceptConstraints));
        }
        if ((tempDirectory = (File)optionsByName.remove(HttpResourceAddress.TEMP_DIRECTORY.name())) != null) {
            options.setOption(HttpResourceAddress.TEMP_DIRECTORY, (Object)tempDirectory);
        }
        if ((authorityToSetOfAcceptConstraintsByURI = (List)optionsByName.remove(HttpResourceAddress.GATEWAY_ORIGIN_SECURITY.name())) != null) {
            options.setOption(HttpResourceAddress.GATEWAY_ORIGIN_SECURITY, (Object)new GatewayHttpOriginSecurity(authorityToSetOfAcceptConstraintsByURI));
        }
        if ((balanceOrigin = (Collection)optionsByName.remove(HttpResourceAddress.BALANCE_ORIGINS.name())) != null) {
            options.setOption(HttpResourceAddress.BALANCE_ORIGINS, (Object)balanceOrigin);
        }
        if ((serverHeaderEnabled = (Boolean)optionsByName.remove(HttpResourceAddress.SERVER_HEADER_ENABLED.name())) != null) {
            options.setOption(HttpResourceAddress.SERVER_HEADER_ENABLED, (Object)serverHeaderEnabled);
        }
        if ((realmUserPrincipalClasses = (Collection)optionsByName.remove(HttpResourceAddress.REALM_USER_PRINCIPAL_CLASSES.name())) != null) {
            options.setOption(HttpResourceAddress.REALM_USER_PRINCIPAL_CLASSES, (Object)realmUserPrincipalClasses);
        }
        if ((httpIdentityResolver = (IdentityResolver)optionsByName.remove(ResourceAddress.IDENTITY_RESOLVER.name())) != null) {
            options.setOption((ResourceOption)ResourceAddress.IDENTITY_RESOLVER, (Object)httpIdentityResolver);
        } else if (realmUserPrincipalClasses != null && realmUserPrincipalClasses.size() > 0) {
            httpIdentityResolver = new HttpIdentityResolver(realmUserPrincipalClasses);
            options.setOption((ResourceOption)ResourceAddress.IDENTITY_RESOLVER, (Object)httpIdentityResolver);
        }
    }

    protected void setAlternateOption(String location, ResourceOptions options, Map<String, Object> optionsByName) {
        List<ResourceFactory> resourceFactories;
        boolean secureScheme;
        String key = (String)options.getOption(HttpResourceAddress.NEXT_PROTOCOL);
        String scheme = URIUtils.getScheme((String)location);
        boolean bl = secureScheme = "https".equals(scheme) || scheme.contains("+ssl");
        if (key != null && secureScheme) {
            key = key + " secure";
        }
        if ((resourceFactories = RESOURCE_FACTORIES_BY_KEY.get(key)) != null && !resourceFactories.isEmpty() && this.getResourceAddressFactory() != null) {
            HttpResourceAddress alternateAddress = null;
            for (ResourceFactory resourceFactory : resourceFactories) {
                alternateAddress = (HttpResourceAddress)this.newResourceAddressWithAlternate(resourceFactory.createURI(location), this.getNewOptionsByName(options, optionsByName), alternateAddress);
            }
            options.setOption(ResourceAddress.ALTERNATE, alternateAddress);
        }
    }

    protected HttpResourceAddress newResourceAddress0(String original, String location) {
        String host = URIUtils.getHost((String)location);
        int port = URIUtils.getPort((String)location);
        String path = URIUtils.getPath((String)location);
        if (host == null) {
            throw new IllegalArgumentException(String.format("Missing host in URI: %s", location));
        }
        if (port == -1) {
            throw new IllegalArgumentException(String.format("Missing port in URI: %s", location));
        }
        if (path == null || path.length() == 0) {
            throw new IllegalArgumentException(String.format("Missing path in URI: %s", location));
        }
        URI uriLocation = URI.create(location);
        return new HttpResourceAddress(this, original, uriLocation);
    }

    protected void setOptions(HttpResourceAddress address, ResourceOptions options, Object qualifier) {
        Collection realmUserPrincipalClasses;
        super.setOptions((ResourceAddress)address, options, qualifier);
        address.setOption0(HttpResourceAddress.KEEP_ALIVE, options.getOption(HttpResourceAddress.KEEP_ALIVE));
        address.setOption0(HttpResourceAddress.MAXIMUM_REDIRECTS, options.getOption(HttpResourceAddress.MAXIMUM_REDIRECTS));
        address.setOption0(HttpResourceAddress.KEEP_ALIVE_TIMEOUT, options.getOption(HttpResourceAddress.KEEP_ALIVE_TIMEOUT));
        address.setOption0(HttpResourceAddress.KEEP_ALIVE_CONNECTIONS, options.getOption(HttpResourceAddress.KEEP_ALIVE_CONNECTIONS));
        address.setOption0(HttpResourceAddress.REQUIRED_ROLES, options.getOption(HttpResourceAddress.REQUIRED_ROLES));
        address.setOption0(HttpResourceAddress.REALM_NAME, options.getOption(HttpResourceAddress.REALM_NAME));
        address.setOption0(HttpResourceAddress.REALM_AUTHORIZATION_MODE, options.getOption(HttpResourceAddress.REALM_AUTHORIZATION_MODE));
        address.setOption0(HttpResourceAddress.REALM_CHALLENGE_SCHEME, options.getOption(HttpResourceAddress.REALM_CHALLENGE_SCHEME));
        address.setOption0(HttpResourceAddress.REALM_DESCRIPTION, options.getOption(HttpResourceAddress.REALM_DESCRIPTION));
        address.setOption0(HttpResourceAddress.REALM_AUTHENTICATION_HEADER_NAMES, options.getOption(HttpResourceAddress.REALM_AUTHENTICATION_HEADER_NAMES));
        address.setOption0(HttpResourceAddress.REALM_AUTHENTICATION_PARAMETER_NAMES, options.getOption(HttpResourceAddress.REALM_AUTHENTICATION_PARAMETER_NAMES));
        address.setOption0(HttpResourceAddress.REALM_AUTHENTICATION_COOKIE_NAMES, options.getOption(HttpResourceAddress.REALM_AUTHENTICATION_COOKIE_NAMES));
        address.setOption0(HttpResourceAddress.LOGIN_CONTEXT_FACTORY, options.getOption(HttpResourceAddress.LOGIN_CONTEXT_FACTORY));
        address.setOption0(HttpResourceAddress.INJECTABLE_HEADERS, options.getOption(HttpResourceAddress.INJECTABLE_HEADERS));
        address.setOption0(HttpResourceAddress.ORIGIN_SECURITY, options.getOption(HttpResourceAddress.ORIGIN_SECURITY));
        address.setOption0(HttpResourceAddress.TEMP_DIRECTORY, options.getOption(HttpResourceAddress.TEMP_DIRECTORY));
        address.setOption0(HttpResourceAddress.GATEWAY_ORIGIN_SECURITY, options.getOption(HttpResourceAddress.GATEWAY_ORIGIN_SECURITY));
        address.setOption0(HttpResourceAddress.BALANCE_ORIGINS, options.getOption(HttpResourceAddress.BALANCE_ORIGINS));
        address.setOption0(HttpResourceAddress.AUTHENTICATION_CONNECT, options.getOption(HttpResourceAddress.AUTHENTICATION_CONNECT));
        address.setOption0(HttpResourceAddress.AUTHENTICATION_IDENTIFIER, options.getOption(HttpResourceAddress.AUTHENTICATION_IDENTIFIER));
        address.setOption0(HttpResourceAddress.ENCRYPTION_KEY_ALIAS, options.getOption(HttpResourceAddress.ENCRYPTION_KEY_ALIAS));
        address.setOption0(HttpResourceAddress.SERVICE_DOMAIN, options.getOption(HttpResourceAddress.SERVICE_DOMAIN));
        address.setOption0(HttpResourceAddress.SERVER_HEADER_ENABLED, options.getOption(HttpResourceAddress.SERVER_HEADER_ENABLED));
        address.setOption0(HttpResourceAddress.REALM_USER_PRINCIPAL_CLASSES, options.getOption(HttpResourceAddress.REALM_USER_PRINCIPAL_CLASSES));
        if (address.getOption((ResourceOption)ResourceAddress.IDENTITY_RESOLVER) == null && (realmUserPrincipalClasses = (Collection)address.getOption(HttpResourceAddress.REALM_USER_PRINCIPAL_CLASSES)) != null && realmUserPrincipalClasses.size() > 0) {
            HttpIdentityResolver httpIdentityResolver = new HttpIdentityResolver(realmUserPrincipalClasses);
            address.setIdentityResolver((ResourceAddress.DefaultResourceOption<IdentityResolver>)ResourceAddress.IDENTITY_RESOLVER, httpIdentityResolver);
        }
    }

    static {
        List<ResourceFactory> insecureAlternateResourceFactories = Collections.singletonList(ResourceFactories.changeSchemeOnly((String)"httpxe"));
        List<ResourceFactory> secureAlternateResourceFactories = Collections.singletonList(ResourceFactories.changeSchemeOnly((String)"httpxe+ssl"));
        RESOURCE_FACTORIES_BY_KEY.put("wse/1.0", insecureAlternateResourceFactories);
        RESOURCE_FACTORIES_BY_KEY.put("wse/1.0 secure", secureAlternateResourceFactories);
    }
}

